/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MasterMode
extends BaseMode<ITrack> {
    private static final String TAG_VOLUME = "Volume";
    private final IMasterTrack masterTrack;
    private final IProject project;
    private final PushConfiguration configuration;

    public MasterMode(PushControlSurface surface, IModel model, boolean isTemporary) {
        super("Master", surface, model);
        this.configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        this.masterTrack = this.model.getMasterTrack();
        this.project = this.model.getProject();
        this.setParameterProvider(new FixedParameterProvider(this.masterTrack.getVolumeParameter(), this.masterTrack.getPanParameter(), this.project.getCueVolumeParameter(), this.project.getCueMixParameter(), EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE));
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.setActive(false);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            switch (index) {
                case 0: {
                    this.masterTrack.resetVolume();
                    break;
                }
                case 1: {
                    this.masterTrack.resetPan();
                    break;
                }
                case 2: {
                    this.project.resetCueVolume();
                    break;
                }
                case 3: {
                    this.project.resetCueMix();
                    break;
                }
            }
        }
        switch (index) {
            case 0: {
                this.masterTrack.touchVolume(isTouched);
                break;
            }
            case 1: {
                this.masterTrack.touchPan(isTouched);
                break;
            }
            case 2: {
                this.project.touchCueVolume(isTouched);
                break;
            }
            case 3: {
                this.project.touchCueMix(isTouched);
                break;
            }
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        boolean canEditCueVolume = this.model.getHost().supports(Capability.CUE_VOLUME);
        int upperBound = this.model.getValueChanger().getUpperBound();
        display.setCell(0, 0, TAG_VOLUME).setCell(0, 1, "Pan");
        if (canEditCueVolume) {
            display.setCell(0, 2, TAG_VOLUME).setCell(0, 3, "Mix");
        }
        display.setCell(0, 6, "Load").setCell(0, 7, "Save").setCell(1, 6, "Project:");
        display.setCell(1, 0, this.masterTrack.getVolumeStr(8)).setCell(1, 1, this.masterTrack.getPanStr(8));
        if (canEditCueVolume) {
            display.setCell(1, 2, this.project.getCueVolumeStr(8)).setCell(1, 3, this.project.getCueMixStr(8));
        }
        display.setBlock(1, 2, "Audio Engine").setBlock(2, 3, this.project.getName());
        display.setCell(2, 0, this.configuration.isEnableVUMeters() ? Push1Display.formatValue(this.masterTrack.getVolume(), this.masterTrack.getVu(), upperBound) : Push1Display.formatValue(this.masterTrack.getVolume(), upperBound));
        display.setCell(2, 1, this.masterTrack.getPan(), Format.FORMAT_PAN);
        if (canEditCueVolume) {
            display.setCell(2, 2, this.project.getCueVolume(), Format.FORMAT_VALUE);
            display.setCell(2, 3, this.project.getCueMix(), Format.FORMAT_VALUE);
            display.setCell(3, 0, this.masterTrack.getName()).setCell(3, 2, "Cue");
        }
        display.setCell(3, 4, this.model.getApplication().isEngineActive() ? "Active" : "Off");
        display.setCell(3, 6, "Previous").setCell(3, 7, "Next");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        IValueChanger valueChanger = this.model.getValueChanger();
        boolean enableVUMeters = this.configuration.isEnableVUMeters();
        int vuR = valueChanger.toDisplayValue(enableVUMeters ? this.masterTrack.getVuRight() : 0);
        int vuL = valueChanger.toDisplayValue(enableVUMeters ? this.masterTrack.getVuLeft() : 0);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        display.addChannelElement(TAG_VOLUME, false, this.masterTrack.getName(), ChannelType.MASTER, this.masterTrack.getColor(), this.masterTrack.isSelected(), valueChanger.toDisplayValue(this.masterTrack.getVolume()), valueChanger.toDisplayValue(this.masterTrack.getModulatedVolume()), this.isKnobTouched(0) ? this.masterTrack.getVolumeStr(8) : "", valueChanger.toDisplayValue(this.masterTrack.getPan()), valueChanger.toDisplayValue(this.masterTrack.getModulatedPan()), this.isKnobTouched(1) ? this.masterTrack.getPanStr(8) : "", vuL, vuR, this.masterTrack.isMute(), this.masterTrack.isSolo(), this.masterTrack.isRecArm(), this.masterTrack.isActivated(), 0, this.masterTrack.isSelected() && cursorTrack.isPinned());
        display.addChannelSelectorElement("Pan", false, "", null, ColorEx.BLACK, false, this.masterTrack.isActivated());
        if (this.model.getHost().supports(Capability.CUE_VOLUME)) {
            display.addChannelElement("Cue Volume", false, "Cue", ChannelType.CUE, ColorEx.GRAY, false, valueChanger.toDisplayValue(this.project.getCueVolume()), -1, this.isKnobTouched(2) ? this.project.getCueVolumeStr(8) : "", valueChanger.toDisplayValue(this.project.getCueMix()), -1, this.isKnobTouched(3) ? this.project.getCueMixStr(8) : "", 0, 0, false, false, false, true, 0, false);
            display.addChannelSelectorElement("Cue Mix", false, "", null, ColorEx.BLACK, false, true);
        } else {
            display.addOptionElement("", " ", false, "", "", false, true);
            display.addOptionElement("", " ", false, "", "", false, true);
        }
        display.addOptionElement("", " ", false, "Audio Engine", this.model.getApplication().isEngineActive() ? "Active" : "Off", false, true);
        display.addOptionElement("", " ", false, "", "", false, true);
        display.addOptionElement("Project:", "Load", false, this.project.getName(), "Previous", false, true);
        display.addOptionElement("", "Save", false, "", "Next", false, true);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((PushControlSurface)this.surface).isPressed(ButtonID.RECORD)) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.RECORD);
            this.masterTrack.toggleRecArm();
            return;
        }
        switch (index) {
            case 0: {
                ((PushControlSurface)this.surface).getButton(ButtonID.DEVICE).trigger(ButtonEvent.DOWN);
                break;
            }
            case 4: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 6: {
                this.project.previous();
                break;
            }
            case 7: {
                this.project.next();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        boolean isPush2 = this.configuration.isPushModern();
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            ColorManager colorManager = this.model.getColorManager();
            if (index == 0) {
                return this.getTrackButtonColor();
            }
            if (index < 4 || index == 5) {
                return colorManager.getColorIndex("BUTTON_COLOR_OFF");
            }
            if (index > 5) {
                return colorManager.getColorIndex("BUTTON_COLOR_ON");
            }
            int red = isPush2 ? 5 : 4;
            return this.model.getApplication().isEngineActive() ? colorManager.getColorIndex("BUTTON_COLOR_ON") : red;
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            int off = this.isPushModern ? 0 : 0;
            switch (index) {
                case 0: {
                    boolean muteState;
                    if (this.isPushModern) break;
                    boolean bl = muteState = this.configuration.getLockState() == PushConfiguration.LockState.MUTE;
                    if (muteState) {
                        return this.masterTrack.isMute() ? off : 13;
                    }
                    return this.masterTrack.isSolo() ? 45 : 1;
                }
                case 6: {
                    return isPush2 ? 21 : 22;
                }
                case 7: {
                    if (this.project.isDirty()) {
                        return isPush2 ? 9 : 10;
                    }
                    return isPush2 ? 23 : 19;
                }
            }
            return off;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 0: {
                if (this.isPushModern) break;
                if (this.configuration.getLockState() == PushConfiguration.LockState.MUTE) {
                    this.masterTrack.toggleMute();
                    break;
                }
                this.masterTrack.toggleSolo();
                break;
            }
            case 6: {
                this.project.load();
                break;
            }
            case 7: {
                this.project.save();
                break;
            }
        }
    }

    private int getTrackButtonColor() {
        if (!this.masterTrack.isActivated()) {
            return this.isPushModern ? 0 : 0;
        }
        if (this.masterTrack.isRecArm()) {
            return this.isPushModern ? 5 : 4;
        }
        return this.isPushModern ? 9 : 10;
    }

    private void setActive(boolean enable) {
        this.masterTrack.setVolumeIndication(enable);
        this.masterTrack.setPanIndication(enable);
    }
}

