/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.nativefiledialogs.macos;

import de.mossgrabers.nativefiledialogs.AbstractNativeFileDialogs;
import de.mossgrabers.nativefiledialogs.FileFilter;
import de.mossgrabers.nativefiledialogs.ProcessResult;
import java.io.File;
import java.io.IOException;

public class NativeMacosFileDialogs
extends AbstractNativeFileDialogs {
    private static final String FOLDER_START = "tell application \"Finder\"\nActivate\ntry\nPOSIX path of ( choose folder ";
    private static final String OPEN_START = "tell application \"Finder\"\nActivate\ntry\nPOSIX path of ( choose file ";
    private static final String SAVE_START = "tell application \"Finder\"\nActivate\ntry\nPOSIX path of ( choose file name ";
    private static final String END = ")\non error number -128\nend try\nend tell";

    public NativeMacosFileDialogs(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    public File selectFile(String title, FileFilter ... filters) throws IOException {
        StringBuilder applescriptCommand = new StringBuilder(OPEN_START);
        this.addTitleAndDirectory(applescriptCommand, title, false, false);
        if (filters.length > 0) {
            String[] extensions;
            applescriptCommand.append("of type {\"");
            applescriptCommand.append(filters[0].getLabel());
            applescriptCommand.append("\"");
            for (String extension : extensions = filters[0].getExtensions()) {
                applescriptCommand.append(",\"");
                applescriptCommand.append(extension);
                applescriptCommand.append("\"");
            }
            applescriptCommand.append("} ");
        }
        applescriptCommand.append(END);
        String filename = NativeMacosFileDialogs.runApplescript(applescriptCommand.toString());
        return filename.isEmpty() ? null : new File(filename);
    }

    @Override
    public File selectNewFile(String title, FileFilter ... filters) throws IOException {
        StringBuilder applescriptCommand = new StringBuilder(SAVE_START);
        this.addTitleAndDirectory(applescriptCommand, title, false, true);
        applescriptCommand.append(END);
        String filename = NativeMacosFileDialogs.runApplescript(applescriptCommand.toString());
        return filename.isEmpty() ? null : new File(filename);
    }

    @Override
    public File selectFolder(String title) throws IOException {
        StringBuilder applescriptCommand = new StringBuilder(FOLDER_START);
        this.addTitleAndDirectory(applescriptCommand, title, true, false);
        applescriptCommand.append(END);
        String filename = NativeMacosFileDialogs.runApplescript(applescriptCommand.toString());
        return filename.isEmpty() ? null : new File(filename);
    }

    private void addTitleAndDirectory(StringBuilder applescriptCommand, String title, boolean onlyFolder, boolean addFilename) {
        if (title != null && !title.isEmpty()) {
            applescriptCommand.append(String.format("with prompt \"%s\" ", title));
        }
        if (this.currentDirectory == null) {
            return;
        }
        File dir = this.currentDirectory;
        if (!dir.exists()) {
            return;
        }
        if (onlyFolder) {
            dir = this.currentDirectory.isDirectory() ? this.currentDirectory : this.currentDirectory.getParentFile();
        }
        applescriptCommand.append(String.format("default location \"%s\" ", dir.getAbsolutePath()));
        if (addFilename && this.currentDirectory.isFile()) {
            applescriptCommand.append(String.format("default name \"%s\" ", this.currentDirectory.getName()));
        }
    }

    private static String runApplescript(String command) throws IOException {
        ProcessResult processResult = NativeMacosFileDialogs.executeProcess(new String[]{"osascript", "-e", command});
        String error = processResult.getError();
        if (!error.isEmpty()) {
            throw new IOException(error);
        }
        return processResult.getResult();
    }
}

