/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;

public class LoopStartParameter
extends AbstractParameterImpl {
    private final ITransport transport;
    private final IControlSurface<?> surface;

    public LoopStartParameter(IValueChanger valueChanger, ITransport transport, IControlSurface<?> surface) {
        super(valueChanger, 0);
        this.transport = transport;
        this.surface = surface;
    }

    @Override
    public int getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNormalizedValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        if (this.surface.isSelectPressed()) {
            this.transport.changeLoopLength(valueChanger.isIncrease(value), this.surface.isKnobSensitivitySlow());
        } else {
            this.transport.changeLoopStart(valueChanger.isIncrease(value), this.surface.isKnobSensitivitySlow());
        }
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        if (this.surface.isSelectPressed()) {
            this.transport.changeLoopLength(increment > 0.0, this.surface.isKnobSensitivitySlow());
        } else {
            this.transport.changeLoopStart(increment > 0.0, this.surface.isKnobSensitivitySlow());
        }
    }

    @Override
    public void resetValue() {
        this.setValue(0);
    }

    @Override
    public String getDisplayedValue() {
        return this.surface.isSelectPressed() ? this.transport.getLoopLengthBeatText() : this.transport.getLoopStartBeatText();
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return this.surface.isSelectPressed() ? "Loop Length" : "Loop Start";
    }
}

