/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.featuregroup;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.core.AftertouchCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.featuregroup.AbstractFeatureGroup;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ChordIdentifier;
import de.mossgrabers.framework.utils.KeyManager;

public abstract class AbstractView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractFeatureGroup<S, C>
implements IView {
    protected static final int[] EMPTY_TABLE = Scales.getEmptyMatrix();
    protected final Scales scales;
    protected final KeyManager keyManager;
    private String previousChord;
    private AftertouchCommand aftertouchCommand;

    protected AbstractView(String name, S surface, IModel model) {
        super(name, surface, model);
        this.scales = model.getScales();
        this.keyManager = new KeyManager(model, this.scales, surface.getPadGrid());
    }

    @Override
    public void onActivate() {
        this.updateNoteMapping();
    }

    @Override
    public void onDeactivate() {
    }

    @Override
    public void selectTrack(int index) {
        ((ITrack)this.model.getCurrentTrackBank().getItem(index)).select();
    }

    @Override
    public void updateControlSurface() {
        IView v;
        IMode m = (IMode)this.surface.getModeManager().getActive();
        if (m != null) {
            m.updateDisplay();
        }
        if ((v = (IView)this.surface.getViewManager().getActive()) != null) {
            this.displayChord();
        }
    }

    protected void displayChord() {
        if (!this.surface.getConfiguration().isShowPlayedChords()) {
            return;
        }
        String chord = this.getChordName();
        if (chord != null && !this.previousChord.equals(chord)) {
            this.surface.getDisplay().notify(chord);
            this.previousChord = chord;
            return;
        }
        this.previousChord = "";
    }

    protected String getChordName() {
        return ChordIdentifier.identifyChord(this.keyManager.getMidiNotesFromPressedKeys());
    }

    @Override
    public void registerAftertouchCommand(AftertouchCommand command) {
        this.aftertouchCommand = command;
    }

    @Override
    public void executeAftertouchCommand(int note, int value) {
        if (this.aftertouchCommand == null) {
            return;
        }
        if (note == -1) {
            this.aftertouchCommand.onChannelAftertouch(value);
        } else {
            this.aftertouchCommand.onPolyAftertouch(note, value);
        }
    }

    @Override
    public void onGridNoteLongPress(int note) {
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
    }

    protected String getPadColor(int pad, ITrack track) {
        return AbstractView.replaceOctaveColorWithTrackColor(track, this.keyManager.getColor(pad));
    }

    public static String replaceOctaveColorWithTrackColor(ITrack track, String colorID) {
        if ("SCALE_COLOR_OCTAVE".equals(colorID)) {
            if (track == null) {
                return "SCALE_COLOR_OCTAVE";
            }
            String c = DAWColor.getColorID(track.getColor());
            return c == null ? "SCALE_COLOR_OCTAVE" : c;
        }
        return colorID;
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(EMPTY_TABLE);
    }

    @Override
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    protected void delayedUpdateNoteMapping(int[] matrix) {
        this.surface.scheduleTask(() -> {
            this.keyManager.setNoteMatrix(matrix);
            if (matrix.length == 128) {
                this.surface.setKeyTranslationTable(this.scales.translateMatrixToGrid(matrix));
            }
        }, 6L);
    }

    protected void simulateButtonPress(ButtonID buttonID, int velocity) {
        IHwButton button = this.surface.getButton(buttonID);
        AbstractTriggerCommand triggerCommand = (AbstractTriggerCommand)button.getCommand();
        triggerCommand.execute(ButtonEvent.DOWN, velocity);
        if (velocity != 0) {
            triggerCommand.execute(ButtonEvent.UP, 0);
        }
    }

    protected void simulateNormalButtonPress(ButtonID buttonID) {
        IHwButton button = this.surface.getButton(buttonID);
        AbstractTriggerCommand triggerCommand = (AbstractTriggerCommand)button.getCommand();
        triggerCommand.executeNormal(ButtonEvent.DOWN);
        triggerCommand.executeNormal(ButtonEvent.UP);
    }

    protected void simulateShiftedButtonPress(ButtonID buttonID) {
        IHwButton button = this.surface.getButton(buttonID);
        AbstractTriggerCommand triggerCommand = (AbstractTriggerCommand)button.getCommand();
        triggerCommand.executeShifted(ButtonEvent.DOWN);
        triggerCommand.executeShifted(ButtonEvent.UP);
    }

    protected void onSceneButton(ButtonID buttonID, ButtonEvent event) {
        boolean isPressed;
        if (!ButtonID.isSceneButton(buttonID) || event == ButtonEvent.LONG) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        IScene scene = (IScene)this.model.getCurrentTrackBank().getSceneBank().getItem(index);
        boolean bl = isPressed = event == ButtonEvent.DOWN;
        if (isPressed) {
            if (this.handleSceneButtonCombinations(index, scene)) {
                return;
            }
            scene.select();
            this.surface.getDisplay().notify(scene.getName());
            if (this.isSceneSelectAction()) {
                return;
            }
        }
        scene.launch(isPressed, this.isSceneLaunchAlternateAction());
    }

    protected boolean isSceneLaunchAlternateAction() {
        return this.surface.isShiftPressed();
    }

    protected boolean isSceneSelectAction() {
        return this.surface.isSelectPressed();
    }

    protected boolean handleSceneButtonCombinations(int index, IScene scene) {
        if (this.isButtonCombination(ButtonID.DELETE)) {
            scene.remove();
            return true;
        }
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            scene.duplicate();
            return true;
        }
        return false;
    }
}

