/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.data.bank;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractBank<T>
implements IBank<T> {
    protected final IHost host;
    protected final List<T> items;
    protected final int pageSize;
    private final Set<IItemSelectionObserver> selectionObservers = new CopyOnWriteArraySet<IItemSelectionObserver>();
    private final Set<IBankPageObserver> pageObservers = new CopyOnWriteArraySet<IBankPageObserver>();

    protected AbstractBank(IHost host, int pageSize) {
        this(host, pageSize, new ArrayList(pageSize));
    }

    protected AbstractBank(IHost host, int pageSize, List<T> items) {
        this.host = host;
        this.pageSize = pageSize;
        this.items = items;
    }

    @Override
    public boolean hasExistingItems() {
        return true;
    }

    @Override
    public T getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void addSelectionObserver(IItemSelectionObserver observer) {
        this.selectionObservers.add(observer);
    }

    @Override
    public void removeSelectionObserver(IItemSelectionObserver observer) {
        this.selectionObservers.remove(observer);
    }

    @Override
    public void addPageObserver(IBankPageObserver observer) {
        this.pageObservers.add(observer);
    }

    @Override
    public void removePageObserver(IBankPageObserver observer) {
        this.pageObservers.remove(observer);
    }

    protected void notifySelectionObservers(int itemIndex, boolean isSelected) {
        this.host.scheduleTask(() -> {
            for (IItemSelectionObserver observer : this.selectionObservers) {
                observer.call(itemIndex, isSelected);
            }
        }, 100L);
    }

    @Override
    public void selectNextItem() {
    }

    @Override
    public void selectPreviousItem() {
    }

    @Override
    public void selectPreviousPage() {
    }

    @Override
    public void selectNextPage() {
    }

    @Override
    public void setSkipDisabledItems(boolean shouldSkip) {
    }

    public void firePageObserver() {
        this.pageObservers.forEach(IBankPageObserver::pageAdjusted);
    }
}

