/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.mode;

import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.ModeCursorCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;

public class CursorCommand<S extends IControlSurface<C>, C extends Configuration>
extends ModeCursorCommand<S, C> {
    public CursorCommand(Direction direction, IModel model, S surface, boolean notifySelection) {
        this(direction, model, surface, notifySelection, false);
    }

    public CursorCommand(Direction direction, IModel model, S surface, boolean notifySelection, boolean isFlipped) {
        super(direction, model, surface, notifySelection, isFlipped);
    }

    @Override
    protected void updateArrowStates() {
        boolean isShiftPressed = this.isShifted();
        this.scrollStates.setCanScrollUp(this.canSelectSceneItemOrPage(isShiftPressed, false));
        this.scrollStates.setCanScrollDown(this.canSelectSceneItemOrPage(isShiftPressed, true));
        this.scrollStates.setCanScrollLeft(this.canSelectItemOrPage(isShiftPressed, false));
        this.scrollStates.setCanScrollRight(this.canSelectItemOrPage(isShiftPressed, true));
    }

    @Override
    protected void scrollUp() {
        this.selectSceneItemOrPage(this.isShifted(), false);
    }

    @Override
    protected void scrollDown() {
        this.selectSceneItemOrPage(this.isShifted(), true);
    }

    @Override
    protected void scrollLeft() {
        this.selectItemOrPage(this.isShifted(), false);
    }

    @Override
    protected void scrollRight() {
        this.selectItemOrPage(this.isShifted(), true);
    }

    protected void selectSceneItemOrPage(boolean isPage, boolean isNext) {
        ISceneBank sceneBank = this.getSceneBank();
        if (sceneBank == null) {
            return;
        }
        if (isPage ^ this.isFlipped) {
            if (isNext) {
                sceneBank.selectNextPage();
            } else {
                sceneBank.selectPreviousPage();
            }
            return;
        }
        if (isNext) {
            sceneBank.scrollForwards();
        } else {
            sceneBank.scrollBackwards();
        }
    }

    protected boolean canSelectSceneItemOrPage(boolean isPage, boolean isNext) {
        ISceneBank sceneBank = this.getSceneBank();
        if (sceneBank == null) {
            return false;
        }
        if (isPage ^ this.isFlipped) {
            return isNext ? sceneBank.canScrollPageForwards() : sceneBank.canScrollPageBackwards();
        }
        return isNext ? sceneBank.canScrollForwards() : sceneBank.canScrollBackwards();
    }

    protected ISceneBank getSceneBank() {
        return this.model.getCurrentTrackBank().getSceneBank();
    }

    protected boolean isShifted() {
        return this.surface.isShiftPressed();
    }
}

