/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class MaschineSendSelectCommand
extends ModeMultiSelectCommand<MaschineControlSurface, MaschineConfiguration> {
    public MaschineSendSelectCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6, Modes.SEND7, Modes.SEND8);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        Modes activeMode = (Modes)((Object)modeManager.getActiveID());
        super.executeShifted(event);
        Modes newMode = (Modes)((Object)modeManager.getActiveID());
        if (activeMode == newMode) {
            return;
        }
        int sendIndex = newMode.ordinal() - Modes.SEND1.ordinal();
        Optional t = this.model.getCurrentTrackBank().getSelectedItem();
        if (t.isEmpty()) {
            return;
        }
        ISendBank sendBank = ((ITrack)t.get()).getSendBank();
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send.doesExist()) {
            ((MaschineControlSurface)this.surface).getDisplay().notify("Send " + (sendIndex + 1) + ": " + send.getName());
        }
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        Modes activeMode = (Modes)((Object)modeManager.getActiveID());
        super.executeNormal(event);
        Modes newMode = (Modes)((Object)modeManager.getActiveID());
        if (activeMode == newMode) {
            return;
        }
        int sendIndex = newMode.ordinal() - Modes.SEND1.ordinal();
        Optional t = this.model.getCurrentTrackBank().getSelectedItem();
        if (t.isEmpty()) {
            return;
        }
        ISendBank sendBank = ((ITrack)t.get()).getSendBank();
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send.doesExist()) {
            ((MaschineControlSurface)this.surface).getDisplay().notify("Send " + (sendIndex + 1) + ": " + send.getName());
        }
    }
}

