/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.command.trigger;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.view.SessionView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class MaschineJamSessionViewCommand
extends AbstractTriggerCommand<MaschineJamControlSurface, MaschineJamConfiguration> {
    public MaschineJamSessionViewCommand(IModel model, MaschineJamControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ViewManager viewManager = ((MaschineJamControlSurface)this.surface).getViewManager();
        SessionView sessionView = (SessionView)viewManager.get(Views.SESSION);
        Object configuration = ((MaschineJamControlSurface)this.surface).getConfiguration();
        if (event == ButtonEvent.UP) {
            if (((MaschineJamControlSurface)this.surface).isShiftPressed()) {
                IApplication application;
                boolean isArrange = "ARRANGE".equals((application = this.model.getApplication()).getPanelLayout());
                application.setPanelLayout(isArrange ? "MIX" : "ARRANGE");
                ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
                return;
            }
            if (viewManager.isActive(new Views[]{Views.SESSION})) {
                if (sessionView.isBirdsEyeActive()) {
                    sessionView.setBirdsEyeActive(false);
                    this.notifyViewName(false, configuration.isFlipSession());
                    return;
                }
                boolean flipped = !configuration.isFlipSession();
                configuration.setFlipSession(flipped);
                this.notifyViewName(false, flipped);
                return;
            }
            viewManager.setActive(Views.SESSION);
            this.notifyViewName(false, configuration.isFlipSession());
        } else if (event == ButtonEvent.LONG) {
            ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.SESSION);
            sessionView.setBirdsEyeActive(true);
            this.notifyViewName(true, configuration.isFlipSession());
        }
    }

    private void notifyViewName(boolean isBirdsEye, boolean isFlipped) {
        IDisplay display = ((MaschineJamControlSurface)this.surface).getDisplay();
        if (isBirdsEye) {
            display.notify("Session - Birds Eye");
        } else {
            display.notify(isFlipped ? "Session - Flipped" : "Session");
        }
    }
}

