/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TransportHandler
extends AbstractHandler {
    private final WindCommand<GenericFlexiControlSurface, GenericFlexiConfiguration> rwdCommand;
    private final WindCommand<GenericFlexiControlSurface, GenericFlexiConfiguration> ffwdCommand;
    private final PlayCommand<GenericFlexiControlSurface, GenericFlexiConfiguration> playCommand;

    public TransportHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.rwdCommand = new WindCommand(this.model, surface, false);
        this.ffwdCommand = new WindCommand(this.model, surface, true);
        this.playCommand = new PlayCommand(this.model, surface);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.TRANSPORT_PLAY, FlexiCommand.TRANSPORT_STOP, FlexiCommand.TRANSPORT_RESTART, FlexiCommand.TRANSPORT_REWIND, FlexiCommand.TRANSPORT_FAST_FORWARD, FlexiCommand.TRANSPORT_TOGGLE_REPEAT, FlexiCommand.TRANSPORT_TOGGLE_METRONOME, FlexiCommand.TRANSPORT_SET_METRONOME_VOLUME, FlexiCommand.TRANSPORT_TOGGLE_METRONOME_IN_PREROLL, FlexiCommand.TRANSPORT_TOGGLE_PUNCH_IN, FlexiCommand.TRANSPORT_TOGGLE_PUNCH_OUT, FlexiCommand.TRANSPORT_TOGGLE_RECORD, FlexiCommand.TRANSPORT_TOGGLE_ARRANGER_OVERDUB, FlexiCommand.TRANSPORT_TOGGLE_CLIP_OVERDUB, FlexiCommand.TRANSPORT_TOGGLE_ARRANGER_AUTOMATION_WRITE, FlexiCommand.TRANSPORT_TOGGLE_CLIP_AUTOMATION_WRITE, FlexiCommand.TRANSPORT_SET_WRITE_MODE_LATCH, FlexiCommand.TRANSPORT_SET_WRITE_MODE_TOUCH, FlexiCommand.TRANSPORT_SET_WRITE_MODE_WRITE, FlexiCommand.TRANSPORT_SET_TEMPO, FlexiCommand.TRANSPORT_TAP_TEMPO, FlexiCommand.TRANSPORT_MOVE_PLAY_CURSOR};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ITransport transport = this.model.getTransport();
        switch (command) {
            case TRANSPORT_PLAY: {
                return TransportHandler.toMidiValue(transport.isPlaying());
            }
            case TRANSPORT_STOP: {
                return TransportHandler.toMidiValue(!transport.isPlaying());
            }
            case TRANSPORT_TOGGLE_REPEAT: {
                return TransportHandler.toMidiValue(transport.isLoop());
            }
            case TRANSPORT_TOGGLE_METRONOME: {
                return TransportHandler.toMidiValue(transport.isMetronomeOn());
            }
            case TRANSPORT_SET_METRONOME_VOLUME: {
                return transport.getMetronomeVolume();
            }
            case TRANSPORT_TOGGLE_METRONOME_IN_PREROLL: {
                return TransportHandler.toMidiValue(transport.isPrerollMetronomeEnabled());
            }
            case TRANSPORT_TOGGLE_PUNCH_IN: {
                return TransportHandler.toMidiValue(transport.isPunchInEnabled());
            }
            case TRANSPORT_TOGGLE_PUNCH_OUT: {
                return TransportHandler.toMidiValue(transport.isPunchOutEnabled());
            }
            case TRANSPORT_TOGGLE_RECORD: {
                return TransportHandler.toMidiValue(transport.isRecording());
            }
            case TRANSPORT_TOGGLE_ARRANGER_OVERDUB: {
                return TransportHandler.toMidiValue(transport.isArrangerOverdub());
            }
            case TRANSPORT_TOGGLE_CLIP_OVERDUB: {
                return TransportHandler.toMidiValue(transport.isLauncherOverdub());
            }
            case TRANSPORT_TOGGLE_ARRANGER_AUTOMATION_WRITE: {
                return TransportHandler.toMidiValue(transport.isWritingArrangerAutomation());
            }
            case TRANSPORT_TOGGLE_CLIP_AUTOMATION_WRITE: {
                return TransportHandler.toMidiValue(transport.isWritingClipLauncherAutomation());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case TRANSPORT_PLAY: {
                this.playCommand.execute(isButtonPressed ? ButtonEvent.DOWN : ButtonEvent.UP, isButtonPressed ? 127 : 0);
                break;
            }
            case TRANSPORT_STOP: {
                if (!isButtonPressed) break;
                this.model.getTransport().stop();
                break;
            }
            case TRANSPORT_RESTART: {
                if (!isButtonPressed) break;
                this.model.getTransport().restart();
                break;
            }
            case TRANSPORT_REWIND: {
                this.rwdCommand.execute(isButtonPressed ? ButtonEvent.DOWN : ButtonEvent.UP, isButtonPressed ? 127 : 0);
                break;
            }
            case TRANSPORT_FAST_FORWARD: {
                this.ffwdCommand.execute(isButtonPressed ? ButtonEvent.DOWN : ButtonEvent.UP, isButtonPressed ? 127 : 0);
                break;
            }
            case TRANSPORT_TOGGLE_REPEAT: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleLoop();
                break;
            }
            case TRANSPORT_TOGGLE_METRONOME: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleMetronome();
                break;
            }
            case TRANSPORT_SET_METRONOME_VOLUME: {
                this.handleMetronomeVolume(knobMode, value);
                break;
            }
            case TRANSPORT_TOGGLE_METRONOME_IN_PREROLL: {
                if (!isButtonPressed) break;
                this.model.getTransport().togglePrerollMetronome();
                break;
            }
            case TRANSPORT_TOGGLE_PUNCH_IN: {
                if (!isButtonPressed) break;
                this.model.getTransport().togglePunchIn();
                break;
            }
            case TRANSPORT_TOGGLE_PUNCH_OUT: {
                if (!isButtonPressed) break;
                this.model.getTransport().togglePunchOut();
                break;
            }
            case TRANSPORT_TOGGLE_RECORD: {
                if (!isButtonPressed) break;
                this.model.getTransport().startRecording();
                break;
            }
            case TRANSPORT_TOGGLE_ARRANGER_OVERDUB: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleOverdub();
                break;
            }
            case TRANSPORT_TOGGLE_CLIP_OVERDUB: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleLauncherOverdub();
                break;
            }
            case TRANSPORT_TOGGLE_ARRANGER_AUTOMATION_WRITE: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleWriteArrangerAutomation();
                break;
            }
            case TRANSPORT_TOGGLE_CLIP_AUTOMATION_WRITE: {
                if (!isButtonPressed) break;
                this.model.getTransport().toggleWriteClipLauncherAutomation();
                break;
            }
            case TRANSPORT_SET_WRITE_MODE_LATCH: {
                if (!isButtonPressed) break;
                this.model.getTransport().setAutomationWriteMode(AutomationMode.LATCH);
                break;
            }
            case TRANSPORT_SET_WRITE_MODE_TOUCH: {
                if (!isButtonPressed) break;
                this.model.getTransport().setAutomationWriteMode(AutomationMode.TOUCH);
                break;
            }
            case TRANSPORT_SET_WRITE_MODE_WRITE: {
                if (!isButtonPressed) break;
                this.model.getTransport().setAutomationWriteMode(AutomationMode.WRITE);
                break;
            }
            case TRANSPORT_SET_TEMPO: {
                this.handleTempo(knobMode, value);
                break;
            }
            case TRANSPORT_TAP_TEMPO: {
                if (!isButtonPressed) break;
                this.model.getTransport().tapTempo();
                break;
            }
            case TRANSPORT_MOVE_PLAY_CURSOR: {
                this.handlePlayCursor(knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void handlePlayCursor(KnobMode knobMode, MidiValue value) {
        ITransport transport = this.model.getTransport();
        if (!TransportHandler.isAbsolute(knobMode)) {
            transport.changePosition(this.isIncrease(knobMode, value), this.surface.isKnobSensitivitySlow());
        }
    }

    private void handleTempo(KnobMode knobMode, MidiValue value) {
        ITransport transport = this.model.getTransport();
        if (TransportHandler.isAbsolute(knobMode)) {
            int val = value.getValue();
            transport.setTempo(transport.scaleTempo(val, value.isHighRes() ? 16384 : 128));
        } else {
            transport.changeTempo(this.isIncrease(knobMode, value), this.surface.isKnobSensitivitySlow());
        }
    }

    private void handleMetronomeVolume(KnobMode knobMode, MidiValue value) {
        ITransport transport = this.model.getTransport();
        IParameter metronomeVolumeParameter = transport.getMetronomeVolumeParameter();
        int val = value.getValue();
        if (TransportHandler.isAbsolute(knobMode)) {
            metronomeVolumeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            metronomeVolumeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }
}

