/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import java.util.Optional;

public class TrackEditing {
    private final BeatstepControlSurface surface;
    private final IModel model;

    public TrackEditing(BeatstepControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
    }

    public void onTrackKnob(int index, int value) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        boolean isIncrease = this.model.getValueChanger().isIncrease(value);
        switch (index) {
            case 0: {
                ((ITrack)selectedTrack.get()).changeVolume(value);
                break;
            }
            case 1: {
                ((ITrack)selectedTrack.get()).changePan(value);
                break;
            }
            case 2: {
                ((ITrack)selectedTrack.get()).setMute(isIncrease);
                break;
            }
            case 3: {
                ((ITrack)selectedTrack.get()).setSolo(isIncrease);
                break;
            }
            case 4: {
                ((ITrack)selectedTrack.get()).getCrossfadeParameter().changeValue(value);
                break;
            }
            case 5: {
                this.model.getTransport().changeTempo(isIncrease, this.surface.isShiftPressed());
                break;
            }
            case 6: {
                this.model.getTransport().changePosition(isIncrease, this.surface.isShiftPressed());
                break;
            }
            case 7: {
                this.model.getMasterTrack().changeVolume(value);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                ((ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(index - 8)).changeValue(value);
                break;
            }
        }
    }
}

