/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class BeatstepPadGrid
extends PadGridImpl {
    private final Object sysexLock = new Object();

    public BeatstepPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 2, 8, 36);
    }

    @Override
    public void lightEx(int x, int y, int color, int blinkColor, boolean fast) {
        this.setLight(36 + x + 8 * y, color, blinkColor, fast);
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        this.lightPad(note, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightPad(int note, int color) {
        int n = note - 36;
        int pad = n < this.columns ? 120 + n : 112 + n - this.columns;
        String data = "F0 00 20 6B 7F 42 02 00 10 " + StringUtils.toHexStr(new int[]{pad, color}) + "F7";
        Object object = this.sysexLock;
        synchronized (object) {
            this.output.sendSysex(data);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int[] translateToController(int note) {
        int[] translate = super.translateToController(note);
        translate[0] = 2;
        return translate;
    }
}

