/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import java.util.Optional;

public class FireParameterMode
extends ParameterMode<FireControlSurface, FireConfiguration> {
    public FireParameterMode(FireControlSurface surface, IModel model) {
        super(surface, model, false);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new BankParameterProvider(model.getCursorDevice().getParameterBank()), ButtonID.ALT));
    }

    @Override
    public void updateDisplay() {
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        String desc = "Select";
        Object paramLine = "a device";
        int value = -1;
        if (this.model.hasSelectedDevice()) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            Optional pageName = cursorDevice.getParameterBank().getPageBank().getSelectedItem();
            desc = pageName.isPresent() ? (String)pageName.get() : "None";
            int touchedKnob = this.getTouchedKnob();
            int n = touchedKnob = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) && touchedKnob > -1 ? 4 + touchedKnob : touchedKnob;
            if (touchedKnob > -1) {
                IParameter p = (IParameter)this.bank.getItem(touchedKnob);
                paramLine = p.getName(5);
                if (!((String)paramLine).isEmpty()) {
                    value = p.getValue();
                    paramLine = (String)paramLine + ": " + p.getDisplayedValue(6);
                }
            } else {
                paramLine = cursorDevice.getName();
            }
        }
        display.addElement(new TitleValueComponent(desc, (String)paramLine, value, false));
        display.send();
    }
}

