/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.view;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.controller.akai.apcmini.view.APCminiView;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;
import de.mossgrabers.framework.view.Views;

public class ShiftView
extends AbstractShiftView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    private static final int[] TRANSLATE = new int[]{0, 2, 4, 6, 1, 3, 5, -1, -1, 10, 8, -1, 11, 9, 7, -1};
    final PlayCommand<APCminiControlSurface, APCminiConfiguration> playCommand;
    final NewCommand<APCminiControlSurface, APCminiConfiguration> newCommand;
    private final IAPCminiControllerDefinition definition;
    private final int green;
    private final int yellow;
    private final int red;
    private final int black;
    private final int redBlink;
    private final int greenBlink;

    public ShiftView(APCminiControlSurface surface, IModel model, IAPCminiControllerDefinition definition) {
        super("Shift", surface, model);
        this.definition = definition;
        this.playCommand = new PlayCommand(this.model, (APCminiControlSurface)this.surface);
        this.newCommand = new NewCommand(this.model, (APCminiControlSurface)this.surface);
        if (this.definition.hasRGBColors()) {
            this.green = 21;
            this.yellow = 9;
            this.red = 5;
            this.black = 0;
            this.greenBlink = 17;
            this.redBlink = 72;
        } else {
            this.green = 1;
            this.yellow = 5;
            this.red = 3;
            this.black = 0;
            this.greenBlink = 2;
            this.redBlink = 4;
        }
    }

    @Override
    public void drawGrid() {
        int scaleOffset = this.scales.getScaleOffsetIndex();
        IPadGrid padGrid = ((APCminiControlSurface)this.surface).getPadGrid();
        for (int i = 7; i < 64; ++i) {
            padGrid.light(36 + i, this.black);
        }
        padGrid.light(36, scaleOffset == 0 ? this.green : this.yellow);
        padGrid.light(37, scaleOffset == 2 ? this.green : this.yellow);
        padGrid.light(38, scaleOffset == 4 ? this.green : this.yellow);
        padGrid.light(39, scaleOffset == 6 ? this.green : this.yellow);
        padGrid.light(40, scaleOffset == 1 ? this.green : this.yellow);
        padGrid.light(41, scaleOffset == 3 ? this.green : this.yellow);
        padGrid.light(42, scaleOffset == 5 ? this.green : this.yellow);
        padGrid.light(45, scaleOffset == 10 ? this.green : this.red);
        padGrid.light(46, scaleOffset == 8 ? this.green : this.red);
        padGrid.light(48, scaleOffset == 11 ? this.green : this.red);
        padGrid.light(49, scaleOffset == 9 ? this.green : this.red);
        padGrid.light(50, scaleOffset == 7 ? this.green : this.red);
        padGrid.light(60, this.yellow);
        padGrid.light(61, this.yellow);
        padGrid.light(68, this.green);
        padGrid.light(69, this.green);
        padGrid.light(71, this.red);
        padGrid.light(72, this.red);
        padGrid.light(63, this.green);
        Views previousViewId = (Views)((Object)((APCminiControlSurface)this.surface).getViewManager().getActiveIDIgnoreTemporary());
        padGrid.light(92, Views.SESSION == previousViewId ? this.green : this.yellow);
        padGrid.light(93, Views.PLAY == previousViewId ? this.green : this.yellow);
        padGrid.light(94, Views.DRUM == previousViewId ? this.green : this.yellow);
        padGrid.light(95, Views.SEQUENCER == previousViewId ? this.green : this.yellow);
        padGrid.light(96, Views.RAINDROPS == previousViewId ? this.green : this.yellow);
        ITransport transport = this.model.getTransport();
        padGrid.light(99, transport.isPlaying() ? this.greenBlink : this.green);
        padGrid.light(91, transport.isRecording() ? this.redBlink : this.red);
        padGrid.light(83, this.yellow);
        padGrid.light(75, this.yellow);
        padGrid.light(98, this.yellow);
        padGrid.light(90, transport.isLauncherOverdub() ? this.redBlink : this.red);
        padGrid.light(82, this.yellow);
        padGrid.light(74, this.yellow);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity != 0) {
            return;
        }
        this.setWasUsed();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        APCminiConfiguration configuration = (APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration();
        IDisplay display = ((APCminiControlSurface)this.surface).getDisplay();
        int n = ((APCminiControlSurface)this.surface).getPadGrid().translateToController(note)[1];
        switch (n) {
            case 56: {
                this.switchToView(Views.SESSION);
                break;
            }
            case 57: {
                this.switchToView(Views.PLAY);
                break;
            }
            case 58: {
                this.switchToView(Views.DRUM);
                break;
            }
            case 59: {
                this.switchToView(Views.SEQUENCER);
                break;
            }
            case 60: {
                this.switchToView(Views.RAINDROPS);
                break;
            }
            case 63: {
                this.playCommand.executeNormal(ButtonEvent.UP);
                display.notify("Start/Stop");
                break;
            }
            case 55: {
                this.model.getTransport().startRecording();
                display.notify("Record");
                break;
            }
            case 47: {
                this.model.getTransport().toggleLoop();
                display.notify("Toggle Loop");
                break;
            }
            case 39: {
                this.model.getTransport().toggleMetronome();
                display.notify("Toggle Click");
                break;
            }
            case 62: {
                this.newCommand.execute();
                display.notify("New clip");
                break;
            }
            case 54: {
                this.model.getTransport().toggleLauncherOverdub();
                display.notify("Toggle Launcher Overdub");
                break;
            }
            case 46: {
                INoteClip clip = this.model.getCursorClip();
                if (clip.doesExist()) {
                    clip.quantize((double)configuration.getQuantizeAmount() / 100.0);
                }
                display.notify("Quantize");
                break;
            }
            case 38: {
                this.model.getApplication().undo();
                display.notify("Undo");
                break;
            }
            case 24: {
                this.scrollParameterBank(true, cursorDevice);
                break;
            }
            case 25: {
                this.scrollParameterBank(false, cursorDevice);
                break;
            }
            case 32: {
                if (!cursorDevice.canSelectPrevious()) break;
                cursorDevice.selectPrevious();
                display.notify("Device: " + cursorDevice.getName());
                break;
            }
            case 33: {
                if (!cursorDevice.canSelectNext()) break;
                cursorDevice.selectNext();
                display.notify("Device: " + cursorDevice.getName());
                break;
            }
            case 35: {
                this.scales.prevScale();
                String prevScale = this.scales.getScale().getName();
                configuration.setScale(prevScale);
                display.notify(prevScale);
                break;
            }
            case 36: {
                this.scales.nextScale();
                String nextScale = this.scales.getScale().getName();
                configuration.setScale(nextScale);
                display.notify(nextScale);
                break;
            }
            case 27: {
                boolean isChromatic = !configuration.isScaleInKey();
                configuration.setScaleInKey(isChromatic);
                display.notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            default: {
                if (n > 15) {
                    return;
                }
                int pos = TRANSLATE[n];
                if (pos == -1) {
                    return;
                }
                this.scales.setScaleOffsetByIndex(pos);
                configuration.setScaleBase(Scales.BASES.get(pos));
                display.notify(Scales.BASES.get(pos));
                ((IView)((APCminiControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
            }
        }
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ModeManager modeManager = ((APCminiControlSurface)this.surface).getModeManager();
        switch (this.definition.swapShiftedTrackIndices(index)) {
            case 0: {
                tb.getSceneBank().selectPreviousPage();
                break;
            }
            case 1: {
                tb.getSceneBank().selectNextPage();
                break;
            }
            case 2: {
                tb.selectPreviousPage();
                break;
            }
            case 3: {
                tb.selectNextPage();
                break;
            }
            case 4: {
                modeManager.setActive(Modes.VOLUME);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Volume");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Volume");
                break;
            }
            case 5: {
                modeManager.setActive(Modes.PAN);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Pan");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Pan");
                break;
            }
            case 6: {
                Modes mode = Modes.get((Modes)((Object)modeManager.getActiveID()), 1);
                if (Modes.isSendMode(mode)) {
                    if (!tb.canEditSend(mode.ordinal() - Modes.SEND1.ordinal())) {
                        mode = Modes.SEND1;
                    }
                } else {
                    mode = Modes.SEND1;
                }
                modeManager.setActive(mode);
                String name = "Send " + (mode.ordinal() - Modes.SEND1.ordinal() + 1);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl(name);
                ((APCminiControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case 7: {
                if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                    this.model.getBrowser().replace(this.model.getCursorDevice());
                    break;
                }
                modeManager.setActive(Modes.DEVICE_PARAMS);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Device");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Device");
                break;
            }
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        switch (buttonID) {
            case SCENE6: {
                this.model.toggleCurrentTrackBank();
                ((APCminiControlSurface)this.surface).getDisplay().notify(this.model.isEffectTrackBankActive() ? "Effect Tracks" : "Instrument/Audio Tracks");
                break;
            }
            case SCENE7: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            case SCENE8: {
                this.model.getCurrentTrackBank().stop(false);
                break;
            }
            default: {
                int index = this.definition.swapShiftedSceneIndices(buttonID.ordinal() - ButtonID.SCENE1.ordinal());
                ((APCminiControlSurface)this.surface).setTrackState(index);
                String softKeys = APCminiConfiguration.SOFT_KEYS_OPTIONS.get(index);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setSoftKeys(softKeys);
                ((APCminiControlSurface)this.surface).getDisplay().notify(softKeys);
            }
        }
    }

    @Override
    public int getTrackButtonColor(int index) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        ISceneBank sceneBank = tb.getSceneBank();
        Modes mode = (Modes)((Object)((APCminiControlSurface)this.surface).getModeManager().getActiveID());
        switch (this.definition.swapShiftedTrackIndices(index)) {
            case 0: {
                return sceneBank.canScrollPageBackwards() ? 1 : 0;
            }
            case 1: {
                return sceneBank.canScrollPageForwards() ? 1 : 0;
            }
            case 2: {
                return tb.canScrollPageBackwards() ? 1 : 0;
            }
            case 3: {
                return tb.canScrollPageForwards() ? 1 : 0;
            }
            case 4: {
                return Modes.VOLUME.equals((Object)mode) ? 1 : 0;
            }
            case 5: {
                return Modes.PAN.equals((Object)mode) ? 1 : 0;
            }
            case 6: {
                return Modes.isSendMode(mode) ? 1 : 0;
            }
            case 7: {
                return Modes.DEVICE_PARAMS.equals((Object)mode) ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int trackState = ((APCminiControlSurface)this.surface).getTrackState();
        switch (this.definition.swapShiftedSceneIndices(buttonID.ordinal() - ButtonID.SCENE1.ordinal())) {
            case 0: {
                return trackState == 0 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
            case 1: {
                return trackState == 1 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
            case 2: {
                return trackState == 2 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
            case 3: {
                return trackState == 3 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
            case 4: {
                return trackState == 4 ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
            case 5: {
                return this.model.isEffectTrackBankActive() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
            }
        }
        return "BUTTON_STATE_OFF";
    }

    private void switchToView(Views viewID) {
        ViewManager viewManager = ((APCminiControlSurface)this.surface).getViewManager();
        viewManager.setActive(viewID);
        ((APCminiControlSurface)this.surface).getDisplay().notify(((IView)viewManager.get(viewID)).getName());
    }

    private void scrollParameterBank(boolean scrollBack, ICursorDevice cursorDevice) {
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        if (scrollBack) {
            if (!parameterBank.canScrollPageBackwards()) {
                return;
            }
            parameterBank.scrollBackwards();
        } else {
            if (!parameterBank.canScrollPageForwards()) {
                return;
            }
            parameterBank.scrollForwards();
        }
        this.mvHelper.notifySelectedParameterPage();
    }
}

