/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;

public class AccentMode
extends BaseMode<IItem> {
    private static final String TAG_ACCENT = "Accent";

    public AccentMode(PushControlSurface surface, IModel model) {
        super(TAG_ACCENT, surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int fixedAccentValue = config.getFixedAccentValue();
        config.setFixedAccentValue(Math.max(1, valueChanger.changeValue(value, fixedAccentValue, -100.0, 128)));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        int fixedAccentValue = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getFixedAccentValue();
        IValueChanger valueChanger = this.model.getValueChanger();
        display.setCell(0, 7, TAG_ACCENT).setCell(1, 7, fixedAccentValue, Format.FORMAT_RAW).setCell(2, 7, valueChanger.toDAWValue(fixedAccentValue), Format.FORMAT_VALUE);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int fixedAccentValue = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getFixedAccentValue();
        IValueChanger valueChanger = this.model.getValueChanger();
        for (int i = 0; i < 8; ++i) {
            display.addParameterElement(i == 7 ? TAG_ACCENT : "", i == 7 ? valueChanger.toDisplayValue(valueChanger.toDAWValue(fixedAccentValue)) : 0, i == 7 ? Integer.toString(fixedAccentValue) : "", this.isKnobTouched(i), -1);
        }
    }
}

