/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.ArrayList;
import java.util.List;

public class DeviceFileTypeFilterColumn
extends BaseColumn {
    public DeviceFileTypeFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "File Type", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTypeBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceManager.get().getAvailableFileTypes().size();
    }

    @Override
    public List<String> getAllItems() {
        List<DeviceFileType> types = DeviceManager.get().getAvailableFileTypes();
        ArrayList<String> result = new ArrayList<String>(types.size());
        for (DeviceFileType location : types) {
            result.add(location.getName());
        }
        return result;
    }

    private class DeviceTypeBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTypeBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceFileTypeFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceFileTypeFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            int pos = this.position - 1;
            List<DeviceFileType> types = DeviceManager.get().getAvailableFileTypes();
            return pos < types.size() ? types.get(pos).getName() : "";
        }

        @Override
        protected int getCachedHitCount() {
            if (this.position == 0) {
                return DeviceManager.get().getNumDevices();
            }
            int pos = this.position - 1;
            List<DeviceFileType> types = DeviceManager.get().getAvailableFileTypes();
            return pos < types.size() ? DeviceManager.get().filterByFileType(types.get(pos)).size() : 0;
        }
    }
}

