/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.configuration;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.observer.ISettingObserver;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractConfiguration
implements Configuration {
    public static final Integer SCALES_SCALE;
    public static final Integer SCALES_BASE;
    public static final Integer SCALES_IN_KEY;
    public static final Integer SCALES_LAYOUT;
    public static final Integer VU_METER_TYPE;
    public static final Integer ENABLE_VU_METERS;
    public static final Integer BEHAVIOUR_ON_STOP;
    public static final Integer BEHAVIOUR_ON_PAUSE;
    public static final Integer FLIP_SESSION;
    public static final Integer SELECT_CLIP_ON_LAUNCH;
    public static final Integer DRAW_RECORD_STRIPE;
    public static final Integer CONVERT_AFTERTOUCH;
    public static final Integer ACTIVATE_FIXED_ACCENT;
    public static final Integer FIXED_ACCENT_VALUE;
    public static final Integer QUANTIZE_AMOUNT;
    public static final Integer FLIP_RECORD;
    public static final Integer NEW_CLIP_LENGTH;
    public static final Integer AUTO_SELECT_DRUM;
    public static final Integer TURN_OFF_EMPTY_DRUM_PADS;
    public static final Integer TURN_OFF_SCALE_PADS;
    public static final Integer SOUND_DRUM_PADS;
    public static final Integer ACTION_FOR_REC_ARMED_PAD;
    public static final Integer BROWSER_DISPLAY_FILTER1;
    public static final Integer BROWSER_DISPLAY_FILTER2;
    public static final Integer BROWSER_DISPLAY_FILTER3;
    public static final Integer BROWSER_DISPLAY_FILTER4;
    public static final Integer BROWSER_DISPLAY_FILTER5;
    public static final Integer BROWSER_DISPLAY_FILTER6;
    public static final Integer BROWSER_DISPLAY_FILTER7;
    public static final Integer BROWSER_DISPLAY_FILTER8;
    public static final Integer KNOB_SENSITIVITY_DEFAULT;
    public static final Integer KNOB_SENSITIVITY_SLOW;
    public static final Integer NOTEREPEAT_ACTIVE;
    public static final Integer NOTEREPEAT_PERIOD;
    public static final Integer NOTEREPEAT_LENGTH;
    public static final Integer NOTEREPEAT_MODE;
    public static final Integer NOTEREPEAT_OCTAVE;
    public static final Integer MIDI_EDIT_CHANNEL;
    public static final Integer EXCLUDE_DEACTIVATED_ITEMS;
    public static final Integer RECORD_BUTTON_FUNCTION;
    public static final Integer SHIFTED_RECORD_BUTTON_FUNCTION;
    public static final Integer HIERARCHICAL_TRACKS;
    public static final Integer FOOTSWITCH_1;
    public static final Integer FOOTSWITCH_2;
    public static final Integer FOOTSWITCH_3;
    public static final Integer FOOTSWITCH_4;
    public static final Integer STARTUP_VIEW;
    public static final Integer START_WITH_SESSION_VIEW;
    public static final Integer ENABLED_MPE_ZONES;
    public static final Integer MPE_PITCHBEND_RANGE;
    public static final Integer COLOR_TRACK_STATES;
    public static final Integer ENCODER_KNOB_SLOW_DOWN;
    protected static final int NEXT_SETTING_ID = 100;
    protected static final String CATEGORY_DRUMS = "Drum Sequencer";
    protected static final String CATEGORY_SCALES = "Scales";
    protected static final String CATEGORY_SESSION = "Session";
    protected static final String CATEGORY_TRANSPORT = "Transport";
    protected static final String CATEGORY_WORKFLOW = "Workflow";
    protected static final String CATEGORY_PADS = "Pads";
    protected static final String CATEGORY_PLAY_AND_SEQUENCE = "Play and Sequence";
    protected static final String CATEGORY_HARDWARE_SETUP = "Hardware Setup";
    protected static final String CATEGORY_DEBUG = "Debug";
    protected static final String CATEGORY_NOTEREPEAT = "Note Repeat";
    private static final String CATEGORY_FAV_DEVICES = "Add Track - favorite devices";
    private static final String SCALE_IN_KEY = "In Key";
    private static final String SCALE_CHROMATIC = "Chromatic";
    public static final int FOOTSWITCH_TOGGLE_PLAY = 0;
    public static final int FOOTSWITCH_TOGGLE_RECORD = 1;
    public static final int FOOTSWITCH_STOP_ALL_CLIPS = 2;
    public static final int FOOTSWITCH_TOGGLE_CLIP_OVERDUB = 3;
    public static final int FOOTSWITCH_UNDO = 4;
    public static final int FOOTSWITCH_TAP_TEMPO = 5;
    public static final int FOOTSWITCH_NEW_BUTTON = 6;
    public static final int FOOTSWITCH_CLIP_BASED_LOOPER = 7;
    public static final int FOOTSWITCH_PANEL_LAYOUT_ARRANGE = 8;
    public static final int FOOTSWITCH_PANEL_LAYOUT_MIX = 9;
    public static final int FOOTSWITCH_PANEL_LAYOUT_EDIT = 10;
    public static final int FOOTSWITCH_ADD_INSTRUMENT_TRACK = 11;
    public static final int FOOTSWITCH_ADD_AUDIO_TRACK = 12;
    public static final int FOOTSWITCH_ADD_EFFECT_TRACK = 13;
    public static final int FOOTSWITCH_QUANTIZE = 14;
    public static final int FOOTSWITCH_SUSTAIN_PEDAL = 15;
    protected static final String[] OPTIONS_MIDI_CHANNEL;
    protected static final String[] KNOB_SENSITIVITY;
    protected static final String[] ENCODER_KNOB_SLOW_VALUES;
    protected static final ColorEx DEFAULT_COLOR_BACKGROUND;
    protected static final ColorEx DEFAULT_COLOR_BORDER;
    protected static final ColorEx DEFAULT_COLOR_TEXT;
    protected static final ColorEx DEFAULT_COLOR_FADER;
    protected static final ColorEx DEFAULT_COLOR_VU;
    protected static final ColorEx DEFAULT_COLOR_EDIT;
    protected static final ColorEx DEFAULT_COLOR_RECORD;
    protected static final ColorEx DEFAULT_COLOR_SOLO;
    protected static final ColorEx DEFAULT_COLOR_MUTE;
    protected static final ColorEx DEFAULT_COLOR_BACKGROUND_DARKER;
    protected static final ColorEx DEFAULT_COLOR_BACKGROUND_LIGHTER;
    public static final int AFTERTOUCH_CONVERT_OFF = -3;
    public static final int AFTERTOUCH_CONVERT_POLY = -2;
    public static final int AFTERTOUCH_CONVERT_CHANNEL = -1;
    private static final String[] AFTERTOUCH_CONVERSION_VALUES;
    protected static final String[] NEW_CLIP_LENGTH_VALUES;
    private static final String[] TRANSPORT_BEHAVIOUR_VALUES;
    private static final String[] ACTIONS_REC_ARMED_PADS;
    protected static final String[] FOOTSWITCH_VALUES;
    private static final int[] FOOTSWITCH_DEFAULTS;
    protected static final String[] ON_OFF_OPTIONS;
    protected static final String[] TRACK_NAVIGATION_OPTIONS;
    private static final String[] RECORD_OPTIONS;
    private static final int NUMBER_OF_FOOTSWITCHES = 4;
    protected final IHost host;
    private IEnumSetting scaleBaseSetting;
    private IEnumSetting scaleInKeySetting;
    private IEnumSetting scaleLayoutSetting;
    private IEnumSetting scaleSetting;
    private IEnumSetting enableVUMetersSetting;
    private IEnumSetting flipSessionSetting;
    private IEnumSetting accentActiveSetting;
    private IIntegerSetting accentValueSetting;
    private IIntegerSetting quantizeAmountSetting;
    private IEnumSetting newClipLengthSetting;
    private IEnumSetting noteRepeatActiveSetting;
    private IEnumSetting noteRepeatPeriodSetting;
    private IEnumSetting noteRepeatLengthSetting;
    private IEnumSetting noteRepeatModeSetting;
    private IEnumSetting noteRepeatOctaveSetting;
    private IEnumSetting midiEditChannelSetting;
    private IIntegerSetting pitchBendRangeSetting;
    private IEnumSetting enableMPESetting;
    private IEnumSetting showPlayedChordsSetting;
    private final List<IEnumSetting> instrumentSettings = new ArrayList<IEnumSetting>(7);
    private final List<IEnumSetting> audioSettings = new ArrayList<IEnumSetting>(3);
    private final List<IEnumSetting> effectSettings = new ArrayList<IEnumSetting>(3);
    private final List<IEnumSetting> deviceSettings = new ArrayList<IEnumSetting>(3);
    private List<IDeviceMetadata> instrumentMetadata;
    private List<IDeviceMetadata> effectMetadata;
    private List<IDeviceMetadata> deviceMetadata;
    private String[] instrumentNames;
    private String[] effectNames;
    private String[] deviceNames;
    private final Map<Integer, Set<ISettingObserver>> observers = new ConcurrentHashMap<Integer, Set<ISettingObserver>>();
    protected final Set<Integer> dontNotifyAll = new HashSet<Integer>();
    protected final Set<Integer> isSettingActive = new HashSet<Integer>();
    protected IValueChanger valueChanger;
    private String scale = "Major";
    private String scaleBase = "C";
    private boolean scaleInKey = true;
    private String scaleLayout = "4th ^";
    private boolean enableVUMeters = false;
    private TransportBehavior behaviorOnStop = TransportBehavior.STOP;
    private TransportBehavior behaviorOnPause = TransportBehavior.PAUSE;
    protected boolean flipSession = false;
    protected boolean selectClipOnLaunch = true;
    protected boolean drawRecordStripe = true;
    protected int convertAftertouch = 0;
    protected boolean accentActive = false;
    protected int fixedAccentValue = 127;
    private int quantizeAmount = 100;
    protected boolean flipRecord = false;
    private int newClipLength = 2;
    private boolean autoSelectDrum = false;
    private int actionForRecArmedPad = 0;
    private boolean turnOffEmptyDrumPads = false;
    private boolean turnOffScalePads;
    private final int[] footswitch = new int[4];
    private int knobSpeedDefault = 0;
    private int knobSpeedSlow = -40;
    private int encoderKnobSlowDown = 0;
    private boolean noteRepeatActive = false;
    private Resolution noteRepeatPeriod = Resolution.RES_1_8;
    private Resolution noteRepeatLength = Resolution.RES_1_8;
    private ArpeggiatorMode noteRepeatMode;
    private int noteRepeatOctave = 0;
    private int midiEditChannel = 0;
    private final List<ArpeggiatorMode> arpeggiatorModes;
    private boolean includeMaster = true;
    private boolean excludeDeactivatedItems = false;
    private boolean isTrackNavigationFlat = true;
    private boolean isDeleteActive = false;
    private boolean isDuplicateActive = false;
    private RecordFunction recordButtonFunction = RecordFunction.RECORD_ARRANGER;
    private RecordFunction shiftedRecordButtonFunction = RecordFunction.NEW_CLIP;
    private Views startupView = Views.PLAY;
    protected Views preferredAudioView = Views.PLAY;
    private boolean startWithSessionView = false;
    private boolean useCombinationButtonToSoundDrumPads = false;
    private boolean isMPEEnabled = false;
    private int mpePitchBendRange = 48;
    private boolean showPlayedChords = true;
    private boolean colorTrackStates = true;

    protected AbstractConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        this.host = host;
        this.valueChanger = valueChanger;
        this.arpeggiatorModes = arpeggiatorModes;
        this.noteRepeatMode = arpeggiatorModes == null || arpeggiatorModes.isEmpty() ? null : arpeggiatorModes.get(0);
        for (int i = 0; i < this.footswitch.length; ++i) {
            this.footswitch[i] = 6;
        }
        Views.init();
    }

    @Override
    public void addSettingObserver(Integer settingID, ISettingObserver observer) {
        this.observers.computeIfAbsent(settingID, id -> new HashSet()).add(observer);
    }

    @Override
    public void removeSettingObserver(Integer settingID, ISettingObserver observer) {
        Set<ISettingObserver> settingObservers = this.observers.get(settingID);
        if (settingObservers != null) {
            settingObservers.remove(observer);
        }
    }

    @Override
    public void clearSettingObservers() {
        this.observers.clear();
    }

    @Override
    public boolean canSettingBeObserved(Integer settingID) {
        return this.isSettingActive.contains(settingID);
    }

    @Override
    public void setScale(String scale) {
        this.scaleSetting.set(scale);
    }

    @Override
    public String getScale() {
        return this.scale;
    }

    @Override
    public void setScaleBase(String scaleBase) {
        this.scaleBaseSetting.set(scaleBase);
    }

    @Override
    public String getScaleBase() {
        return this.scaleBase;
    }

    @Override
    public void setScaleInKey(boolean inScale) {
        if (this.scaleInKeySetting != null) {
            this.scaleInKeySetting.set(inScale ? SCALE_IN_KEY : SCALE_CHROMATIC);
        }
    }

    @Override
    public boolean isScaleInKey() {
        return this.scaleInKey;
    }

    @Override
    public void setScaleLayout(String scaleLayout) {
        this.scaleLayoutSetting.set(scaleLayout);
    }

    @Override
    public String getScaleLayout() {
        return this.scaleLayout;
    }

    @Override
    public void setVUMetersEnabled(boolean enabled) {
        this.setOnOffSetting(this.enableVUMetersSetting, enabled);
    }

    @Override
    public boolean isEnableVUMeters() {
        return this.enableVUMeters;
    }

    @Override
    public void setFlipSession(boolean enabled) {
        this.setOnOffSetting(this.flipSessionSetting, enabled);
    }

    @Override
    public void setAccentEnabled(boolean enabled) {
        this.setOnOffSetting(this.accentActiveSetting, enabled);
    }

    @Override
    public void setFixedAccentValue(int value) {
        this.accentValueSetting.set(value);
    }

    @Override
    public void changeQuantizeAmount(int control) {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(this.valueChanger.changeValue(control, this.quantizeAmount, -100.0, 101));
        }
    }

    @Override
    public void setQuantizeAmount(int value) {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(value);
        }
    }

    @Override
    public void resetQuantizeAmount() {
        if (this.quantizeAmountSetting != null) {
            this.quantizeAmountSetting.set(100);
        }
    }

    @Override
    public boolean isSelectClipOnLaunch() {
        return this.selectClipOnLaunch;
    }

    protected void setOnOffSetting(IEnumSetting setting, boolean enabled) {
        if (setting != null) {
            setting.set(enabled ? ON_OFF_OPTIONS[1] : ON_OFF_OPTIONS[0]);
        }
    }

    @Override
    public TransportBehavior getBehaviourOnStop() {
        return this.behaviorOnStop;
    }

    @Override
    public TransportBehavior getBehaviourOnPause() {
        return this.behaviorOnPause;
    }

    @Override
    public boolean isFlipSession() {
        return this.flipSession;
    }

    @Override
    public int getConvertAftertouch() {
        return this.convertAftertouch;
    }

    @Override
    public boolean isAccentActive() {
        return this.accentActive;
    }

    @Override
    public int getFixedAccentValue() {
        return this.fixedAccentValue;
    }

    @Override
    public int getQuantizeAmount() {
        return this.quantizeAmount;
    }

    @Override
    public boolean isFlipRecord() {
        return this.flipRecord;
    }

    @Override
    public int getNewClipLength() {
        return this.newClipLength;
    }

    @Override
    public int getNewClipLenghthInBeats(int quartersPerMeasure) {
        return (int)(this.newClipLength < 2 ? Math.pow(2.0, this.newClipLength) : Math.pow(2.0, (double)this.newClipLength - 2.0) * (double)quartersPerMeasure);
    }

    @Override
    public void setNewClipLength(int index) {
        this.newClipLengthSetting.set(NEW_CLIP_LENGTH_VALUES[index]);
    }

    @Override
    public void nextNewClipLength() {
        int index = this.newClipLength + 1;
        if (index >= NEW_CLIP_LENGTH_VALUES.length) {
            index = 0;
        }
        this.newClipLengthSetting.set(NEW_CLIP_LENGTH_VALUES[index]);
    }

    @Override
    public boolean isAutoSelectDrum() {
        return this.autoSelectDrum;
    }

    @Override
    public boolean isTurnOffEmptyDrumPads() {
        return this.turnOffEmptyDrumPads;
    }

    @Override
    public boolean isTurnOffScalePads() {
        return this.turnOffScalePads;
    }

    @Override
    public boolean isCombinationButtonToSoundDrumPads() {
        return this.useCombinationButtonToSoundDrumPads;
    }

    @Override
    public boolean isDrawRecordStripe() {
        return this.drawRecordStripe;
    }

    @Override
    public int getActionForRecArmedPad() {
        return this.actionForRecArmedPad;
    }

    @Override
    public int getFootswitch(int index) {
        return this.footswitch[index];
    }

    @Override
    public int getKnobSensitivityDefault() {
        return this.knobSpeedDefault;
    }

    @Override
    public int getKnobSensitivitySlow() {
        return this.knobSpeedSlow;
    }

    @Override
    public int getEncoderKnobSlowDown() {
        return this.encoderKnobSlowDown;
    }

    @Override
    public boolean isNoteRepeatActive() {
        return this.noteRepeatActive;
    }

    @Override
    public void setNoteRepeatActive(boolean active) {
        this.setOnOffSetting(this.noteRepeatActiveSetting, active);
    }

    @Override
    public void toggleNoteRepeatActive() {
        this.setNoteRepeatActive(!this.isNoteRepeatActive());
    }

    @Override
    public Resolution getNoteRepeatPeriod() {
        return this.noteRepeatPeriod;
    }

    @Override
    public void setNoteRepeatPeriod(Resolution noteRepeatPeriod) {
        this.noteRepeatPeriodSetting.set(noteRepeatPeriod.getName());
    }

    @Override
    public Resolution getNoteRepeatLength() {
        return this.noteRepeatLength;
    }

    @Override
    public void setNoteRepeatLength(Resolution noteRepeatLength) {
        this.noteRepeatLengthSetting.set(noteRepeatLength.getName());
    }

    @Override
    public ArpeggiatorMode getNoteRepeatMode() {
        return this.noteRepeatMode;
    }

    @Override
    public void setNoteRepeatMode(ArpeggiatorMode arpMode) {
        this.noteRepeatModeSetting.set(arpMode.getName());
    }

    @Override
    public int getNoteRepeatOctave() {
        return this.noteRepeatOctave;
    }

    @Override
    public void setNoteRepeatOctave(int octave) {
        int o = Math.max(0, Math.min(8, octave));
        this.noteRepeatOctaveSetting.set(Integer.toString(o));
    }

    @Override
    public int getMidiEditChannel() {
        return this.midiEditChannel;
    }

    @Override
    public void setMidiEditChannel(int midiChannel) {
        int mc = Math.max(0, Math.min(midiChannel, 15));
        this.midiEditChannelSetting.set(OPTIONS_MIDI_CHANNEL[mc]);
    }

    protected void activateScaleSetting(ISettingsUI settingsUI) {
        this.activateScaleSetting(settingsUI, Scale.getNames(), Scale.MAJOR.getName());
    }

    protected void activateScaleSetting(ISettingsUI settingsUI, String[] scaleNames, String defaultScale) {
        this.scaleSetting = settingsUI.getEnumSetting("Scale", CATEGORY_SCALES, scaleNames, defaultScale);
        this.scaleSetting.addValueObserver(value -> {
            this.scale = value;
            this.notifyObservers(SCALES_SCALE);
        });
        this.isSettingActive.add(SCALES_SCALE);
    }

    protected void activateScaleBaseSetting(ISettingsUI settingsUI) {
        this.scaleBaseSetting = settingsUI.getEnumSetting("Base", CATEGORY_SCALES, Scales.BASES, Scales.BASES.get(0));
        this.scaleBaseSetting.addValueObserver(value -> {
            this.scaleBase = value;
            this.notifyObservers(SCALES_BASE);
        });
        this.isSettingActive.add(SCALES_BASE);
    }

    protected void activateScaleInScaleSetting(ISettingsUI settingsUI) {
        this.scaleInKeySetting = settingsUI.getEnumSetting(SCALE_IN_KEY, CATEGORY_SCALES, new String[]{SCALE_IN_KEY, SCALE_CHROMATIC}, SCALE_IN_KEY);
        this.scaleInKeySetting.addValueObserver(value -> {
            this.scaleInKey = SCALE_IN_KEY.equals(value);
            this.notifyObservers(SCALES_IN_KEY);
        });
        this.isSettingActive.add(SCALES_IN_KEY);
    }

    protected void activateScaleLayoutSetting(ISettingsUI settingsUI) {
        this.activateScaleLayoutSetting(settingsUI, ScaleLayout.FOURTH_UP.getName());
    }

    protected void activateScaleLayoutSetting(ISettingsUI settingsUI, String defaultScale) {
        String[] names = ScaleLayout.getNames();
        this.scaleLayoutSetting = settingsUI.getEnumSetting("Layout", CATEGORY_SCALES, names, defaultScale);
        this.scaleLayoutSetting.addValueObserver(value -> {
            this.scaleLayout = value;
            this.notifyObservers(SCALES_LAYOUT);
        });
        this.isSettingActive.add(SCALES_LAYOUT);
    }

    protected void activateEnableVUMetersSetting(ISettingsUI settingsUI) {
        this.activateEnableVUMetersSetting(settingsUI, CATEGORY_WORKFLOW);
    }

    protected void activateEnableVUMetersSetting(ISettingsUI settingsUI, String category) {
        this.enableVUMetersSetting = settingsUI.getEnumSetting("VU Meters", category, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.enableVUMetersSetting.addValueObserver(value -> {
            this.enableVUMeters = "On".equals(value);
            this.notifyObservers(VU_METER_TYPE);
        });
        this.isSettingActive.add(VU_METER_TYPE);
    }

    protected void activateBehaviourOnStopSetting(ISettingsUI settingsUI) {
        IEnumSetting behaviourOnStopSetting = settingsUI.getEnumSetting("Behaviour on Stop", CATEGORY_TRANSPORT, TRANSPORT_BEHAVIOUR_VALUES, TRANSPORT_BEHAVIOUR_VALUES[0]);
        behaviourOnStopSetting.addValueObserver(value -> {
            this.behaviorOnStop = TransportBehavior.values()[AbstractConfiguration.lookupIndex(TRANSPORT_BEHAVIOUR_VALUES, value)];
            this.notifyObservers(BEHAVIOUR_ON_STOP);
        });
        this.isSettingActive.add(BEHAVIOUR_ON_STOP);
    }

    protected void activateBehaviourOnPauseSetting(ISettingsUI settingsUI) {
        IEnumSetting behaviourOnPauseSetting = settingsUI.getEnumSetting("Behaviour on Pause", CATEGORY_TRANSPORT, TRANSPORT_BEHAVIOUR_VALUES, TRANSPORT_BEHAVIOUR_VALUES[2]);
        behaviourOnPauseSetting.addValueObserver(value -> {
            this.behaviorOnPause = TransportBehavior.values()[AbstractConfiguration.lookupIndex(TRANSPORT_BEHAVIOUR_VALUES, value)];
            this.notifyObservers(BEHAVIOUR_ON_PAUSE);
        });
        this.isSettingActive.add(BEHAVIOUR_ON_PAUSE);
    }

    protected void activateFlipSessionSetting(ISettingsUI settingsUI) {
        this.flipSessionSetting = settingsUI.getEnumSetting("Flip Session", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.flipSessionSetting.addValueObserver(value -> {
            this.flipSession = "On".equals(value);
            this.notifyObservers(FLIP_SESSION);
        });
        this.isSettingActive.add(FLIP_SESSION);
    }

    protected void activateSelectClipOnLaunchSetting(ISettingsUI settingsUI) {
        IEnumSetting selectClipOnLaunchSetting = settingsUI.getEnumSetting("Select clip/scene on launch", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        selectClipOnLaunchSetting.addValueObserver(value -> {
            this.selectClipOnLaunch = "On".equals(value);
            this.notifyObservers(SELECT_CLIP_ON_LAUNCH);
        });
        this.isSettingActive.add(SELECT_CLIP_ON_LAUNCH);
    }

    protected void activateDrawRecordStripeSetting(ISettingsUI settingsUI) {
        IEnumSetting drawRecordStripeSetting = settingsUI.getEnumSetting("Display clips of record enabled tracks in red", CATEGORY_SESSION, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        drawRecordStripeSetting.addValueObserver(value -> {
            this.drawRecordStripe = "On".equals(value);
            this.notifyObservers(DRAW_RECORD_STRIPE);
        });
        this.isSettingActive.add(DRAW_RECORD_STRIPE);
    }

    protected void activateActionForRecArmedPad(ISettingsUI settingsUI) {
        IEnumSetting actionForRecArmedPadSetting = settingsUI.getEnumSetting("Action for pressing rec armed empty clip", CATEGORY_SESSION, ACTIONS_REC_ARMED_PADS, ACTIONS_REC_ARMED_PADS[0]);
        actionForRecArmedPadSetting.addValueObserver(value -> {
            this.actionForRecArmedPad = AbstractConfiguration.lookupIndex(ACTIONS_REC_ARMED_PADS, value);
            this.notifyObservers(ACTION_FOR_REC_ARMED_PAD);
        });
        this.isSettingActive.add(ACTION_FOR_REC_ARMED_PAD);
    }

    protected void activateConvertAftertouchSetting(ISettingsUI settingsUI) {
        IEnumSetting convertAftertouchSetting = settingsUI.getEnumSetting("Convert Poly Aftertouch to", CATEGORY_PADS, AFTERTOUCH_CONVERSION_VALUES, AFTERTOUCH_CONVERSION_VALUES[1]);
        convertAftertouchSetting.addValueObserver(value -> {
            this.convertAftertouch = AbstractConfiguration.lookupIndex(AFTERTOUCH_CONVERSION_VALUES, value) - 3;
            this.notifyObservers(CONVERT_AFTERTOUCH);
        });
        this.isSettingActive.add(CONVERT_AFTERTOUCH);
    }

    protected void activateAccentActiveSetting(ISettingsUI settingsUI) {
        this.accentActiveSetting = settingsUI.getEnumSetting("Activate Fixed Accent", CATEGORY_PLAY_AND_SEQUENCE, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.accentActiveSetting.addValueObserver(value -> {
            this.accentActive = "On".equals(value);
            this.notifyObservers(ACTIVATE_FIXED_ACCENT);
        });
        this.isSettingActive.add(ACTIVATE_FIXED_ACCENT);
    }

    protected void activateAccentValueSetting(ISettingsUI settingsUI) {
        this.accentValueSetting = settingsUI.getRangeSetting("Fixed Accent Value", CATEGORY_PLAY_AND_SEQUENCE, 1, 127, 1, "", 127);
        this.accentValueSetting.addValueObserver(value -> {
            this.fixedAccentValue = value;
            this.notifyObservers(FIXED_ACCENT_VALUE);
        });
        this.isSettingActive.add(FIXED_ACCENT_VALUE);
    }

    protected void activateFlipRecordSetting(ISettingsUI settingsUI) {
        IEnumSetting flipRecordSetting = settingsUI.getEnumSetting("Flip arranger and clip record / automation", CATEGORY_TRANSPORT, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipRecordSetting.addValueObserver(value -> {
            this.flipRecord = "On".equals(value);
            this.notifyObservers(FLIP_RECORD);
        });
        this.isSettingActive.add(FLIP_RECORD);
    }

    protected void activateIncludeMasterSetting(ISettingsUI settingsUI) {
        IEnumSetting includeMasterSetting = settingsUI.getEnumSetting("Include (Group-)Mastertrack (requires restart)", CATEGORY_WORKFLOW, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.includeMaster = "On".equals(includeMasterSetting.get());
    }

    protected void activateExcludeDeactivatedItemsSetting(ISettingsUI settingsUI) {
        IEnumSetting excludeDeactivatedItemsSetting = settingsUI.getEnumSetting("Exclude deactivated items (tracks, sends, devices, layers)", CATEGORY_WORKFLOW, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        excludeDeactivatedItemsSetting.addValueObserver(value -> {
            this.excludeDeactivatedItems = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(EXCLUDE_DEACTIVATED_ITEMS);
        });
        this.isSettingActive.add(EXCLUDE_DEACTIVATED_ITEMS);
    }

    protected void activateTrackNavigationSetting(ISettingsUI settingsUI, String category, boolean flatIsDefault) {
        IEnumSetting trackNavigationSetting = settingsUI.getEnumSetting("Track Navigation (requires restart)", category == null ? CATEGORY_WORKFLOW : category, TRACK_NAVIGATION_OPTIONS, TRACK_NAVIGATION_OPTIONS[flatIsDefault ? 0 : 1]);
        this.isTrackNavigationFlat = TRACK_NAVIGATION_OPTIONS[0].equals(trackNavigationSetting.get());
    }

    protected void activateNewClipLengthSetting(ISettingsUI settingsUI) {
        this.newClipLengthSetting = settingsUI.getEnumSetting("New Clip Length", CATEGORY_WORKFLOW, NEW_CLIP_LENGTH_VALUES, NEW_CLIP_LENGTH_VALUES[2]);
        this.newClipLengthSetting.addValueObserver(value -> {
            this.newClipLength = AbstractConfiguration.lookupIndex(NEW_CLIP_LENGTH_VALUES, value);
            this.notifyObservers(NEW_CLIP_LENGTH);
        });
        this.isSettingActive.add(NEW_CLIP_LENGTH);
    }

    protected void activateQuantizeAmountSetting(ISettingsUI settingsUI) {
        this.quantizeAmountSetting = settingsUI.getRangeSetting("Quantize Amount", CATEGORY_PLAY_AND_SEQUENCE, 1, 100, 1, "%", 100);
        this.quantizeAmountSetting.addValueObserver(value -> {
            this.quantizeAmount = value;
            this.notifyObservers(QUANTIZE_AMOUNT);
        });
        this.isSettingActive.add(QUANTIZE_AMOUNT);
    }

    protected void activateMidiEditChannelSetting(ISettingsUI settingsUI) {
        this.midiEditChannelSetting = settingsUI.getEnumSetting("MIDI Edit/Insert note channel", CATEGORY_PLAY_AND_SEQUENCE, OPTIONS_MIDI_CHANNEL, OPTIONS_MIDI_CHANNEL[0]);
        this.midiEditChannelSetting.addValueObserver(value -> {
            this.midiEditChannel = Integer.parseInt(value) - 1;
            this.notifyObservers(MIDI_EDIT_CHANNEL);
        });
        this.isSettingActive.add(MIDI_EDIT_CHANNEL);
    }

    protected void activateAutoSelectDrumSetting(ISettingsUI settingsUI) {
        IEnumSetting autoSelectDrumSetting = settingsUI.getEnumSetting("Auto-select drum settings", CATEGORY_DRUMS, new String[]{"Off", "Channel"}, "Off");
        autoSelectDrumSetting.addValueObserver(value -> {
            this.autoSelectDrum = "Channel".equals(value);
            this.notifyObservers(AUTO_SELECT_DRUM);
        });
        this.isSettingActive.add(AUTO_SELECT_DRUM);
    }

    protected void activateTurnOffEmptyDrumPadsSetting(ISettingsUI settingsUI) {
        IEnumSetting turnOffEmptyDrumPadsSetting = settingsUI.getEnumSetting("Turn off empty drum pads", CATEGORY_DRUMS, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        turnOffEmptyDrumPadsSetting.addValueObserver(value -> {
            this.turnOffEmptyDrumPads = "On".equals(value);
            this.notifyObservers(TURN_OFF_EMPTY_DRUM_PADS);
        });
        this.isSettingActive.add(TURN_OFF_EMPTY_DRUM_PADS);
    }

    protected void activateTurnOffScalePadsSetting(ISettingsUI settingsUI) {
        IEnumSetting turnOffScalePadsSetting = settingsUI.getEnumSetting("Turn off scale pads", CATEGORY_PLAY_AND_SEQUENCE, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        turnOffScalePadsSetting.addValueObserver(value -> {
            this.turnOffScalePads = "On".equals(value);
            this.notifyObservers(TURN_OFF_SCALE_PADS);
        });
        this.isSettingActive.add(TURN_OFF_SCALE_PADS);
    }

    protected void activateUseCombinationButtonToSoundSetting(ISettingsUI settingsUI) {
        IEnumSetting useCombinationButtonToSoundSetting = settingsUI.getEnumSetting("Use combination button to sound drum pads", CATEGORY_DRUMS, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        useCombinationButtonToSoundSetting.addValueObserver(value -> {
            this.useCombinationButtonToSoundDrumPads = "On".equals(value);
            this.notifyObservers(SOUND_DRUM_PADS);
        });
        this.isSettingActive.add(SOUND_DRUM_PADS);
    }

    protected void activateFootswitchSetting(ISettingsUI settingsUI, int index, String label) {
        Integer id = FOOTSWITCH_1 + index;
        IEnumSetting footswitchSetting = settingsUI.getEnumSetting(label, CATEGORY_WORKFLOW, FOOTSWITCH_VALUES, FOOTSWITCH_VALUES[FOOTSWITCH_DEFAULTS[index]]);
        footswitchSetting.addValueObserver(value -> {
            this.footswitch[index] = AbstractConfiguration.lookupIndex(FOOTSWITCH_VALUES, value);
            this.notifyObservers(id);
        });
        this.isSettingActive.add(id);
    }

    protected void activateKnobSpeedSetting(ISettingsUI settingsUI) {
        this.activateKnobSpeedSetting(settingsUI, 100, 60);
    }

    protected void activateKnobSpeedSetting(ISettingsUI settingsUI, int sensitivity, int slowSensitivity) {
        this.activateKnobSpeedSetting(settingsUI, sensitivity, slowSensitivity, false);
    }

    protected void activateKnobSpeedSetting(ISettingsUI settingsUI, int sensitivity, int slowSensitivity, boolean onlyNormalSetting) {
        IEnumSetting knobSpeedNormalSetting = settingsUI.getEnumSetting("Knob Sensitivity Default", CATEGORY_WORKFLOW, KNOB_SENSITIVITY, KNOB_SENSITIVITY[sensitivity]);
        knobSpeedNormalSetting.addValueObserver(value -> {
            this.knobSpeedDefault = AbstractConfiguration.lookupIndex(KNOB_SENSITIVITY, value) - 100;
            this.notifyObservers(KNOB_SENSITIVITY_DEFAULT);
        });
        this.isSettingActive.add(KNOB_SENSITIVITY_DEFAULT);
        if (!onlyNormalSetting) {
            IEnumSetting knobSpeedSlowSetting = settingsUI.getEnumSetting("Knob Sensitivity Slow", CATEGORY_WORKFLOW, KNOB_SENSITIVITY, KNOB_SENSITIVITY[slowSensitivity]);
            knobSpeedSlowSetting.addValueObserver(value -> {
                this.knobSpeedSlow = AbstractConfiguration.lookupIndex(KNOB_SENSITIVITY, value) - 100;
                this.notifyObservers(KNOB_SENSITIVITY_SLOW);
            });
            this.isSettingActive.add(KNOB_SENSITIVITY_SLOW);
        }
    }

    protected void activateEncoderKnobSpeedSetting(ISettingsUI settingsUI) {
        IEnumSetting encoderknobSpeedNormalSetting = settingsUI.getEnumSetting("Encoder Knob Slow Down", CATEGORY_WORKFLOW, ENCODER_KNOB_SLOW_VALUES, ENCODER_KNOB_SLOW_VALUES[0]);
        encoderknobSpeedNormalSetting.addValueObserver(value -> {
            this.encoderKnobSlowDown = AbstractConfiguration.lookupIndex(ENCODER_KNOB_SLOW_VALUES, value);
            this.notifyObservers(ENCODER_KNOB_SLOW_DOWN);
        });
        this.isSettingActive.add(ENCODER_KNOB_SLOW_DOWN);
    }

    protected void activateNoteRepeatSetting(ISettingsUI settingsUI) {
        this.noteRepeatActiveSetting = settingsUI.getEnumSetting("Active", CATEGORY_NOTEREPEAT, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.noteRepeatActiveSetting.addValueObserver(value -> {
            this.noteRepeatActive = "On".equals(value);
            this.notifyObservers(NOTEREPEAT_ACTIVE);
        });
        String[] names = Resolution.getNames();
        this.noteRepeatPeriodSetting = settingsUI.getEnumSetting("Period", CATEGORY_NOTEREPEAT, names, names[4]);
        this.noteRepeatPeriodSetting.addValueObserver(value -> {
            this.noteRepeatPeriod = Resolution.getByName(value);
            this.notifyObservers(NOTEREPEAT_PERIOD);
        });
        this.isSettingActive.add(NOTEREPEAT_ACTIVE);
        this.isSettingActive.add(NOTEREPEAT_PERIOD);
        if (this.host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            this.noteRepeatLengthSetting = settingsUI.getEnumSetting("Length", CATEGORY_NOTEREPEAT, names, names[4]);
            this.noteRepeatLengthSetting.addValueObserver(value -> {
                this.noteRepeatLength = Resolution.getByName(value);
                this.notifyObservers(NOTEREPEAT_LENGTH);
            });
            this.isSettingActive.add(NOTEREPEAT_LENGTH);
        }
        if (this.host.supports(Capability.NOTE_REPEAT_MODE)) {
            String[] arpModeNames = new String[this.arpeggiatorModes.size()];
            for (int i = 0; i < this.arpeggiatorModes.size(); ++i) {
                arpModeNames[i] = this.arpeggiatorModes.get(i).getName();
            }
            this.noteRepeatModeSetting = settingsUI.getEnumSetting("Mode", CATEGORY_NOTEREPEAT, arpModeNames, arpModeNames[1]);
            this.noteRepeatModeSetting.addValueObserver(value -> {
                this.noteRepeatMode = ArpeggiatorMode.lookupByName(value);
                this.notifyObservers(NOTEREPEAT_MODE);
            });
            this.isSettingActive.add(NOTEREPEAT_MODE);
        }
        if (this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            String[] octaves = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"};
            this.noteRepeatOctaveSetting = settingsUI.getEnumSetting("Octave", CATEGORY_NOTEREPEAT, octaves, octaves[1]);
            this.noteRepeatOctaveSetting.addValueObserver(value -> {
                this.noteRepeatOctave = Integer.parseInt(value);
                this.notifyObservers(NOTEREPEAT_OCTAVE);
            });
            this.isSettingActive.add(NOTEREPEAT_OCTAVE);
        }
    }

    protected void activateRecordButtonSetting(ISettingsUI settingsUI) {
        IEnumSetting recordButtonSetting = settingsUI.getEnumSetting("Record button", CATEGORY_TRANSPORT, RECORD_OPTIONS, RECORD_OPTIONS[1]);
        recordButtonSetting.addValueObserver(value -> {
            for (int i = 0; i < RECORD_OPTIONS.length; ++i) {
                if (!RECORD_OPTIONS[i].equals(value)) continue;
                this.recordButtonFunction = RecordFunction.values()[i];
            }
            this.notifyObservers(RECORD_BUTTON_FUNCTION);
        });
        this.isSettingActive.add(RECORD_BUTTON_FUNCTION);
    }

    protected void activateShiftedRecordButtonSetting(ISettingsUI settingsUI) {
        IEnumSetting shiftedRecordButtonSetting = settingsUI.getEnumSetting("Shift + Record button", CATEGORY_TRANSPORT, RECORD_OPTIONS, RECORD_OPTIONS[5]);
        shiftedRecordButtonSetting.addValueObserver(value -> {
            for (int i = 0; i < RECORD_OPTIONS.length; ++i) {
                if (!RECORD_OPTIONS[i].equals(value)) continue;
                this.shiftedRecordButtonFunction = RecordFunction.values()[i];
            }
            this.notifyObservers(SHIFTED_RECORD_BUTTON_FUNCTION);
        });
        this.isSettingActive.add(SHIFTED_RECORD_BUTTON_FUNCTION);
    }

    protected void activateDeviceFavorites(ISettingsUI settingsUI, int numFavInstruments, int numFavAudio, int numFavEffects, int numFavDevices) {
        IEnumSetting favSetting;
        int i;
        this.instrumentMetadata = this.host.getInstrumentMetadata();
        this.effectMetadata = this.host.getAudioEffectMetadata();
        this.deviceMetadata = new ArrayList<IDeviceMetadata>();
        this.deviceMetadata.addAll(this.instrumentMetadata);
        this.deviceMetadata.addAll(this.effectMetadata);
        this.instrumentNames = AbstractConfiguration.getDeviceNames(this.instrumentMetadata);
        this.effectNames = AbstractConfiguration.getDeviceNames(this.effectMetadata);
        this.deviceNames = AbstractConfiguration.getDeviceNames(this.deviceMetadata);
        for (i = 0; i < numFavInstruments; ++i) {
            favSetting = settingsUI.getEnumSetting("Instrument " + (i + 1), CATEGORY_FAV_DEVICES, this.instrumentNames, this.instrumentNames[Math.min(this.instrumentNames.length - 1, i)]);
            this.instrumentSettings.add(favSetting);
        }
        for (i = 0; i < numFavAudio; ++i) {
            favSetting = settingsUI.getEnumSetting("Audio " + (i + 1), CATEGORY_FAV_DEVICES, this.effectNames, this.effectNames[Math.min(this.effectNames.length - 1, i)]);
            this.audioSettings.add(favSetting);
        }
        for (i = 0; i < numFavEffects; ++i) {
            favSetting = settingsUI.getEnumSetting("Effect " + (i + 1), CATEGORY_FAV_DEVICES, this.effectNames, this.effectNames[Math.min(this.effectNames.length - 1, i)]);
            this.effectSettings.add(favSetting);
        }
        for (i = 0; i < numFavDevices; ++i) {
            favSetting = settingsUI.getEnumSetting("Device " + (i + 1), CATEGORY_FAV_DEVICES, this.deviceNames, this.deviceNames[Math.min(this.deviceNames.length - 1, i)]);
            this.deviceSettings.add(favSetting);
        }
    }

    protected void activateStartupViewSetting(ISettingsUI settingsUI, Views[] views) {
        String[] labels = new String[views.length];
        for (int i = 0; i < views.length; ++i) {
            labels[i] = Views.getViewName(views[i]);
        }
        IEnumSetting startupViewSetting = settingsUI.getEnumSetting("Startup view", CATEGORY_PLAY_AND_SEQUENCE, labels, labels[0]);
        startupViewSetting.addValueObserver(value -> {
            this.startupView = Views.getViewByName(value);
            this.notifyObservers(STARTUP_VIEW);
        });
        this.isSettingActive.add(STARTUP_VIEW);
    }

    protected void activateStartWithSessionViewSetting(ISettingsUI settingsUI) {
        IEnumSetting startWithSessionViewSetting = settingsUI.getEnumSetting("Start with session view", CATEGORY_PLAY_AND_SEQUENCE, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        startWithSessionViewSetting.addValueObserver(value -> {
            this.startWithSessionView = "On".equals(value);
            this.notifyObservers(START_WITH_SESSION_VIEW);
        });
        this.isSettingActive.add(START_WITH_SESSION_VIEW);
    }

    protected void activateMPESetting(ISettingsUI settingsUI, String category, boolean enableMPE) {
        this.enableMPESetting = settingsUI.getEnumSetting("MIDI Polyphonic Expression (MPE)", category, ON_OFF_OPTIONS, ON_OFF_OPTIONS[enableMPE ? 1 : 0]);
        this.isMPEEnabled = ON_OFF_OPTIONS[1].equals(this.enableMPESetting.get());
        this.activateMPEBendRange(settingsUI, category);
        this.enableMPESetting.addValueObserver(value -> {
            this.isMPEEnabled = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(ENABLED_MPE_ZONES);
            this.pitchBendRangeSetting.setEnabled(this.isMPEEnabled);
        });
    }

    protected void activateMPEBendRange(ISettingsUI settingsUI, String category) {
        this.pitchBendRangeSetting = settingsUI.getRangeSetting("MPE Pitch Bend Sensitivity", category, 1, 96, 1, "", 48);
        this.mpePitchBendRange = (Integer)this.pitchBendRangeSetting.get();
        this.pitchBendRangeSetting.addValueObserver(value -> {
            this.mpePitchBendRange = value;
            this.notifyObservers(MPE_PITCHBEND_RANGE);
        });
    }

    protected void activateShowPlayedChordsSetting(ISettingsUI settingsUI) {
        this.showPlayedChordsSetting = settingsUI.getEnumSetting("Notify played chords", CATEGORY_PLAY_AND_SEQUENCE, ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.showPlayedChordsSetting.addValueObserver(value -> {
            this.showPlayedChords = ON_OFF_OPTIONS[1].equals(value);
        });
    }

    protected void activateColorTrackStates(ISettingsUI settingsUI) {
        IEnumSetting excludeDeactivatedItemsSetting = settingsUI.getEnumSetting("Color all track states (mute, solo, rec arm)", CATEGORY_WORKFLOW, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        excludeDeactivatedItemsSetting.addValueObserver(value -> {
            this.colorTrackStates = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(COLOR_TRACK_STATES);
        });
        this.isSettingActive.add(COLOR_TRACK_STATES);
    }

    @Override
    public void notifyAllObservers() {
        for (Map.Entry<Integer, Set<ISettingObserver>> entry : this.observers.entrySet()) {
            if (this.dontNotifyAll.contains(entry.getKey())) continue;
            entry.getValue().forEach(ISettingObserver::hasChanged);
        }
    }

    protected void notifyObservers(Integer settingID) {
        Set<ISettingObserver> set = this.observers.get(settingID);
        if (set != null) {
            set.forEach(ISettingObserver::hasChanged);
        }
    }

    public void registerDeactivatedItemsHandler(IModel model) {
        this.addSettingObserver(EXCLUDE_DEACTIVATED_ITEMS, () -> {
            boolean exclude = this.areDeactivatedItemsExcluded();
            ITrackBank trackBank = model.getTrackBank();
            trackBank.setSkipDisabledItems(exclude);
            for (int i = 0; i < trackBank.getPageSize(); ++i) {
                ((ITrack)trackBank.getItem(i)).getSendBank().setSkipDisabledItems(exclude);
            }
            ITrackBank effectTrackBank = model.getEffectTrackBank();
            if (effectTrackBank != null) {
                effectTrackBank.setSkipDisabledItems(exclude);
            }
            ICursorDevice cursorDevice = model.getCursorDevice();
            IDeviceBank deviceBank = cursorDevice.getDeviceBank();
            deviceBank.setSkipDisabledItems(exclude);
            cursorDevice.getLayerBank().setSkipDisabledItems(exclude);
            IDrumPadBank drumPadBank = cursorDevice.getDrumPadBank();
            if (drumPadBank != null) {
                drumPadBank.setSkipDisabledItems(exclude);
            }
        });
    }

    public static int lookupIndex(String[] options, String value) {
        return AbstractConfiguration.lookupIndex(Arrays.asList(options), value);
    }

    public static int lookupIndex(List<String> options, String value) {
        return Math.max(0, options.indexOf(value));
    }

    public static String getNewClipLengthValue(int index) {
        return NEW_CLIP_LENGTH_VALUES[index];
    }

    @Override
    public int lookupArpeggiatorModeIndex(ArpeggiatorMode arpMode) {
        return Math.max(0, this.arpeggiatorModes.indexOf((Object)arpMode));
    }

    public ArpeggiatorMode nextArpeggiatorMode() {
        ArpeggiatorMode arpMode = this.getNoteRepeatMode();
        int index = this.lookupArpeggiatorModeIndex(arpMode) + 1;
        return this.arpeggiatorModes.get(index < this.arpeggiatorModes.size() ? index : 0);
    }

    public ArpeggiatorMode prevArpeggiatorMode() {
        ArpeggiatorMode arpMode = this.getNoteRepeatMode();
        int index = this.lookupArpeggiatorModeIndex(arpMode) - 1;
        return this.arpeggiatorModes.get(index < 0 ? this.arpeggiatorModes.size() - 1 : index);
    }

    @Override
    public List<ArpeggiatorMode> getArpeggiatorModes() {
        return this.arpeggiatorModes;
    }

    @Override
    public RecordFunction getRecordButtonFunction() {
        return this.recordButtonFunction;
    }

    @Override
    public RecordFunction getShiftedRecordButtonFunction() {
        return this.shiftedRecordButtonFunction;
    }

    @Override
    public Views getStartupView() {
        return this.startupView;
    }

    @Override
    public Views getPreferredAudioView() {
        return this.preferredAudioView;
    }

    @Override
    public boolean shouldStartWithSessionView() {
        return this.startWithSessionView;
    }

    public boolean areMasterTracksIncluded() {
        return this.includeMaster;
    }

    public boolean areDeactivatedItemsExcluded() {
        return this.excludeDeactivatedItems;
    }

    public boolean isDeleteModeActive() {
        return this.isDeleteActive;
    }

    public void toggleDeleteModeActive() {
        boolean bl = this.isDeleteActive = !this.isDeleteActive;
        if (this.isDeleteActive) {
            this.isDuplicateActive = false;
        }
    }

    public boolean isDuplicateModeActive() {
        return this.isDuplicateActive;
    }

    public void toggleDuplicateModeActive() {
        boolean bl = this.isDuplicateActive = !this.isDuplicateActive;
        if (this.isDuplicateActive) {
            this.isDeleteActive = false;
        }
    }

    public boolean isTrackNavigationFlat() {
        return this.isTrackNavigationFlat;
    }

    public boolean isMPEEnabled() {
        return this.isMPEEnabled;
    }

    @Override
    public boolean isShowPlayedChords() {
        return this.showPlayedChords;
    }

    public void changeMPEEnabled(int control) {
        if (this.enableMPESetting != null) {
            this.enableMPESetting.set(ON_OFF_OPTIONS[this.valueChanger.isIncrease(control) ? 1 : 0]);
        }
    }

    public void setMPEEnabled(boolean enable) {
        if (this.enableMPESetting != null) {
            this.enableMPESetting.set(ON_OFF_OPTIONS[enable ? 1 : 0]);
        }
    }

    public int getMPEPitchBendRange() {
        return this.mpePitchBendRange;
    }

    public void changeMPEPitchbendRange(int control) {
        this.pitchBendRangeSetting.set(this.valueChanger.changeValue(control, this.mpePitchBendRange, -100.0, 97));
    }

    public void setMPEPitchbendRange(int value) {
        this.pitchBendRangeSetting.set(Math.min(96, Math.max(1, value)));
    }

    public Optional<IDeviceMetadata> getInstrumentFavorite(int index) {
        if (index >= this.instrumentSettings.size()) {
            return Optional.empty();
        }
        String sel = (String)this.instrumentSettings.get(index).get();
        int lookupIndex = AbstractConfiguration.lookupIndex(this.instrumentNames, sel);
        return Optional.ofNullable(lookupIndex >= this.instrumentMetadata.size() ? null : this.instrumentMetadata.get(lookupIndex));
    }

    public Optional<IDeviceMetadata> getAudioFavorite(int index) {
        if (index >= this.audioSettings.size()) {
            return Optional.empty();
        }
        String sel = (String)this.audioSettings.get(index).get();
        int lookupIndex = AbstractConfiguration.lookupIndex(this.effectNames, sel);
        return Optional.ofNullable(lookupIndex >= this.effectMetadata.size() ? null : this.effectMetadata.get(lookupIndex));
    }

    public Optional<IDeviceMetadata> getEffectFavorite(int index) {
        if (index >= this.effectSettings.size()) {
            return Optional.empty();
        }
        String sel = (String)this.effectSettings.get(index).get();
        int lookupIndex = AbstractConfiguration.lookupIndex(this.effectNames, sel);
        return Optional.ofNullable(lookupIndex >= this.effectMetadata.size() ? null : this.effectMetadata.get(lookupIndex));
    }

    public Optional<IDeviceMetadata> getDeviceFavorite(int index) {
        if (index >= this.deviceSettings.size()) {
            return Optional.empty();
        }
        String sel = (String)this.deviceSettings.get(index).get();
        int lookupIndex = AbstractConfiguration.lookupIndex(this.deviceNames, sel);
        return Optional.ofNullable(lookupIndex >= this.deviceMetadata.size() ? null : this.deviceMetadata.get(lookupIndex));
    }

    public boolean isColorTrackStates() {
        return this.colorTrackStates;
    }

    private static String[] getDeviceNames(List<IDeviceMetadata> deviceMetadata) {
        String[] deviceNames = new String[deviceMetadata.size()];
        for (int i = 0; i < deviceNames.length; ++i) {
            deviceNames[i] = deviceMetadata.get(i).fullName();
        }
        return deviceNames;
    }

    static {
        int i;
        SCALES_SCALE = 0;
        SCALES_BASE = 1;
        SCALES_IN_KEY = 2;
        SCALES_LAYOUT = 3;
        VU_METER_TYPE = 4;
        ENABLE_VU_METERS = 5;
        BEHAVIOUR_ON_STOP = 6;
        BEHAVIOUR_ON_PAUSE = 7;
        FLIP_SESSION = 8;
        SELECT_CLIP_ON_LAUNCH = 9;
        DRAW_RECORD_STRIPE = 10;
        CONVERT_AFTERTOUCH = 11;
        ACTIVATE_FIXED_ACCENT = 12;
        FIXED_ACCENT_VALUE = 13;
        QUANTIZE_AMOUNT = 14;
        FLIP_RECORD = 15;
        NEW_CLIP_LENGTH = 16;
        AUTO_SELECT_DRUM = 17;
        TURN_OFF_EMPTY_DRUM_PADS = 18;
        TURN_OFF_SCALE_PADS = 19;
        SOUND_DRUM_PADS = 20;
        ACTION_FOR_REC_ARMED_PAD = 21;
        BROWSER_DISPLAY_FILTER1 = 22;
        BROWSER_DISPLAY_FILTER2 = 23;
        BROWSER_DISPLAY_FILTER3 = 24;
        BROWSER_DISPLAY_FILTER4 = 25;
        BROWSER_DISPLAY_FILTER5 = 26;
        BROWSER_DISPLAY_FILTER6 = 27;
        BROWSER_DISPLAY_FILTER7 = 28;
        BROWSER_DISPLAY_FILTER8 = 29;
        KNOB_SENSITIVITY_DEFAULT = 30;
        KNOB_SENSITIVITY_SLOW = 31;
        NOTEREPEAT_ACTIVE = 32;
        NOTEREPEAT_PERIOD = 33;
        NOTEREPEAT_LENGTH = 34;
        NOTEREPEAT_MODE = 35;
        NOTEREPEAT_OCTAVE = 36;
        MIDI_EDIT_CHANNEL = 37;
        EXCLUDE_DEACTIVATED_ITEMS = 38;
        RECORD_BUTTON_FUNCTION = 39;
        SHIFTED_RECORD_BUTTON_FUNCTION = 40;
        HIERARCHICAL_TRACKS = 41;
        FOOTSWITCH_1 = 42;
        FOOTSWITCH_2 = 43;
        FOOTSWITCH_3 = 44;
        FOOTSWITCH_4 = 45;
        STARTUP_VIEW = 46;
        START_WITH_SESSION_VIEW = 47;
        ENABLED_MPE_ZONES = 48;
        MPE_PITCHBEND_RANGE = 49;
        COLOR_TRACK_STATES = 50;
        ENCODER_KNOB_SLOW_DOWN = 51;
        OPTIONS_MIDI_CHANNEL = new String[16];
        KNOB_SENSITIVITY = new String[201];
        ENCODER_KNOB_SLOW_VALUES = new String[101];
        for (i = 0; i < OPTIONS_MIDI_CHANNEL.length; ++i) {
            AbstractConfiguration.OPTIONS_MIDI_CHANNEL[i] = Integer.toString(i + 1);
        }
        for (i = 0; i < 100; ++i) {
            AbstractConfiguration.KNOB_SENSITIVITY[i] = "-" + (100 - i);
            AbstractConfiguration.KNOB_SENSITIVITY[101 + i] = "+" + (i + 1);
        }
        AbstractConfiguration.KNOB_SENSITIVITY[100] = "Normal";
        AbstractConfiguration.ENCODER_KNOB_SLOW_VALUES[0] = "Normal";
        for (i = 1; i <= 100; ++i) {
            AbstractConfiguration.ENCODER_KNOB_SLOW_VALUES[i] = Integer.toString(i);
        }
        DEFAULT_COLOR_BACKGROUND = ColorEx.fromRGB(83, 83, 83);
        DEFAULT_COLOR_BORDER = ColorEx.BLACK;
        DEFAULT_COLOR_TEXT = ColorEx.BLACK;
        DEFAULT_COLOR_FADER = ColorEx.fromRGB(69, 44, 19);
        DEFAULT_COLOR_VU = ColorEx.GREEN;
        DEFAULT_COLOR_EDIT = ColorEx.fromRGB(240, 127, 17);
        DEFAULT_COLOR_RECORD = ColorEx.RED;
        DEFAULT_COLOR_SOLO = ColorEx.YELLOW;
        DEFAULT_COLOR_MUTE = ColorEx.fromRGB(245, 129, 17);
        DEFAULT_COLOR_BACKGROUND_DARKER = ColorEx.fromRGB(39, 39, 39);
        DEFAULT_COLOR_BACKGROUND_LIGHTER = ColorEx.fromRGB(200, 200, 200);
        AFTERTOUCH_CONVERSION_VALUES = new String[131];
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[0] = "Off";
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[1] = "Poly Aftertouch";
        AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[2] = "Channel Aftertouch";
        for (i = 0; i < 128; ++i) {
            AbstractConfiguration.AFTERTOUCH_CONVERSION_VALUES[3 + i] = "CC " + i;
        }
        NEW_CLIP_LENGTH_VALUES = new String[]{"1 Beat", "2 Beat", "1 Bar", "2 Bars", "4 Bars", "8 Bars", "16 Bars", "32 Bars"};
        TRANSPORT_BEHAVIOUR_VALUES = new String[]{"Stop", "Return to Zero", "Pause"};
        ACTIONS_REC_ARMED_PADS = new String[]{"Start recording", "Create new clip", "Do nothing"};
        FOOTSWITCH_VALUES = new String[]{"Toggle Play", "Toggle Record", "Stop All Clips", "Toggle Clip Overdub", "Undo", "Tap Tempo", "New Button", "Clip Based Looper", "Panel layout arrange", "Panel layout mix", "Panel layout edit", "Add instrument track", "Add audio track", "Add effect track", "Quantize", "Sustain Pedal"};
        FOOTSWITCH_DEFAULTS = new int[]{15, 6, 4, 14};
        ON_OFF_OPTIONS = new String[]{"Off", "On"};
        TRACK_NAVIGATION_OPTIONS = new String[]{"Flat", "Hierarchical"};
        RECORD_OPTIONS = new String[]{"Record arranger", "Record arranger + enable automation", "Record clip", "Record clip + enable automation", "New clip", "New clip + enable automation", "Toggle arranger overdub", "Toggle clip overdub", "Toggle rec arm"};
    }

    public static enum TransportBehavior {
        STOP,
        RETURN_TO_ZERO,
        PAUSE;

    }

    public static enum RecordFunction {
        RECORD_ARRANGER,
        RECORD_ARRANGER_AND_ENABLE_AUTOMATION,
        RECORD_CLIP,
        RECORD_CLIP_AND_ENABLE_AUTOMATION,
        NEW_CLIP,
        NEW_CLIP_AND_ENABLE_AUTOMATION,
        TOGGLE_ARRANGER_OVERDUB,
        TOGGLE_CLIP_OVERDUB,
        TOGGLE_REC_ARM;

    }
}

