/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.empty.EmptyScene;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class StartSceneCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final int index;
    private ISceneBank sceneBank;

    public StartSceneCommand(IModel model, S surface) {
        this(model, surface, -1);
    }

    public StartSceneCommand(IModel model, S surface, int index) {
        this(model, surface, index, null);
    }

    public StartSceneCommand(IModel model, S surface, int index, ISceneBank sceneBank) {
        super(model, surface);
        this.index = index;
        this.sceneBank = sceneBank == null ? this.model.getSceneBank() : sceneBank;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        boolean isDown;
        if (event == ButtonEvent.LONG) {
            return;
        }
        IScene scene = this.getScene();
        if (!scene.doesExist()) {
            return;
        }
        boolean bl = isDown = event == ButtonEvent.DOWN;
        if (isDown) {
            if (this.surface.isDeletePressed()) {
                scene.remove();
                return;
            }
            if (this.surface.getConfiguration().isSelectClipOnLaunch()) {
                scene.select();
                this.mvHelper.delayDisplay(scene::getName);
            }
        }
        scene.launch(isDown, false);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getProject().createSceneFromPlayingLauncherClips();
        }
    }

    public IScene getScene() {
        if (this.index >= 0) {
            return (IScene)this.sceneBank.getItem(this.index);
        }
        Optional sceneOptional = this.sceneBank.getSelectedItem();
        return sceneOptional.isEmpty() ? EmptyScene.INSTANCE : (IScene)sceneOptional.get();
    }
}

