/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.track;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractTrackMode
extends BaseMode<ITrack> {
    protected final List<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
    private static final String[] MODE_MENU = new String[]{"Track", "Volume", "Pan", "Send 1", "Send 2", "Send 3", "Send 4", "Send 5"};
    private static final Modes[] MODES = new Modes[]{Modes.TRACK, Modes.VOLUME, Modes.PAN, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5};
    private final NewCommand<SLMkIIIControlSurface, SLMkIIIConfiguration> newCommand;

    protected AbstractTrackMode(String name, SLMkIIIControlSurface surface, IModel model) {
        super(name, surface, model, model.getCurrentTrackBank());
        this.newCommand = new NewCommand(model, surface);
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
        for (int i = 0; i < 8; ++i) {
            this.menu.add(new Pair<String, Boolean>(" ", Boolean.FALSE));
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP || row != 0) {
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            this.onButtonShifted(index);
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_DOWN)) {
            ((SLMkIIIControlSurface)this.surface).getModeManager().setActive(MODES[index]);
            ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.ARROW_DOWN);
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)tb.getItem(index);
        if (((SLMkIIIControlSurface)this.surface).isPressed(ButtonID.DUPLICATE)) {
            ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.DUPLICATE);
            track.duplicate();
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isPressed(ButtonID.DELETE)) {
            ((SLMkIIIControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            track.remove();
            return;
        }
        track.selectOrExpandGroup();
    }

    private void onButtonShifted(int index) {
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        switch (index) {
            case 0: {
                if (!selectedTrack.isPresent()) break;
                ((ITrack)selectedTrack.get()).toggleIsActivated();
                break;
            }
            case 1: {
                if (!selectedTrack.isPresent()) break;
                this.model.getCursorTrack().togglePinned();
                break;
            }
            case 2: {
                if (!selectedTrack.isPresent()) break;
                ((SLMkIIIControlSurface)this.surface).getViewManager().setActive(Views.COLOR);
                break;
            }
            case 4: {
                this.newCommand.execute();
                break;
            }
            case 5: {
                this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                break;
            }
            case 6: {
                this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                break;
            }
            case 7: {
                this.model.getApplication().addEffectTrack();
                break;
            }
        }
    }

    protected void handleSendEffect(int sendIndex) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (tb == null || !tb.canEditSend(sendIndex)) {
            return;
        }
        Modes si = Modes.get(Modes.SEND1, sendIndex);
        ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
        modeManager.setActive(modeManager.isActive(new Modes[]{si}) ? Modes.TRACK : si);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            switch (buttonID) {
                case ROW1_1: {
                    if (selectedTrack.isEmpty()) {
                        return 0;
                    }
                    return ((ITrack)selectedTrack.get()).isActivated() ? 5 : 7;
                }
                case ROW1_2: {
                    if (selectedTrack.isEmpty()) {
                        return 0;
                    }
                    return this.model.getCursorTrack().isPinned() ? 5 : 7;
                }
                case ROW1_3: {
                    if (selectedTrack.isEmpty()) {
                        return 0;
                    }
                    return 7;
                }
                case ROW1_4: {
                    return 0;
                }
            }
            return 7;
        }
        int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_DOWN)) {
            ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
            return modeManager.isActive(new Modes[]{MODES[index]}) ? 21 : 27;
        }
        ITrack t = (ITrack)tb.getItem(index);
        if (t.doesExist()) {
            if (t.isSelected()) {
                String colorIndex = DAWColor.getColorID(t.getColor());
                return this.model.getColorManager().getColorIndex(colorIndex);
            }
            return 1;
        }
        return 0;
    }

    protected void drawRow4() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
            this.drawRow4Shifted(d, selectedTrack.isPresent() ? (ITrack)selectedTrack.get() : EmptyTrack.getInstance(((ITrack)tb.getItem(0)).getSendBank().getPageSize()));
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_DOWN)) {
            ModeManager modeManager = ((SLMkIIIControlSurface)this.surface).getModeManager();
            for (int i = 0; i < 8; ++i) {
                d.setCell(3, i, MODE_MENU[i]);
                d.setPropertyColor(i, 2, 21);
                d.setPropertyValue(i, 1, modeManager.isActive(new Modes[]{MODES[i]}) ? 1 : 0);
            }
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int color;
            ITrack t = (ITrack)tb.getItem(i);
            d.setCell(3, i, StringUtils.shortenAndFixASCII(t.getName(9), 9));
            boolean exists = t.doesExist();
            if (t.isActivated()) {
                String colorIndex = DAWColor.getColorID(t.getColor());
                color = this.model.getColorManager().getColorIndex(colorIndex);
            } else {
                color = 1;
            }
            d.setPropertyColor(i, 2, color);
            d.setPropertyValue(i, 1, exists && t.isSelected() ? 1 : 0);
        }
    }

    private void drawRow4Shifted(SLMkIIIDisplay d, ITrack selectedTrack) {
        if (selectedTrack == null) {
            for (int i = 0; i < 3; ++i) {
                d.setPropertyColor(i, 2, 0);
                d.setPropertyValue(i, 1, 0);
            }
        } else {
            d.setCell(3, 0, "On/Off");
            d.setPropertyColor(0, 2, 5);
            d.setPropertyValue(0, 1, selectedTrack.isActivated() ? 1 : 0);
            d.setCell(3, 1, "Pin");
            d.setPropertyColor(1, 2, 5);
            d.setPropertyValue(1, 1, this.model.getCursorTrack().isPinned() ? 1 : 0);
            d.setCell(3, 2, "Color");
            d.setPropertyColor(2, 2, 5);
            d.setPropertyValue(2, 1, 0);
        }
        d.setCell(3, 3, "");
        d.setPropertyColor(3, 2, 0);
        d.setPropertyValue(3, 1, 0);
        d.setCell(3, 4, "New Clip");
        d.setPropertyColor(4, 2, 5);
        d.setPropertyValue(4, 1, 0);
        d.setCell(3, 5, "Add Instr");
        d.setPropertyColor(5, 2, 5);
        d.setPropertyValue(5, 1, 0);
        d.setCell(3, 6, "Add Audio");
        d.setPropertyColor(6, 2, 5);
        d.setPropertyValue(6, 1, 0);
        d.setCell(3, 7, "Add FX");
        d.setPropertyColor(7, 2, 5);
        d.setPropertyValue(7, 1, 0);
    }

    protected void setColumnColors(SLMkIIIDisplay display, int column, ITrack track, int knobColorIndex) {
        int color = track.doesExist() ? knobColorIndex : 0;
        display.setPropertyColor(column, 1, track.isActivated() ? color : 1);
        if (track.doesExist()) {
            if (track.isActivated()) {
                String colorIndex = DAWColor.getColorID(track.getColor());
                color = this.model.getColorManager().getColorIndex(colorIndex);
            } else {
                color = 1;
            }
        }
        display.setPropertyColor(column, 0, color);
    }
}

