/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.NoteEditor;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.ResetParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class NoteMode
extends BaseMode<IItem>
implements INoteEditorMode {
    private static final String OFF = "  Off";
    private static final String ON = "   On";
    private final IHost host;
    private Page page = Page.NOTE;
    private final NoteEditor noteEditor;
    private final Map<Page, IParameterProvider> pageParamProviders = new EnumMap<Page, IParameterProvider>(Page.class);

    public NoteMode(SLMkIIIControlSurface surface, IModel model) {
        super("Note", surface, model);
        this.setControls(DEFAULT_KNOB_IDS);
        this.host = this.model.getHost();
        this.noteEditor = new NoteEditor();
        IValueChanger valueChanger = model.getValueChanger();
        NoteParameter durationParameter = new NoteParameter(NoteAttribute.DURATION, null, model, this.noteEditor, valueChanger);
        NoteParameter muteParameter = new NoteParameter(NoteAttribute.MUTE, null, model, this.noteEditor, valueChanger);
        NoteParameter recurrenceParameter = new NoteParameter(NoteAttribute.RECURRENCE_LENGTH, null, model, this.noteEditor, valueChanger);
        this.pageParamProviders.put(Page.NOTE, new FixedParameterProvider(durationParameter, muteParameter, new NoteParameter(NoteAttribute.VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.RELEASE_VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.OCCURRENCE, null, model, this.noteEditor, valueChanger), recurrenceParameter));
        this.pageParamProviders.put(Page.EXPRESSIONS, new FixedParameterProvider(durationParameter, muteParameter, EmptyParameter.INSTANCE, new NoteParameter(NoteAttribute.GAIN, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANNING, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TRANSPOSE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PRESSURE, null, model, this.noteEditor, valueChanger)));
        this.pageParamProviders.put(Page.REPEAT, new FixedParameterProvider(durationParameter, muteParameter, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, new NoteParameter(NoteAttribute.REPEAT, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_END, null, model, this.noteEditor, valueChanger)));
        this.pageParamProviders.put(Page.RECCURRENCE_PATTERN, new FixedParameterProvider(recurrenceParameter, recurrenceParameter, recurrenceParameter, recurrenceParameter, recurrenceParameter, recurrenceParameter, recurrenceParameter, recurrenceParameter));
        this.rebind();
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        List<NotePosition> notes = this.noteEditor.getNotes();
        INoteClip clip = this.noteEditor.getClip();
        if (((SLMkIIIControlSurface)this.surface).isShiftPressed() && this.page == Page.RECCURRENCE_PATTERN) {
            for (NotePosition notePosition : notes) {
                clip.updateStepRecurrenceMaskToggleBit(notePosition, index);
            }
            return;
        }
        if (index < 4) {
            switch (index) {
                case 0: {
                    this.page = Page.NOTE;
                    break;
                }
                case 1: {
                    if (!this.host.supports(NoteAttribute.TIMBRE)) break;
                    this.page = Page.EXPRESSIONS;
                    break;
                }
                case 2: {
                    if (!this.host.supports(NoteAttribute.REPEAT)) break;
                    this.page = Page.REPEAT;
                    break;
                }
                case 3: {
                    if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break;
                    this.page = Page.RECCURRENCE_PATTERN;
                    break;
                }
            }
            this.rebind();
            return;
        }
        block12: for (NotePosition notePosition : notes) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            if (this.page == Page.NOTE) {
                switch (index) {
                    case 5: {
                        if (!this.host.supports(NoteAttribute.CHANCE)) continue block12;
                        clip.updateStepIsChanceEnabled(notePosition, !stepInfo.isChanceEnabled());
                        continue block12;
                    }
                    case 6: {
                        if (!this.host.supports(NoteAttribute.OCCURRENCE)) continue block12;
                        clip.updateStepIsOccurrenceEnabled(notePosition, !stepInfo.isOccurrenceEnabled());
                        continue block12;
                    }
                    case 7: {
                        if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) continue block12;
                        clip.updateStepIsRecurrenceEnabled(notePosition, !stepInfo.isRecurrenceEnabled());
                        continue block12;
                    }
                }
                return;
            }
            if (this.page != Page.REPEAT || index != 4 || !this.host.supports(NoteAttribute.REPEAT)) continue;
            clip.updateStepIsRepeatEnabled(notePosition, !stepInfo.isRepeatEnabled());
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            return 0;
        }
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            IStepInfo stepInfo = this.noteEditor.getClip().getStep(notes.get(0));
            if (((SLMkIIIControlSurface)this.surface).isShiftPressed()) {
                int recurrenceLength = stepInfo.getRecurrenceLength();
                int mask = stepInfo.getRecurrenceMask();
                boolean isOn = (mask & 1 << index) > 0;
                boolean active = index < recurrenceLength;
                int color = 0;
                if (active) {
                    color = isOn ? 96 : 2;
                }
                return color;
            }
            if (index < 4) {
                if (index == this.page.ordinal()) {
                    return 21;
                }
                if (this.host.supports(NoteAttribute.TIMBRE)) {
                    return 2;
                }
                return 0;
            }
            if (this.page == Page.NOTE) {
                if (index == 5 && this.host.supports(NoteAttribute.CHANCE)) {
                    return stepInfo.isChanceEnabled() ? 96 : 14;
                }
                if (index == 6 && this.host.supports(NoteAttribute.OCCURRENCE)) {
                    return stepInfo.isOccurrenceEnabled() ? 96 : 14;
                }
                if (index == 7 && this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) {
                    return stepInfo.isRecurrenceEnabled() ? 96 : 14;
                }
            } else if (this.page == Page.REPEAT && index == 4) {
                return stepInfo.isRepeatEnabled() ? 96 : 14;
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 8, "Note Edit");
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            d.setBlock(1, 1, " Please  select a").setBlock(1, 2, "note.");
            d.setCell(1, 8, "");
            d.hideAllElements();
            for (int i = 0; i < 8; ++i) {
                d.setPropertyColor(i, 2, 0);
            }
        } else {
            int size;
            NotePosition notePosition = notes.get(0);
            IStepInfo stepInfo = this.noteEditor.getClip().getStep(notePosition);
            if (this.page != Page.RECCURRENCE_PATTERN) {
                d.setCell(0, 0, "Length").setCell(1, 0, this.formatLength(stepInfo.getDuration()));
                d.setCell(0, 1, " Mute");
                if (stepInfo.isMuted()) {
                    d.setCell(1, 1, " MUTED");
                }
                d.setPropertyColor(0, 0, 8);
                d.setPropertyColor(0, 1, 0);
                d.setPropertyColor(1, 0, 8);
                d.setPropertyColor(1, 1, 0);
            }
            boolean isOneNote = (size = notes.size()) == 1;
            d.setCell(2, 0, isOneNote ? "Step: " + (notePosition.getStep() + 1) : "Notes: " + size);
            d.setCell(2, 1, isOneNote ? Scales.formatNoteAndOctave(notePosition.getNote(), -3) : "*");
            switch (this.page.ordinal()) {
                case 0: {
                    boolean supportsOccurrence;
                    d.setCell(1, 8, "Common");
                    d.setPropertyValue(0, 1, 1);
                    NoteMode.setColor(d, 2, true);
                    d.setCell(0, 2, "Velocity");
                    d.setCell(1, 2, StringUtils.formatPercentage(stepInfo.getVelocity()));
                    d.setPropertyColor(2, 2, 0);
                    boolean supportsVelocitySpread = this.host.supports(NoteAttribute.VELOCITY_SPREAD);
                    NoteMode.setColor(d, 3, supportsVelocitySpread);
                    d.setPropertyColor(3, 2, 0);
                    if (supportsVelocitySpread) {
                        d.setCell(0, 3, "V-Spread");
                        d.setCell(1, 3, StringUtils.formatPercentage(stepInfo.getVelocitySpread()));
                    }
                    boolean supportsReleaseVelocity = this.host.supports(NoteAttribute.RELEASE_VELOCITY);
                    NoteMode.setColor(d, 4, supportsReleaseVelocity);
                    d.setPropertyColor(4, 2, 0);
                    if (supportsReleaseVelocity) {
                        d.setCell(0, 4, "R-Velcty");
                        d.setCell(1, 4, StringUtils.formatPercentage(stepInfo.getReleaseVelocity()));
                    }
                    boolean supportsChance = this.host.supports(NoteAttribute.CHANCE);
                    NoteMode.setColor(d, 5, supportsChance);
                    if (supportsChance) {
                        d.setCell(0, 5, "Chance");
                        d.setCell(1, 5, StringUtils.formatPercentage(stepInfo.getChance()));
                        d.setCell(3, 5, stepInfo.isChanceEnabled() ? ON : OFF);
                        d.setPropertyColor(5, 2, 8);
                        d.setPropertyValue(5, 1, stepInfo.isChanceEnabled() ? 1 : 0);
                    }
                    d.setPropertyColor(6, 0, (supportsOccurrence = this.host.supports(NoteAttribute.OCCURRENCE)) ? 8 : 0);
                    d.setPropertyColor(6, 1, 0);
                    if (supportsOccurrence) {
                        d.setCell(0, 6, "Occurnce");
                        d.setCell(1, 6, StringUtils.optimizeName(stepInfo.getOccurrence().getName(), 8));
                        d.setCell(3, 6, stepInfo.isOccurrenceEnabled() ? ON : OFF);
                        d.setPropertyColor(6, 2, 8);
                        d.setPropertyValue(6, 1, stepInfo.isOccurrenceEnabled() ? 1 : 0);
                    }
                    boolean supportsRecurrence = this.host.supports(NoteAttribute.RECURRENCE_LENGTH);
                    NoteMode.setColor(d, 7, supportsRecurrence);
                    if (!supportsRecurrence) break;
                    int recurrence = stepInfo.getRecurrenceLength();
                    String recurrenceStr = recurrence < 2 ? "Off" : Integer.toString(recurrence);
                    d.setCell(0, 7, "Recurnce");
                    d.setCell(1, 7, recurrenceStr);
                    d.setCell(3, 7, stepInfo.isRecurrenceEnabled() ? ON : OFF);
                    d.setPropertyColor(7, 2, 8);
                    d.setPropertyValue(7, 1, stepInfo.isRecurrenceEnabled() ? 1 : 0);
                    break;
                }
                case 1: {
                    if (!this.host.supports(NoteAttribute.TIMBRE)) break;
                    for (int i = 3; i < 8; ++i) {
                        d.setPropertyColor(i, 2, 0);
                    }
                    d.setCell(1, 8, "Expressions");
                    NoteMode.setColor(d, 2, false);
                    NoteMode.setColor(d, 3, true);
                    d.setCell(0, 3, "Gain").setCell(1, 3, StringUtils.formatPercentage(stepInfo.getGain()));
                    NoteMode.setColor(d, 4, true);
                    d.setCell(0, 4, "Pan").setCell(1, 4, StringUtils.formatPercentage(stepInfo.getPan()));
                    NoteMode.setColor(d, 5, true);
                    d.setCell(0, 5, "Pitch").setCell(1, 5, String.format("%.1f", stepInfo.getTranspose()));
                    NoteMode.setColor(d, 6, true);
                    d.setCell(0, 6, "Timbre").setCell(1, 6, StringUtils.formatPercentage(stepInfo.getTimbre()));
                    NoteMode.setColor(d, 7, true);
                    d.setCell(0, 7, "Pressure").setCell(1, 7, StringUtils.formatPercentage(stepInfo.getPressure()));
                    break;
                }
                case 2: {
                    int repeatColor = stepInfo.isRepeatEnabled() ? 96 : 14;
                    for (int i = 3; i < 8; ++i) {
                        d.setPropertyColor(i, 2, i == 4 ? repeatColor : 0);
                    }
                    d.setCell(1, 8, "Repeat");
                    NoteMode.setColor(d, 2, false);
                    NoteMode.setColor(d, 3, false);
                    NoteMode.setColor(d, 4, true);
                    d.setCell(0, 4, "Count");
                    d.setCell(1, 4, stepInfo.getFormattedRepeatCount());
                    d.setCell(3, 4, stepInfo.isRepeatEnabled() ? ON : OFF);
                    double repeatCurve = stepInfo.getRepeatCurve();
                    NoteMode.setColor(d, 5, true);
                    d.setCell(0, 5, "Curve");
                    d.setCell(1, 5, StringUtils.formatPercentage(repeatCurve));
                    double repeatVelocityCurve = stepInfo.getRepeatVelocityCurve();
                    NoteMode.setColor(d, 6, true);
                    d.setCell(0, 6, "Vel-Crve");
                    d.setCell(1, 6, StringUtils.formatPercentage(repeatVelocityCurve));
                    double repeatVelocityEnd = stepInfo.getRepeatVelocityEnd();
                    NoteMode.setColor(d, 7, true);
                    d.setCell(0, 7, "Vel. End");
                    d.setCell(1, 7, StringUtils.formatPercentage(repeatVelocityEnd));
                    break;
                }
                case 3: {
                    d.setCell(1, 8, "Pattern");
                    for (int i = 4; i < 8; ++i) {
                        d.setPropertyColor(i, 2, 0);
                    }
                    int recurrenceLength = stepInfo.getRecurrenceLength();
                    int mask = stepInfo.getRecurrenceMask();
                    for (int i = 0; i < 8; ++i) {
                        boolean active;
                        boolean isOn = (mask & 1 << i) > 0;
                        Object label = "   -";
                        boolean bl = active = i < recurrenceLength;
                        if (active) {
                            label = i + 1 + ": " + (isOn ? "On" : "Off");
                        }
                        d.setCell(0, i, (String)label);
                        int color = 0;
                        if (active) {
                            color = isOn ? 8 : 2;
                        }
                        d.setPropertyColor(i, 0, color);
                        d.setPropertyColor(i, 1, 0);
                    }
                    break;
                }
            }
        }
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 8;
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this.noteEditor;
    }

    private String formatLength(double duration) {
        return StringUtils.formatMeasures(this.model.getTransport().getQuartersPerMeasure(), duration, 0, true);
    }

    private static void setColor(SLMkIIIDisplay display, int index, boolean isOn) {
        int color = isOn ? 8 : 0;
        display.setPropertyColor(index, 0, color);
        display.setPropertyColor(index, 1, color);
    }

    private void rebind() {
        IParameterProvider parameterProvider = this.pageParamProviders.get((Object)this.page);
        this.setParameterProvider(parameterProvider);
        this.setParameterProvider(ButtonID.DELETE, new ResetParameterProvider(parameterProvider));
        this.bindControls();
    }

    private static enum Page {
        NOTE,
        EXPRESSIONS,
        REPEAT,
        RECCURRENCE_PATTERN;

    }
}

