/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.KeyboardCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.PadModeCommand;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.PlayView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class MaschineMk2PlayViewSwitchCommand
extends AbstractTriggerCommand<MaschineControlSurface, MaschineConfiguration> {
    private final PadModeCommand drumViewCommand;
    private final KeyboardCommand playViewCommand;
    private final ViewManager viewManager;
    private final PlayView playView;

    public MaschineMk2PlayViewSwitchCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface);
        this.drumViewCommand = new PadModeCommand(null, model, surface);
        this.playViewCommand = new KeyboardCommand(model, surface);
        this.viewManager = ((MaschineControlSurface)this.surface).getViewManager();
        this.playView = (PlayView)this.viewManager.get(Views.PLAY);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch ((Views)((Object)this.viewManager.getActiveID())) {
            case DRUM: {
                this.playViewCommand.executeNormal(event);
                break;
            }
            case PLAY: {
                if (this.playView.isChordMode()) {
                    this.drumViewCommand.executeNormal(event);
                }
                this.playView.toggleChordMode();
                break;
            }
            default: {
                this.drumViewCommand.executeNormal(event);
            }
        }
        IDisplay display = ((MaschineControlSurface)this.surface).getDisplay();
        if (this.viewManager.getActiveID() == Views.DRUM) {
            display.notify("Drum");
        } else if (this.playView.isChordMode()) {
            display.notify("Chord");
        } else {
            display.notify("Play");
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        Views activeIDIgnoreTemporary = (Views)((Object)this.viewManager.getActiveIDIgnoreTemporary());
        switch (activeIDIgnoreTemporary) {
            case DRUM: {
                if (modeManager.isActive(new Modes[]{Modes.PLAY_OPTIONS})) {
                    modeManager.restore();
                    break;
                }
                modeManager.setActive(Modes.PLAY_OPTIONS);
                break;
            }
            case PLAY: {
                if (modeManager.isActive(new Modes[]{Modes.SCALES})) {
                    modeManager.restore();
                    break;
                }
                modeManager.setTemporary(Modes.SCALES);
                break;
            }
        }
    }
}

