/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.mode.track.TrackMode;
import java.util.Optional;

public class MaschineJamTrackMode
extends TrackMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(1, 0, 0);

    public MaschineJamTrackMode(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    @Override
    public FaderConfig setupFader(int index) {
        Optional optionalTrack = this.model.getCurrentTrackBank().getSelectedItem();
        if (optionalTrack.isEmpty()) {
            return FADER_OFF;
        }
        ITrack track = (ITrack)optionalTrack.get();
        if (!track.doesExist()) {
            return FADER_OFF;
        }
        String c = DAWColor.getColorID(track.getColor());
        int color = this.colorManager.getColorIndex(c);
        switch (index) {
            case 0: {
                int value = this.model.getValueChanger().toMidiValue(track.getVolume());
                if (!this.model.getTransport().isPlaying()) {
                    return new FaderConfig(0, color, value);
                }
                int vu = this.model.getValueChanger().toMidiValue(track.getVu());
                return new FaderConfig(3, color, vu, value);
            }
            case 1: {
                int panValue = this.model.getValueChanger().toMidiValue(track.getPan());
                return new FaderConfig(2, color, panValue);
            }
        }
        ISendBank sendBank = track.getSendBank();
        if (!sendBank.hasExistingItems()) {
            return FADER_OFF;
        }
        int sendIndex = index - 2;
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (!send.doesExist()) {
            return FADER_OFF;
        }
        int sendValue = this.model.getValueChanger().toMidiValue(send.getValue());
        return new FaderConfig(0, 76, sendValue);
    }
}

