/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode.track;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1Display;
import de.mossgrabers.controller.ni.kontrol.mki.mode.AbstractKontrol1Mode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Locale;
import java.util.Optional;

public class TrackMode
extends AbstractKontrol1Mode<ITrack> {
    public TrackMode(Kontrol1ControlSurface surface, IModel model) {
        super("Track", surface, model, model.getCurrentTrackBank());
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
        this.setParameterProvider(new SelectedTrackParameterProvider(model));
    }

    @Override
    public void updateDisplay() {
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        Optional t = currentTrackBank.getSelectedItem();
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        if (t.isEmpty()) {
            d.setCell(0, 3, "  PLEASE").setCell(0, 4, "SELECT A").setCell(0, 5, "TRACK").allDone();
            return;
        }
        boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
        ITrack track = (ITrack)t.get();
        d.setCell(0, 0, (isEffectTrackBankActive ? "TR-FX " : "TRACK ") + (track.getPosition() + 1)).setCell(1, 0, StringUtils.shortenAndFixASCII(track.getName(), 8).toUpperCase(Locale.US));
        d.setCell(0, 1, "VOLUME").setCell(1, 1, TrackMode.getSecondLineText(track)).setCell(0, 2, "PAN").setCell(1, 2, track.getPanStr(8));
        d.setBar(1, ((Kontrol1ControlSurface)this.surface).getContinuous(ContinuousID.KNOB1).isTouched(), track.getVolume());
        d.setPanBar(2, ((Kontrol1ControlSurface)this.surface).getContinuous(ContinuousID.KNOB2).isTouched(), track.getPan());
        ISendBank sendBank = track.getSendBank();
        for (int i = 0; i < 6; ++i) {
            int pos = 3 + i;
            ISend sendData = (ISend)sendBank.getItem(i);
            d.setCell(0, pos, StringUtils.shortenAndFixASCII(sendData.getName(8), 8).toUpperCase(Locale.US)).setCell(1, pos, sendData.getDisplayedValue(8));
            d.setBar(pos, ((Kontrol1ControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.KNOB3, i)).isTouched() && sendData.doesExist(), sendData.getValue());
        }
        d.allDone();
    }
}

