/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.trigger;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.view.DrumView;
import de.mossgrabers.framework.command.trigger.clip.StopClipCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class APCStopClipCommand
extends StopClipCommand<APCControlSurface, APCConfiguration> {
    public APCStopClipCommand(int index, IModel model, APCControlSurface surface) {
        super(index, model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IView view = (IView)((APCControlSurface)this.surface).getViewManager().getActive();
        if (view instanceof DrumView) {
            DrumView drumView = (DrumView)view;
            drumView.handleStopButtons(this.index);
            return;
        }
        if (view instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)view;
            sequencerView.setResolutionIndex(this.index);
            return;
        }
        super.executeNormal(ButtonEvent.DOWN);
    }

    public int getButtonColor(ButtonID stopButtonID) {
        IView view = (IView)((APCControlSurface)this.surface).getViewManager().getActive();
        if (view instanceof DrumView) {
            DrumView drumView = (DrumView)view;
            return drumView.getStopButtonColor(this.index);
        }
        if (view instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)view;
            return sequencerView.getResolutionIndex() == this.index ? 1 : 0;
        }
        return ((APCControlSurface)this.surface).isPressed(stopButtonID) ? 1 : 0;
    }
}

