/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.utils;

import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogModel {
    private Style normalStyle;
    private Style errorStyle;
    private final Object updateLock = new Object();
    private JTextPane textPane;
    private final StringBuilder buffer = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextArea(JTextPane loggingTextPane) {
        Object object = this.updateLock;
        synchronized (object) {
            this.textPane = loggingTextPane;
            this.normalStyle = this.textPane.addStyle("Normal Style", null);
            StyleConstants.setForeground(this.normalStyle, Color.BLACK);
            this.errorStyle = this.textPane.addStyle("Error Style", null);
            StyleConstants.setForeground(this.errorStyle, Color.RED);
            if (this.buffer.length() > 0) {
                this.info("");
            }
        }
    }

    public void error(String message, Throwable exception) {
        this.log(message, true);
        if (exception == null) {
            return;
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        this.log(writer.toString(), true);
    }

    public void info(String message) {
        this.log(message, false);
    }

    public void log(String message, boolean isError) {
        if (message.length() == 0 && this.buffer.isEmpty()) {
            return;
        }
        SafeRunLater.execute(null, () -> {
            Object object = this.updateLock;
            synchronized (object) {
                if (message.length() > 0) {
                    this.buffer.append(message).append("\n");
                }
                if (this.textPane != null) {
                    try {
                        StyledDocument doc = this.textPane.getStyledDocument();
                        doc.insertString(doc.getLength(), this.buffer.toString(), isError ? this.errorStyle : this.normalStyle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    this.buffer.setLength(0);
                    this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogMessage() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.textPane == null) {
                this.buffer.setLength(0);
            } else {
                this.textPane.setText("");
            }
        }
    }
}

