/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.device;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.ICursorLayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameterBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.AbstractParameterProvider;
import java.util.Optional;

public class SelectedLayerDeviceBankParameterProvider
extends AbstractParameterProvider
implements IBankPageObserver {
    private final ICursorLayer cursorLayer;
    private final EmptyParameterBank emptyParameterBank;
    private IBank<IParameter> bank;

    public SelectedLayerDeviceBankParameterProvider(ICursorLayer cursorLayer, int numParams) {
        this.cursorLayer = cursorLayer;
        this.emptyParameterBank = EmptyParameterBank.getInstance(numParams);
        cursorLayer.getLayerBank().addSelectionObserver((index, isSelected) -> {
            if (isSelected) {
                this.configureCurrentBank();
            }
        });
        this.configureCurrentBank();
    }

    public void configureCurrentBank() {
        Optional<ISpecificDevice> specificDevice = this.cursorLayer.getSelectedDevice();
        this.bank = specificDevice.isPresent() ? specificDevice.get().getParameterBank() : this.emptyParameterBank;
        this.notifyParametersObservers();
    }

    public IParameterBank getBank() {
        return (IParameterBank)this.bank;
    }

    @Override
    public int size() {
        return this.bank.getPageSize();
    }

    @Override
    public IParameter get(int index) {
        return this.bank.getItem(index);
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        return Optional.empty();
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        this.bank.addPageObserver(this);
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (!this.hasObservers()) {
            this.bank.removePageObserver(this);
        }
    }

    @Override
    public void pageAdjusted() {
        this.notifyParametersObservers();
    }
}

