/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import java.util.List;
import java.util.Optional;

public class TrackMode<S extends IControlSurface<C>, C extends Configuration>
extends DefaultTrackMode<S, C> {
    public TrackMode(S surface, IModel model, boolean isAbsolute) {
        this(surface, model, isAbsolute, null);
    }

    public TrackMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this("Track", surface, model, isAbsolute, controls);
    }

    public TrackMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        super(name, surface, model, isAbsolute, controls);
        if (controls != null) {
            this.setParameterProvider(new SelectedTrackParameterProvider(model));
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        ITrack t = (ITrack)track.get();
        switch (index) {
            case 0: {
                if (this.isAbsolute) {
                    t.setVolume(value);
                    break;
                }
                t.changeVolume(value);
                break;
            }
            case 1: {
                if (this.isAbsolute) {
                    t.setPan(value);
                    break;
                }
                t.changePan(value);
                break;
            }
            default: {
                ISendBank sendBank = t.getSendBank();
                if (!sendBank.hasExistingItems()) {
                    return;
                }
                ISend send = (ISend)sendBank.getItem(index - 2);
                if (this.isAbsolute) {
                    send.setValue(value);
                    break;
                }
                send.changeValue(value);
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        ITrack t = (ITrack)track.get();
        switch (index) {
            case 0: {
                if (isTouched && this.surface.isDeletePressed()) {
                    t.resetVolume();
                }
                t.touchVolume(isTouched);
                break;
            }
            case 1: {
                if (isTouched && this.surface.isDeletePressed()) {
                    t.resetPan();
                }
                t.touchPan(isTouched);
                break;
            }
            default: {
                ISendBank sendBank = t.getSendBank();
                if (!sendBank.hasExistingItems()) {
                    return;
                }
                ISend item = (ISend)sendBank.getItem(index - 2);
                if (isTouched && this.surface.isDeletePressed()) {
                    item.resetValue();
                }
                item.touchValue(isTouched);
            }
        }
    }

    @Override
    public int getKnobValue(int index) {
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return -1;
        }
        ITrack t = (ITrack)track.get();
        switch (index) {
            case 0: {
                return t.getVolume();
            }
            case 1: {
                return t.getPan();
            }
        }
        ISendBank sendBank = t.getSendBank();
        if (!sendBank.hasExistingItems()) {
            return 0;
        }
        return ((ISend)sendBank.getItem(index - 2)).getValue();
    }
}

