/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.utilities.midimonitor.controller;

import de.mossgrabers.controller.utilities.midimonitor.MidiMonitorConfiguration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.MidiConstants;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;

public class MidiMonitorControlSurface
extends AbstractControlSurface<MidiMonitorConfiguration> {
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             "};
    private boolean printHeader = true;
    private boolean printSysexHeader = true;
    private int sysexLengthCount = 0;

    public MidiMonitorControlSurface(IHost host, MidiMonitorConfiguration configuration, IMidiInput input) {
        super(host, configuration, null, null, input, null, 10.0, 10.0);
        this.input.setSysexCallback(this::handleSysEx);
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 128: {
                this.log(status, data1, data2, channel, "Note Off " + Scales.formatNoteAndOctave(data1, -2));
                break;
            }
            case 144: {
                this.log(status, data1, data2, channel, "Note On  " + Scales.formatNoteAndOctave(data1, -2));
                break;
            }
            case 160: {
                this.log(status, data1, data2, channel, "Polyphonic Key Pressure " + Scales.formatNoteAndOctave(data1, -2));
                break;
            }
            case 176: {
                this.log(status, data1, data2, channel, "CC " + MidiConstants.getCCNames()[data1]);
                break;
            }
            case 192: {
                this.log(status, data1, data2, channel, "Program Change");
                break;
            }
            case 208: {
                this.log(status, data1, data2, channel, "Channel Pressure (Aftertouch)");
                break;
            }
            case 224: {
                this.log(status, data1, data2, channel, "Pitchbend");
                break;
            }
            case 240: {
                if (((MidiMonitorConfiguration)this.configuration).isFilterSystemRealtimeEnabled()) break;
                this.log(status, data1, data2, channel, MidiConstants.getSysexNames()[channel]);
                break;
            }
            default: {
                this.host.println("Unhandled MIDI status: " + status);
            }
        }
    }

    private void handleSysEx(String dataStr) {
        int[] data;
        if (this.printSysexHeader) {
            this.printHeader = true;
            this.printSysexHeader = false;
            this.host.println("");
            this.host.println("| SYSEX");
            this.host.println("|-----------------------------------------------------------------------");
        }
        if ((data = StringUtils.fromHexStr(dataStr)).length == 0) {
            return;
        }
        if (data[0] == 240) {
            this.sysexLengthCount = 0;
        }
        this.sysexLengthCount += data.length;
        StringBuilder sb = new StringBuilder("| ");
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X", data[i]));
            if (i != 0 && (i + 1) % 16 == 0) {
                this.host.println(sb.toString());
                sb = new StringBuilder("| ");
                continue;
            }
            sb.append(' ');
        }
        if (data[data.length - 1] == 247) {
            if (this.sysexLengthCount == data.length && data.length == 6 && data[0] == 240 && data[1] == 127 && data[3] == 6 && data[5] == 247) {
                sb.append(" - MMC ").append(MidiConstants.getMMCNames()[data[4]]);
            } else {
                sb.append("(" + this.sysexLengthCount + " bytes)");
            }
            this.host.println(sb.toString());
        }
    }

    private void log(int status, int data1, int data2, int channel, String text) {
        if (this.printHeader) {
            this.printSysexHeader = true;
            this.printHeader = false;
            this.host.println("");
            this.host.println("| STATUS | DATA 1 | DATA 2 | CHAN | EVENT");
            this.host.println("|--------|--------|--------|------|-------------------------------------");
        }
        this.host.println("| " + MidiMonitorControlSurface.padNumber(status, 2, true) + " " + MidiMonitorControlSurface.padNumber(status, 3, false) + " | " + MidiMonitorControlSurface.padNumber(data1, 2, true) + " " + MidiMonitorControlSurface.padNumber(data1, 3, false) + " | " + MidiMonitorControlSurface.padNumber(data2, 2, true) + " " + MidiMonitorControlSurface.padNumber(data2, 3, false) + " | " + MidiMonitorControlSurface.padNumber(channel + 1, 4, false) + " | " + text);
    }

    private static String padNumber(int number, int length, boolean asHex) {
        String text = asHex ? String.format("%02X", number) : Integer.toString(number);
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return SPACES[diff] + text;
        }
        return text;
    }
}

