/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.MCUMultiModeSwitcherCommand;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TracksCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    private final MCUMultiModeSwitcherCommand trackModesCommand;
    private final MCUMultiModeSwitcherCommand layerModesCommand;

    public TracksCommand(IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.trackModesCommand = new MCUMultiModeSwitcherCommand(model, surface, Modes.VOLUME, Modes.TRACK);
        this.layerModesCommand = new MCUMultiModeSwitcherCommand(model, surface, Modes.DEVICE_LAYER_VOLUME, Modes.DEVICE_LAYER);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (((MCUControlSurface)this.surface).isPressed(ButtonID.SELECT)) {
            if (event == ButtonEvent.DOWN) {
                this.model.getCursorTrack().togglePinned();
            }
            return;
        }
        if (Modes.isLayerMode((Modes)((Object)((MCUControlSurface)this.surface).getModeManager().getActiveID()))) {
            this.layerModesCommand.execute(event, velocity);
        } else {
            this.trackModesCommand.execute(event, velocity);
        }
    }
}

