/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.command.trigger.AssignableCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.DevicesCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.FaderTouchCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.KeyCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUCursorCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUFlipCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUMoveTrackBankCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.MCUWindCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.PanCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.ScrubCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.SelectCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.SendSelectCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.TempoTicksCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.ToggleDisplayCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.TracksCommand;
import de.mossgrabers.controller.mackie.mcu.command.trigger.ZoomCommand;
import de.mossgrabers.controller.mackie.mcu.controller.MCUAssignmentDisplay;
import de.mossgrabers.controller.mackie.mcu.controller.MCUColorManager;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.controller.MCUDeviceType;
import de.mossgrabers.controller.mackie.mcu.controller.MCUDisplay;
import de.mossgrabers.controller.mackie.mcu.controller.MCUSegmentDisplay;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.controller.mackie.mcu.mode.MCUMultiModeSwitcherCommand;
import de.mossgrabers.controller.mackie.mcu.mode.MarkerMode;
import de.mossgrabers.controller.mackie.mcu.mode.device.DeviceBrowserMode;
import de.mossgrabers.controller.mackie.mcu.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.mackie.mcu.mode.device.UserMode;
import de.mossgrabers.controller.mackie.mcu.mode.layer.LayerMode;
import de.mossgrabers.controller.mackie.mcu.mode.layer.LayerPanMode;
import de.mossgrabers.controller.mackie.mcu.mode.layer.LayerSendMode;
import de.mossgrabers.controller.mackie.mcu.mode.layer.LayerVolumeMode;
import de.mossgrabers.controller.mackie.mcu.mode.track.MasterMode;
import de.mossgrabers.controller.mackie.mcu.mode.track.PanMode;
import de.mossgrabers.controller.mackie.mcu.mode.track.SendMode;
import de.mossgrabers.controller.mackie.mcu.mode.track.TrackMode;
import de.mossgrabers.controller.mackie.mcu.mode.track.VolumeMode;
import de.mossgrabers.framework.command.continuous.JogWheelCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.MarkerCommand;
import de.mossgrabers.framework.command.trigger.ShiftCommand;
import de.mossgrabers.framework.command.trigger.application.LayoutCommand;
import de.mossgrabers.framework.command.trigger.application.OverdubCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.application.PanelLayoutCommand;
import de.mossgrabers.framework.command.trigger.application.SaveCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.transport.AutomationModeCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.controller.valuechanger.SignedBit2RelativeValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IChannelBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.MasterVolumeMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ControlOnlyView;
import de.mossgrabers.framework.view.Views;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class MCUControllerSetup
extends AbstractControllerSetup<MCUControlSurface, MCUConfiguration> {
    private static final String TAG_RIGHT = "Right";
    public static final int MCU_BUTTON_STATE_ON = 127;
    public static final int MCU_BUTTON_STATE_OFF = 0;
    private static final Map<Modes, String> MODE_ACRONYMS = new EnumMap<Modes, String>(Modes.class);
    private static final Set<Modes> VALUE_MODES;
    private final int[] vuValues = new int[32];
    private final int[] vuValuesRight = new int[32];
    private final int[] masterVuValues = new int[2];
    private final int[] faderValues = new int[32];
    private int masterFaderValue = -1;
    private final int numMCUDevices;
    private IValueChanger encoderValueChanger;
    private JogWheelCommand<MCUControlSurface, MCUConfiguration> jogWheelCommand = null;
    private MasterVolumeMode<MCUControlSurface, MCUConfiguration> masterVolumeMode;

    public MCUControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, int numMCUDevices) {
        super(factory, host, globalSettings, documentSettings);
        this.numMCUDevices = numMCUDevices;
        Arrays.fill(this.vuValues, -1);
        Arrays.fill(this.faderValues, -1);
        Arrays.fill(this.masterVuValues, -1);
        this.colorManager = new MCUColorManager();
        this.valueChanger = new SignedBit2RelativeValueChanger(16242, 10);
        this.encoderValueChanger = new SignedBit2RelativeValueChanger(16242, 10);
        this.configuration = new MCUConfiguration(host, this.valueChanger, numMCUDevices, factory.getArpeggiatorModes());
    }

    @Override
    public void flush() {
        super.flush();
        this.surfaces.forEach(surface -> {
            try {
                ModeManager modeManager = surface.getModeManager();
                Modes mode = (Modes)((Object)((Object)modeManager.getActiveID()));
                this.updateMode(mode);
                if (mode == null) {
                    return;
                }
                this.updateVUMeters();
                this.updateFaders(surface.isShiftPressed());
                this.updateSegmentDisplay();
                IMode activeOrTempMode = (IMode)modeManager.getActive();
                if (activeOrTempMode instanceof BaseMode) {
                    BaseMode baseMode = (BaseMode)activeOrTempMode;
                    baseMode.updateKnobLEDs();
                }
            }
            catch (Exception ex) {
                this.host.error("Error during flush.", ex);
            }
        });
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.enableDevice(DeviceID.EQ);
        ms.enableDevice(DeviceID.FIRST_INSTRUMENT);
        ms.setWantsFocusedParameter(true);
        if (((MCUConfiguration)this.configuration).shouldPinFXTracksToLastController()) {
            int numReduced = 8 * (this.numMCUDevices - 1);
            ms.setNumTracks(numReduced);
            ms.setNumFxTracks(8);
            ms.setNumDeviceLayers(numReduced);
            ms.setNumDrumPadLayers(numReduced);
            ms.setNumDevicesInBank(numReduced);
            ms.setNumParams(numReduced);
        } else {
            ms.setNumTracks(8 * this.numMCUDevices);
            ms.setNumDeviceLayers(8 * this.numMCUDevices);
            ms.setNumDrumPadLayers(8 * this.numMCUDevices);
            ms.setNumDevicesInBank(8 * this.numMCUDevices);
            ms.setNumParams(8 * this.numMCUDevices);
        }
        ms.setNumParamPages(8 * this.numMCUDevices);
        ms.setHasFlatTrackList(((MCUConfiguration)this.configuration).isTrackNavigationFlat());
        ms.setHasFullFlatTrackList(((MCUConfiguration)this.configuration).shouldIncludeFXTracksInTrackBank());
        ms.setNumSends(14);
        ms.setNumScenes(8);
        ms.setNumFilterColumnEntries(8);
        ms.setNumResults(8);
        ms.setNumMarkers(8 * this.numMCUDevices);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        for (int i = 0; i < this.numMCUDevices; ++i) {
            MCUDeviceType deviceType = ((MCUConfiguration)this.configuration).getDeviceType(i);
            boolean isMainDevice = deviceType == MCUDeviceType.MAIN;
            IMidiOutput output = midiAccess.createOutput(i);
            IMidiInput input = midiAccess.createInput(i, null, new String[0]);
            MCUControlSurface surface = new MCUControlSurface(this.surfaces, this.host, this.colorManager, (MCUConfiguration)this.configuration, output, input, 8 * i, isMainDevice);
            this.surfaces.add(surface);
            surface.addTextDisplay(new MCUDisplay(this.host, output, true, deviceType == MCUDeviceType.MACKIE_EXTENDER, false, this.configuration));
            surface.addTextDisplay(new MCUDisplay(this.host, output, false, false, isMainDevice, this.configuration));
            surface.addTextDisplay(new MCUSegmentDisplay(this.host, output));
            surface.addTextDisplay(new MCUAssignmentDisplay(this.host, output));
            surface.getModeManager().setDefaultID(Modes.VOLUME);
        }
    }

    @Override
    protected void createModes() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            int i;
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            ModeManager modeManager = surface.getModeManager();
            if (((MCUConfiguration)this.configuration).getDeviceType(index) == MCUDeviceType.MAIN) {
                this.masterVolumeMode = new MasterVolumeMode(surface, this.model, ContinuousID.FADER_MASTER);
            }
            modeManager.register(Modes.TRACK, new TrackMode(surface, this.model));
            modeManager.register(Modes.VOLUME, new VolumeMode(surface, this.model));
            modeManager.register(Modes.PAN, new PanMode(surface, this.model));
            for (i = 0; i < 8; ++i) {
                modeManager.register(Modes.get(Modes.SEND1, i), new SendMode(surface, this.model, i));
            }
            modeManager.register(Modes.MASTER, new MasterMode(surface, this.model));
            modeManager.register(Modes.DEVICE_LAYER, new LayerMode(surface, this.model));
            modeManager.register(Modes.DEVICE_LAYER_VOLUME, new LayerVolumeMode(surface, this.model));
            modeManager.register(Modes.DEVICE_LAYER_PAN, new LayerPanMode(surface, this.model));
            for (i = 0; i < 8; ++i) {
                modeManager.register(Modes.get(Modes.DEVICE_LAYER_SEND1, i), new LayerSendMode(surface, this.model, i));
            }
            modeManager.register(Modes.DEVICE_PARAMS, new DeviceParamsMode(surface, this.model));
            modeManager.register(Modes.EQ_DEVICE_PARAMS, new DeviceParamsMode("Equalizer", this.model.getSpecificDevice(DeviceID.EQ), surface, this.model));
            modeManager.register(Modes.INSTRUMENT_DEVICE_PARAMS, new DeviceParamsMode("First Instrument", this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT), surface, this.model));
            modeManager.register(Modes.USER, new UserMode(surface, this.model));
            modeManager.register(Modes.BROWSER, new DeviceBrowserMode(surface, this.model));
            modeManager.register(Modes.MARKERS, new MarkerMode(surface, this.model));
        }
    }

    @Override
    protected void createViews() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            surface.getViewManager().register(Views.CONTROL, new ControlOnlyView(surface, this.model));
        }
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        for (int i = 0; i < this.numMCUDevices; ++i) {
            ModeManager mm = ((MCUControlSurface)this.getSurface(i)).getModeManager();
            for (int j = 0; j < this.numMCUDevices; ++j) {
                if (i == j) continue;
                ((MCUControlSurface)this.getSurface(j)).getModeManager().addConnectedManagerListener(mm);
            }
        }
        this.model.getMasterTrack().addSelectionObserver((index, isSelected) -> {
            ModeManager modeManager = ((MCUControlSurface)this.getSurface()).getModeManager();
            if (isSelected && modeManager.isActive(new Modes[]{Modes.TRACK})) {
                modeManager.setActive(Modes.MASTER);
            }
        });
        ((MCUConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.VU_METER_TYPE, () -> {
            for (int index = 0; index < this.numMCUDevices; ++index) {
                MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
                surface.switchVuMode(((MCUConfiguration)this.configuration).isEnableVUMeters() ? 3 : 2);
                IMode activeMode = (IMode)surface.getModeManager().getActive();
                if (activeMode != null) {
                    activeMode.updateDisplay();
                }
                ((MCUDisplay)surface.getDisplay()).forceFlush();
            }
        });
        ((MCUConfiguration)this.configuration).addSettingObserver(MCUConfiguration.USE_FADERS_AS_KNOBS, () -> {
            for (int index = 0; index < this.numMCUDevices; ++index) {
                MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
                AbstractParameterMode mode = (AbstractParameterMode)surface.getModeManager().getActive();
                if (mode == null) continue;
                mode.parametersAdjusted();
            }
        });
        ((MCUConfiguration)this.configuration).addSettingObserver(MCUConfiguration.MAIN_DISPLAY, () -> {
            MCUConfiguration.MainDisplay mainDisplayType = ((MCUConfiguration)this.configuration).getMainDisplayType();
            boolean shouldUse7Characters = mainDisplayType == MCUConfiguration.MainDisplay.MACKIE_7_CHARACTERS;
            boolean isAsparion = mainDisplayType == MCUConfiguration.MainDisplay.ASPARION;
            for (int index = 0; index < this.numMCUDevices; ++index) {
                MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
                MCUDisplay mcuDisplay = (MCUDisplay)surface.getTextDisplay();
                mcuDisplay.insertSpace(!shouldUse7Characters);
                mcuDisplay.changeDisplaySize((isAsparion ? 12 : 7) * 8);
            }
        });
        ((MCUConfiguration)this.configuration).addSettingObserver(MCUConfiguration.SECOND_DISPLAY, () -> {
            boolean isAsparion = ((MCUConfiguration)this.configuration).getSecondDisplayType() == MCUConfiguration.SecondDisplay.ASPARION;
            for (int index = 0; index < this.numMCUDevices; ++index) {
                MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
                MCUDisplay secondDisplay = (MCUDisplay)surface.getTextDisplay(1);
                secondDisplay.updateShortSecondDisplay();
                secondDisplay.changeDisplaySize((isAsparion ? 8 : 7) * 8);
            }
        });
        ((MCUConfiguration)this.configuration).addSettingObserver(MCUConfiguration.ASSIGNABLE_BUTTONS, () -> {
            this.jogWheelCommand.setControlLastParamActive(false);
            this.masterVolumeMode.setControlLastParamActive(false);
        });
        ((MCUConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.activateBrowserObserver(Modes.BROWSER);
    }

    @Override
    protected void registerTriggerCommands() {
        ITransport t = this.model.getTransport();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            if (((MCUConfiguration)this.configuration).getDeviceType(index) == MCUDeviceType.MAIN) {
                this.jogWheelCommand = new JogWheelCommand(this.model, surface, this.encoderValueChanger);
                MCUWindCommand rewindCommand = new MCUWindCommand(this.model, surface, false);
                MCUWindCommand forwardCommand = new MCUWindCommand(this.model, surface, true);
                this.addButton(surface, ButtonID.REWIND, "<<", (TriggerCommand)rewindCommand, 0, 91, rewindCommand::isRewinding);
                this.addButton(surface, ButtonID.FORWARD, ">>", (TriggerCommand)forwardCommand, 0, 92, forwardCommand::isForwarding);
                this.addButton(surface, ButtonID.LOOP, "Loop", new ToggleLoopCommand(this.model, surface), 0, 86, t::isLoop);
                this.addButton(surface, ButtonID.STOP, "Stop", new StopCommand(this.model, surface), 0, 93, () -> !t.isPlaying());
                this.addButton(surface, ButtonID.PLAY, "Play", new PlayCommand(this.model, surface), 0, 94, t::isPlaying);
                this.addButton(surface, ButtonID.RECORD, "Record", new RecordCommand(this.model, surface), 0, 95, () -> {
                    boolean isOn = this.isRecordShifted(surface) ? t.isLauncherOverdub() : t.isRecording();
                    return isOn ? 127 : 0;
                }, new String[0]);
                this.addButton(surface, ButtonID.SCRUB, "Scrub", (TriggerCommand)new ScrubCommand(this.model, surface), 0, 101, () -> surface.getModeManager().isActive(new Modes[]{Modes.DEVICE_PARAMS}));
                this.addButton(surface, ButtonID.ARROW_LEFT, "Left", (TriggerCommand)new MCUCursorCommand(Direction.LEFT, this.model, surface), 0, 98);
                this.addButton(surface, ButtonID.ARROW_RIGHT, TAG_RIGHT, (TriggerCommand)new MCUCursorCommand(Direction.RIGHT, this.model, surface), 0, 99);
                this.addButton(surface, ButtonID.ARROW_UP, "Up", (TriggerCommand)new MCUCursorCommand(Direction.UP, this.model, surface), 0, 96);
                this.addButton(surface, ButtonID.ARROW_DOWN, "Down", (TriggerCommand)new MCUCursorCommand(Direction.DOWN, this.model, surface), 0, 97);
                this.addButton(surface, ButtonID.ZOOM, "Zoom", (TriggerCommand)new ZoomCommand(this.model, surface), 0, 100, ((MCUConfiguration)surface.getConfiguration())::isZoomState);
                this.addButton(surface, ButtonID.TOGGLE_DISPLAY, "Toggle Display", (TriggerCommand)new ToggleDisplayCommand(this.model, surface), 0, 52, ((MCUConfiguration)surface.getConfiguration())::isDisplayTrackNames);
                this.addButton(surface, ButtonID.TEMPO_TICKS, "Tempo Ticks", (TriggerCommand)new TempoTicksCommand(this.model, surface), 0, 53, ((MCUConfiguration)this.configuration)::isDisplayTicks);
                this.addButton(surface, ButtonID.SHIFT, "Shift", new ShiftCommand(this.model, surface), 0, 70);
                this.addButton(surface, ButtonID.SELECT, "Option", (TriggerCommand)NopCommand.INSTANCE, 0, 71);
                this.addButton(surface, ButtonID.FOOTSWITCH1, "Footswitch 1", new AssignableCommand(0, this.model, surface, this.jogWheelCommand, this.masterVolumeMode), 102);
                this.addButton(surface, ButtonID.FOOTSWITCH2, "Footswitch 2", new AssignableCommand(1, this.model, surface, this.jogWheelCommand, this.masterVolumeMode), 103);
                for (int i = 0; i < 8; ++i) {
                    AssignableCommand command = new AssignableCommand(2 + i, this.model, surface, this.jogWheelCommand, this.masterVolumeMode);
                    this.addButton(surface, ButtonID.get(ButtonID.F1, i), "F" + (i + 1), (TriggerCommand)command, 0, 54 + i, command::isActive);
                }
                ModeManager modeManager = surface.getModeManager();
                this.addButton(surface, ButtonID.TRACK, "Track", (TriggerCommand)new TracksCommand(this.model, surface), 0, 40, () -> surface.getButton(ButtonID.SELECT).isPressed() ? this.model.getCursorTrack().isPinned() : modeManager.isActive(new Modes[]{Modes.TRACK, Modes.VOLUME, Modes.DEVICE_LAYER, Modes.DEVICE_LAYER_VOLUME}));
                this.addButton(surface, ButtonID.PAN_SEND, "Pan", (TriggerCommand)new PanCommand(this.model, surface), 0, 42, () -> modeManager.isActive(new Modes[]{Modes.PAN, Modes.DEVICE_LAYER_PAN}));
                this.addButton(surface, ButtonID.SENDS, "Sends", (TriggerCommand)new SendSelectCommand(this.model, surface), 0, 41, () -> Modes.isSendMode((Modes)((Object)((Object)modeManager.getActiveID()))) || Modes.isLayerSendMode((Modes)((Object)((Object)modeManager.getActiveID()))));
                this.addButton(surface, ButtonID.DEVICE, "Device", (TriggerCommand)new DevicesCommand(this.model, surface), 0, 43, () -> surface.getButton(ButtonID.SELECT).isPressed() ? cursorDevice.isPinned() : modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS, Modes.USER}));
                this.addButton(surface, ButtonID.PAGE_LEFT, "EQ", (TriggerCommand)new MCUMultiModeSwitcherCommand(this.model, surface, Modes.EQ_DEVICE_PARAMS), 0, 44, () -> modeManager.isActive(new Modes[]{Modes.EQ_DEVICE_PARAMS}));
                this.addButton(surface, ButtonID.PAGE_RIGHT, "INST", (TriggerCommand)new MCUMultiModeSwitcherCommand(this.model, surface, Modes.INSTRUMENT_DEVICE_PARAMS), 0, 45, () -> modeManager.isActive(new Modes[]{Modes.INSTRUMENT_DEVICE_PARAMS}));
                this.addButton(surface, ButtonID.MOVE_TRACK_LEFT, "Left", (TriggerCommand)new MCUMoveTrackBankCommand(this.model, surface, true, true), 0, 48);
                this.addButton(surface, ButtonID.MOVE_TRACK_RIGHT, TAG_RIGHT, (TriggerCommand)new MCUMoveTrackBankCommand(this.model, surface, true, false), 0, 49);
                this.addButton(surface, ButtonID.AUTOMATION_TRIM, "Trim", new AutomationModeCommand(AutomationMode.TRIM_READ, this.model, surface, false), 0, 76, () -> t.getAutomationWriteMode() == AutomationMode.TRIM_READ);
                this.addButton(surface, ButtonID.AUTOMATION_READ, "Read", new AutomationModeCommand(AutomationMode.READ, this.model, surface, false), 0, 74, () -> t.getAutomationWriteMode() == AutomationMode.READ);
                this.addButton(surface, ButtonID.AUTOMATION_WRITE, "Write", new AutomationModeCommand(AutomationMode.WRITE, this.model, surface, false), 0, 75, () -> t.getAutomationWriteMode() == AutomationMode.WRITE);
                this.addButton(surface, ButtonID.AUTOMATION_GROUP, "Group/Write", new AutomationModeCommand(AutomationMode.LATCH_PREVIEW, this.model, surface, false), 0, 79, () -> t.getAutomationWriteMode() == AutomationMode.LATCH_PREVIEW);
                this.addButton(surface, ButtonID.AUTOMATION_TOUCH, "Touch", new AutomationModeCommand(AutomationMode.TOUCH, this.model, surface, false), 0, 77, () -> t.getAutomationWriteMode() == AutomationMode.TOUCH);
                this.addButton(surface, ButtonID.AUTOMATION_LATCH, "Latch", new AutomationModeCommand(AutomationMode.LATCH, this.model, surface, false), 0, 78, () -> t.getAutomationWriteMode() == AutomationMode.LATCH);
                this.addButton(surface, ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), 81);
                this.addButton(surface, ButtonID.NOTE_EDITOR, "Note Editor", new PaneCommand(PaneCommand.Panels.NOTE, this.model, surface), 62);
                this.addButton(surface, ButtonID.AUTOMATION_EDITOR, "Automation Editor", new PaneCommand(PaneCommand.Panels.AUTOMATION, this.model, surface), 63);
                this.addButton(surface, ButtonID.TOGGLE_DEVICE, "Toggle Device", new PanelLayoutCommand(this.model, surface), 0, 64, () -> !surface.isShiftPressed() && cursorDevice.isWindowOpen());
                this.addButton(surface, ButtonID.MIXER, "Mixer", new PaneCommand(PaneCommand.Panels.MIXER, this.model, surface), 65);
                this.addButton(surface, ButtonID.LAYOUT_ARRANGE, "Arrange", new LayoutCommand("ARRANGE", this.model, surface), 66);
                this.addButton(surface, ButtonID.LAYOUT_MIX, "Mix", new LayoutCommand("MIX", this.model, surface), 67);
                this.addButton(surface, ButtonID.LAYOUT_EDIT, "Edit", new LayoutCommand("EDIT", this.model, surface), 68);
                this.addButton(surface, ButtonID.BROWSE, "Browse", new BrowserCommand(this.model, surface), 0, 69, () -> modeManager.isActive(new Modes[]{Modes.BROWSER}));
                this.addButton(surface, ButtonID.METRONOME, "Metronome", new MetronomeCommand(this.model, surface, false), 0, 89, () -> surface.getButton(ButtonID.SHIFT).isPressed() ? t.isMetronomeTicksOn() : t.isMetronomeOn());
                IProject project = this.model.getProject();
                this.addButton(surface, ButtonID.GROOVE, "Solo Defeat", (ButtonEvent event, int velocity) -> {
                    if (event != ButtonEvent.DOWN) {
                        return;
                    }
                    this.handleSoloDefeat(surface, project);
                }, 0, 90, () -> this.getSoloState(surface, project));
                this.addButton(surface, ButtonID.OVERDUB, "Overdub", new OverdubCommand(this.model, surface), 0, 88, () -> surface.getButton(ButtonID.SHIFT).isPressed() ? t.isLauncherOverdub() : t.isArrangerOverdub());
                this.addButton(surface, ButtonID.TAP_TEMPO, "Tap Tempo", new TapTempoCommand(this.model, surface), 0, 85);
                this.addButton(surface, ButtonID.DUPLICATE, "Duplicate", (ButtonEvent event, int velocity) -> {
                    if (event == ButtonEvent.DOWN) {
                        this.model.getCursorTrack().duplicate();
                    }
                }, 0, 87);
                this.addButton(surface, ButtonID.CONTROL, "Control", NopCommand.INSTANCE, 72);
                this.addButton(surface, ButtonID.ALT, "Alt", NopCommand.INSTANCE, 73);
                this.addButton(surface, ButtonID.FLIP, "Flip", (TriggerCommand)new MCUFlipCommand(this.model, surface), 0, 50, this::isFlipped);
                this.addButton(surface, ButtonID.CANCEL, "Cancel", new KeyCommand(KeyCommand.Key.ESCAPE, this.model, surface), 82);
                this.addButton(surface, ButtonID.ENTER, "Enter", new KeyCommand(KeyCommand.Key.ENTER, this.model, surface), 83);
                this.addButton(surface, ButtonID.MOVE_BANK_LEFT, "Bank Left", new MCUMoveTrackBankCommand(this.model, surface, false, true), 46);
                this.addButton(surface, ButtonID.MOVE_BANK_RIGHT, "Bank Right", new MCUMoveTrackBankCommand(this.model, surface, false, false), 47);
                this.addButton(surface, ButtonID.NEW, "New", new NewCommand(this.model, surface), -1);
                this.addButton(surface, ButtonID.SAVE, "Save", new SaveCommand(this.model, surface), 0, 80, () -> this.model.getProject().isDirty());
                this.addButton(surface, ButtonID.MARKER, "Marker", new MarkerCommand(this.model, surface), 0, 84, () -> surface.getButton(ButtonID.SHIFT).isPressed() ? this.model.getArranger().areCueMarkersVisible() : modeManager.isActive(new Modes[]{Modes.MARKERS}));
                this.addButton(surface, ButtonID.TOGGLE_VU, "Toggle VU", (ButtonEvent event, int velocity) -> {
                    if (event == ButtonEvent.DOWN) {
                        ((MCUConfiguration)this.configuration).toggleVuMetersEnabled();
                    }
                }, 0, 51, () -> ((MCUConfiguration)this.configuration).areVuMetersEnabled());
                this.addLight(surface, OutputID.LED1, 0, 113, () -> ((MCUConfiguration)this.configuration).isDisplayTicks() ? 2 : 0, new String[0]);
                this.addLight(surface, OutputID.LED2, 0, 114, () -> !((MCUConfiguration)this.configuration).isDisplayTicks() ? 2 : 0, new String[0]);
            }
            for (int i = 0; i < 8; ++i) {
                ButtonID row1ButtonID = ButtonID.get(ButtonID.ROW2_1, i);
                ButtonID row2ButtonID = ButtonID.get(ButtonID.ROW3_1, i);
                ButtonID row3ButtonID = ButtonID.get(ButtonID.ROW4_1, i);
                ButtonID row4ButtonID = ButtonID.get(ButtonID.ROW_SELECT_1, i);
                int labelIndex = 8 * (this.numMCUDevices - index - 1) + i + 1;
                this.addButton(surface, row1ButtonID, "Rec Arm " + labelIndex, new ButtonRowModeCommand(1, i, this.model, surface), 0 + i, () -> this.getButtonColor(surface, row1ButtonID), new String[0]);
                this.addButton(surface, row2ButtonID, "Solo " + labelIndex, new ButtonRowModeCommand(2, i, this.model, surface), 8 + i, () -> this.getButtonColor(surface, row2ButtonID), new String[0]);
                this.addButton(surface, row3ButtonID, "Mute " + labelIndex, new ButtonRowModeCommand(3, i, this.model, surface), 16 + i, () -> this.getButtonColor(surface, row3ButtonID), new String[0]);
                this.addButton(surface, row4ButtonID, "Select " + labelIndex, (TriggerCommand)new SelectCommand(i, this.model, surface), 24 + i, () -> this.getButtonColor(surface, row4ButtonID), new String[0]);
            }
        }
    }

    @Override
    protected void registerContinuousCommands() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            IMidiInput input = surface.getMidiInput();
            if (((MCUConfiguration)this.configuration).getDeviceType(index) == MCUDeviceType.MAIN) {
                this.addRelativeKnob(surface, ContinuousID.PLAY_POSITION, "Jog Wheel", this.jogWheelCommand, 60, RelativeEncoding.SIGNED_BIT2);
                IHwFader master = this.addFader(surface, ContinuousID.FADER_MASTER, "Master", null, 8);
                master.bindTouch(new FaderTouchCommand(8, this.model, surface, this.masterVolumeMode), input, BindType.NOTE, 0, 112);
                if (((MCUConfiguration)this.configuration).hasMotorFaders()) {
                    master.disableTakeOver();
                }
                this.masterVolumeMode.onActivate();
            }
            for (int i = 0; i < 8; ++i) {
                IHwRelativeKnob knob = this.addRelativeKnob(surface, ContinuousID.get(ContinuousID.KNOB1, i), "Knob " + i, new KnobRowModeCommand(i, this.model, surface), 16 + i, RelativeEncoding.SIGNED_BIT2);
                knob.bindTouch(new ButtonRowModeCommand(0, i, this.model, surface), input, BindType.NOTE, 0, 32 + i);
                knob.setIndexInGroup(index * 8 + i);
                IHwFader fader = this.addFader(surface, ContinuousID.get(ContinuousID.FADER1, i), "Fader " + (i + 1), null, i);
                if (((MCUConfiguration)this.configuration).hasMotorFaders()) {
                    fader.disableTakeOver();
                }
                fader.bindTouch(new FaderTouchCommand(i, this.model, surface, null), input, BindType.NOTE, 0, 104 + i);
                fader.setIndexInGroup(index * 8 + i);
            }
        }
    }

    @Override
    protected void layoutControls() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            if (((MCUConfiguration)this.configuration).getDeviceType(index) == MCUDeviceType.MAIN) {
                surface.getButton(ButtonID.FOOTSWITCH1).setBounds(12.5, 942.0, 77.75, 39.75);
                surface.getButton(ButtonID.FOOTSWITCH2).setBounds(102.5, 942.0, 77.75, 39.75);
                surface.getButton(ButtonID.REWIND).setBounds(556.0, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.FORWARD).setBounds(630.0, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.LOOP).setBounds(706.25, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.STOP).setBounds(779.0, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.PLAY).setBounds(850.25, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.RECORD).setBounds(923.5, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.SCRUB).setBounds(922.25, 697.25, 65.0, 39.75);
                surface.getButton(ButtonID.ARROW_LEFT).setBounds(705.0, 750.25, 65.0, 39.75);
                surface.getButton(ButtonID.ARROW_RIGHT).setBounds(849.0, 750.25, 65.0, 39.75);
                surface.getButton(ButtonID.ARROW_UP).setBounds(777.75, 702.25, 65.0, 39.75);
                surface.getButton(ButtonID.ARROW_DOWN).setBounds(777.75, 797.0, 65.0, 39.75);
                surface.getButton(ButtonID.ZOOM).setBounds(777.75, 750.25, 65.0, 39.75);
                surface.getButton(ButtonID.TOGGLE_DISPLAY).setBounds(701.25, 92.5, 77.75, 39.75);
                surface.getButton(ButtonID.TEMPO_TICKS).setBounds(879.0, 92.5, 77.75, 39.75);
                surface.getButton(ButtonID.SHIFT).setBounds(776.5, 637.5, 65.0, 39.75);
                surface.getButton(ButtonID.SELECT).setBounds(703.75, 637.5, 65.0, 39.75);
                surface.getButton(ButtonID.F1).setBounds(632.5, 178.25, 65.0, 39.75);
                surface.getButton(ButtonID.F2).setBounds(705.0, 178.25, 65.0, 39.75);
                surface.getButton(ButtonID.F3).setBounds(777.75, 178.25, 65.0, 39.75);
                surface.getButton(ButtonID.F4).setBounds(849.25, 178.25, 65.0, 39.75);
                surface.getButton(ButtonID.F5).setBounds(921.5, 178.25, 65.0, 39.75);
                surface.getButton(ButtonID.F6).setBounds(705.0, 320.25, 65.0, 39.75);
                surface.getButton(ButtonID.F7).setBounds(777.75, 320.25, 65.0, 39.75);
                surface.getButton(ButtonID.F8).setBounds(921.0, 590.0, 65.0, 39.75);
                surface.getButton(ButtonID.TRACK).setBounds(705.0, 225.25, 65.0, 39.75);
                surface.getButton(ButtonID.PAN_SEND).setBounds(777.75, 225.25, 65.0, 39.75);
                surface.getButton(ButtonID.SENDS).setBounds(849.25, 225.25, 65.0, 39.75);
                surface.getButton(ButtonID.DEVICE).setBounds(921.5, 225.25, 65.0, 39.75);
                surface.getButton(ButtonID.PAGE_LEFT).setBounds(632.5, 367.5, 65.0, 39.75);
                surface.getButton(ButtonID.PAGE_RIGHT).setBounds(632.5, 416.0, 65.0, 39.75);
                surface.getButton(ButtonID.MOVE_TRACK_LEFT).setBounds(847.75, 542.0, 65.0, 39.75);
                surface.getButton(ButtonID.MOVE_TRACK_RIGHT).setBounds(921.0, 542.0, 65.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_READ).setBounds(632.5, 272.25, 65.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_WRITE).setBounds(705.0, 272.25, 30.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_GROUP).setBounds(740.0, 272.25, 30.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_TRIM).setBounds(777.75, 272.25, 65.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_TOUCH).setBounds(849.25, 272.25, 65.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_LATCH).setBounds(921.5, 272.25, 65.0, 39.75);
                surface.getButton(ButtonID.UNDO).setBounds(849.25, 320.25, 65.0, 39.75);
                surface.getButton(ButtonID.NOTE_EDITOR).setBounds(705.0, 366.75, 65.0, 39.75);
                surface.getButton(ButtonID.AUTOMATION_EDITOR).setBounds(777.75, 366.75, 65.0, 39.75);
                surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(849.25, 366.75, 65.0, 39.75);
                surface.getButton(ButtonID.MIXER).setBounds(921.5, 366.75, 65.0, 39.75);
                surface.getButton(ButtonID.LAYOUT_ARRANGE).setBounds(703.75, 591.0, 65.0, 39.75);
                surface.getButton(ButtonID.LAYOUT_MIX).setBounds(776.5, 591.0, 65.0, 39.75);
                surface.getButton(ButtonID.LAYOUT_EDIT).setBounds(847.75, 591.0, 65.0, 39.75);
                surface.getButton(ButtonID.BROWSE).setBounds(705.0, 416.75, 65.0, 39.75);
                surface.getButton(ButtonID.METRONOME).setBounds(777.75, 416.75, 65.0, 39.75);
                surface.getButton(ButtonID.GROOVE).setBounds(849.25, 416.75, 65.0, 39.75);
                surface.getButton(ButtonID.OVERDUB).setBounds(921.5, 416.75, 65.0, 39.75);
                surface.getButton(ButtonID.TAP_TEMPO).setBounds(481.25, 942.0, 65.0, 39.75);
                surface.getButton(ButtonID.DUPLICATE).setBounds(776.5, 492.75, 65.0, 39.75);
                surface.getButton(ButtonID.CONTROL).setBounds(921.0, 637.5, 65.0, 39.75);
                surface.getButton(ButtonID.ALT).setBounds(847.75, 637.5, 65.0, 39.75);
                surface.getButton(ButtonID.FLIP).setBounds(703.75, 492.75, 65.0, 39.75);
                surface.getButton(ButtonID.CANCEL).setBounds(847.75, 492.75, 65.0, 39.75);
                surface.getButton(ButtonID.ENTER).setBounds(921.0, 492.75, 65.0, 39.75);
                surface.getButton(ButtonID.MOVE_BANK_LEFT).setBounds(703.75, 542.0, 65.0, 39.75);
                surface.getButton(ButtonID.MOVE_BANK_RIGHT).setBounds(776.5, 542.0, 65.0, 39.75);
                surface.getButton(ButtonID.NEW).setBounds(392.0, 942.0, 77.75, 39.75);
                surface.getButton(ButtonID.SAVE).setBounds(921.5, 320.25, 65.0, 39.75);
                surface.getButton(ButtonID.MARKER).setBounds(632.5, 225.25, 65.0, 39.75);
                surface.getButton(ButtonID.TOGGLE_VU).setBounds(790.25, 92.5, 77.75, 39.75);
                surface.getContinuous(ContinuousID.PLAY_POSITION).setBounds(859.5, 806.5, 115.25, 115.75);
                surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(613.5, 501.5, 65.0, 419.0);
                surface.getTextDisplay(2).getHardwareDisplay().setBounds(699.0, 27.0, 263.25, 44.25);
                surface.getTextDisplay(3).getHardwareDisplay().setBounds(633.5, 92.5, 49.5, 39.75);
                surface.getLight(OutputID.LED1).setBounds(968.5, 92.5, 21.25, 12.75);
                surface.getLight(OutputID.LED2).setBounds(968.5, 119.5, 21.25, 12.75);
            }
            surface.getButton(ButtonID.ROW2_1).setBounds(12.75, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_1).setBounds(12.75, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_1).setBounds(12.75, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_1).setBounds(12.75, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_2).setBounds(87.25, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_2).setBounds(87.25, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_2).setBounds(87.25, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_2).setBounds(87.25, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_3).setBounds(163.75, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_3).setBounds(163.75, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_3).setBounds(163.75, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_3).setBounds(163.75, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_4).setBounds(237.0, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_4).setBounds(237.0, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_4).setBounds(237.0, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_4).setBounds(237.0, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_5).setBounds(311.25, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_5).setBounds(311.25, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_5).setBounds(311.25, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_5).setBounds(311.25, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_6).setBounds(386.5, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_6).setBounds(386.5, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_6).setBounds(386.5, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_6).setBounds(386.5, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_7).setBounds(459.0, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_7).setBounds(459.0, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_7).setBounds(459.0, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_7).setBounds(459.0, 366.75, 65.0, 39.75);
            surface.getButton(ButtonID.ROW2_8).setBounds(532.25, 178.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW3_8).setBounds(532.25, 225.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW4_8).setBounds(532.25, 272.25, 65.0, 39.75);
            surface.getButton(ButtonID.ROW_SELECT_8).setBounds(532.25, 366.75, 65.0, 39.75);
            surface.getContinuous(ContinuousID.KNOB1).setBounds(12.25, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB2).setBounds(86.25, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB3).setBounds(160.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB4).setBounds(234.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB5).setBounds(308.0, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB6).setBounds(381.75, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB7).setBounds(455.75, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.KNOB8).setBounds(529.5, 93.5, 72.0, 74.75);
            surface.getContinuous(ContinuousID.FADER1).setBounds(12.5, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER2).setBounds(87.25, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER3).setBounds(163.75, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER4).setBounds(237.0, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER5).setBounds(311.25, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER6).setBounds(386.5, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER7).setBounds(459.0, 501.5, 65.0, 419.0);
            surface.getContinuous(ContinuousID.FADER8).setBounds(532.25, 501.5, 65.0, 419.0);
            surface.getTextDisplay(0).getHardwareDisplay().setBounds(11.75, 11.75, 601.0, 73.25);
            surface.getTextDisplay(1).getHardwareDisplay().setBounds(11.5, 419.5, 668.25, 73.25);
        }
    }

    @Override
    public void startup() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            surface.switchVuMode(1);
            surface.getViewManager().setActive(Views.CONTROL);
            surface.getModeManager().setActive(Modes.PAN);
        }
    }

    private void updateSegmentDisplay() {
        if (!((MCUConfiguration)this.configuration).hasSegmentDisplay()) {
            return;
        }
        ITransport t = this.model.getTransport();
        Object positionText = ((MCUConfiguration)this.configuration).isDisplayTime() ? t.getPositionText() : t.getBeatText();
        positionText = ((String)positionText).replace('.', ':');
        if (((MCUConfiguration)this.configuration).isDisplayTicks()) {
            if (!((MCUConfiguration)this.configuration).isDisplayTime()) {
                positionText = (String)positionText + " ";
            }
        } else {
            Object tempoStr = t.formatTempoNoFraction(t.getTempo());
            int pos = ((String)positionText).lastIndexOf(58);
            if (((String)tempoStr).length() < 3) {
                tempoStr = "0" + (String)tempoStr;
            }
            positionText = ((String)positionText).substring(0, pos + 1) + (String)tempoStr;
        }
        for (int index = 0; index < this.numMCUDevices; ++index) {
            if (((MCUConfiguration)this.configuration).getDeviceType(index) != MCUDeviceType.MAIN) continue;
            ((MCUControlSurface)this.getSurface(index)).getTextDisplay(2).setRow(0, (String)positionText).allDone();
        }
    }

    private void updateVUMeters() {
        ICursorDevice cursorDevice;
        if (!((MCUConfiguration)this.configuration).isEnableVUMeters() || !((MCUConfiguration)this.configuration).areVuMetersEnabled()) {
            return;
        }
        Modes activeMode = (Modes)((Object)((MCUControlSurface)this.getSurface()).getModeManager().getActiveID());
        IChannelBank<ITrack> currentChannelBank = Modes.isLayerMode(activeMode) ? ((cursorDevice = this.model.getCursorDevice()).hasDrumPads() ? cursorDevice.getDrumPadBank() : cursorDevice.getLayerBank()) : this.model.getCurrentTrackBank();
        MCUConfiguration.VUMeterStyle vuMeterStyle = ((MCUConfiguration)this.configuration).getVuMeterStyle();
        boolean shouldPinFXTracksToLastController = ((MCUConfiguration)this.configuration).shouldPinFXTracksToLastController();
        boolean alwaysSendVuMeters = ((MCUConfiguration)this.configuration).alwaysSendVuMeters();
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            IMidiOutput output = surface.getMidiOutput();
            boolean pinLastDevice = shouldPinFXTracksToLastController && index == this.numMCUDevices - 1;
            ITrackBank effectTrackBank = this.model.getEffectTrackBank();
            IChannelBank<ITrack> channelBank = pinLastDevice && effectTrackBank != null ? effectTrackBank : currentChannelBank;
            int extenderOffset = pinLastDevice ? 0 : surface.getExtenderOffset();
            for (int i = 0; i < 8; ++i) {
                int channel = extenderOffset + i;
                IChannel track = (IChannel)channelBank.getItem(channel);
                if (vuMeterStyle == MCUConfiguration.VUMeterStyle.ASPARION) {
                    int vuRight;
                    int scaledVuRight;
                    int vuLeft = track.getVuLeft();
                    int scaledVuLeft = this.scaleVU(vuLeft);
                    if (this.vuValues[channel] != scaledVuLeft || alwaysSendVuMeters) {
                        this.vuValues[channel] = scaledVuLeft;
                        this.sendVUValue(output, i, scaledVuLeft, track.getVuLeftClipState(), false);
                    }
                    if (this.vuValuesRight[channel] == (scaledVuRight = this.scaleVU(vuRight = track.getVuRight())) && !alwaysSendVuMeters) continue;
                    this.vuValuesRight[channel] = scaledVuRight;
                    this.sendVUValue(output, i, scaledVuRight, track.getVuRightClipState(), true);
                    continue;
                }
                int vu = track.getVu();
                int scaledVu = this.scaleVU(vu);
                if (this.vuValues[channel] == scaledVu && !alwaysSendVuMeters) continue;
                this.vuValues[channel] = scaledVu;
                this.sendVUValue(output, i, scaledVu, track.getVuClipState(), false);
            }
            if (vuMeterStyle != MCUConfiguration.VUMeterStyle.ICON || ((MCUConfiguration)this.configuration).getDeviceType(index) != MCUDeviceType.MAIN) continue;
            IMasterTrack masterTrack = this.model.getMasterTrack();
            int vu = masterTrack.getVuLeft();
            int scaledVu = this.scaleVU(vu);
            if (this.masterVuValues[0] != scaledVu) {
                this.masterVuValues[0] = scaledVu;
                this.sendVUValue(output, 0, scaledVu, false, true);
            }
            if (this.masterVuValues[1] == (scaledVu = this.scaleVU(vu = masterTrack.getVuRight()))) continue;
            this.masterVuValues[1] = scaledVu;
            this.sendVUValue(output, 1, scaledVu, false, true);
        }
    }

    private int scaleVU(int vu) {
        int range = ((MCUConfiguration)this.configuration).getVuMeterStyle() == MCUConfiguration.VUMeterStyle.MACKIE ? 12 : 13;
        return (int)Math.round(this.valueChanger.toNormalizedValue(vu) * (double)range);
    }

    private void sendVUValue(IMidiOutput output, int track, int scaledVu, boolean vuClipState, boolean isMasterOrRightChannel) {
        output.sendChannelAftertouch(isMasterOrRightChannel ? 1 : 0, 16 * track + scaledVu, 0);
        if (((MCUConfiguration)this.configuration).getVuMeterStyle() != MCUConfiguration.VUMeterStyle.ICON) {
            output.sendChannelAftertouch(isMasterOrRightChannel ? 1 : 0, 16 * track + (vuClipState ? 14 : 15), 0);
        }
    }

    private void updateFaders(boolean isShiftPressed) {
        if (!((MCUConfiguration)this.configuration).hasMotorFaders()) {
            return;
        }
        Modes activeMode = (Modes)((Object)((MCUControlSurface)this.getSurface()).getModeManager().getActiveID());
        Modes modeId = ((MCUConfiguration)this.configuration).useFadersAsKnobs() && VALUE_MODES.contains((Object)activeMode) ? activeMode : (Modes.isLayerMode(activeMode) ? Modes.DEVICE_LAYER_VOLUME : Modes.VOLUME);
        for (int index = 0; index < this.numMCUDevices; ++index) {
            int volume;
            int value;
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            IMode mode = (IMode)surface.getModeManager().get(modeId);
            IMidiOutput output = surface.getMidiOutput();
            for (int channel = 0; channel < 8; ++channel) {
                int position;
                if (mode.isKnobTouched(channel) || (value = Math.max(0, mode.getKnobValue(channel))) == this.faderValues[position = surface.getExtenderOffset() + channel]) continue;
                this.faderValues[position] = value;
                output.sendPitchbend(channel, value % 127, value / 127);
            }
            if (((MCUConfiguration)this.configuration).getDeviceType(index) != MCUDeviceType.MAIN) continue;
            if (this.masterVolumeMode.isControlLastParamActive()) {
                IFocusedParameter focusedParameter = this.model.getFocusedParameter().get();
                int n = value = focusedParameter.doesExist() ? focusedParameter.getValue() : 0;
                if (value == this.masterFaderValue) continue;
                this.masterFaderValue = value;
                output.sendPitchbend(8, value % 127, value / 127);
                continue;
            }
            int n = volume = isShiftPressed ? this.model.getTransport().getMetronomeVolume() : this.model.getMasterTrack().getVolume();
            if (volume == this.masterFaderValue) continue;
            this.masterFaderValue = volume;
            output.sendPitchbend(8, volume % 127, volume / 127);
        }
    }

    private void updateMode(Modes mode) {
        if (mode == null || !((MCUConfiguration)this.configuration).hasAssignmentDisplay()) {
            return;
        }
        for (int index = 0; index < this.numMCUDevices; ++index) {
            if (((MCUConfiguration)this.configuration).getDeviceType(index) != MCUDeviceType.MAIN) continue;
            ((MCUControlSurface)this.getSurface(index)).getTextDisplay(3).setRow(0, MODE_ACRONYMS.get((Object)mode)).allDone();
        }
    }

    private void handleSoloDefeat(MCUControlSurface surface, IProject project) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (surface.isShiftPressed()) {
            project.clearMute();
            if (cursorDevice.hasDrumPads()) {
                cursorDevice.getDrumPadBank().clearMute();
            }
            return;
        }
        project.clearSolo();
        if (cursorDevice.hasDrumPads()) {
            cursorDevice.getDrumPadBank().clearSolo();
        }
    }

    private boolean getSoloState(MCUControlSurface surface, IProject project) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (surface.isShiftPressed()) {
            return project.hasMute() || cursorDevice.hasDrumPads() && cursorDevice.getDrumPadBank().hasMutedPads();
        }
        return project.hasSolo() || cursorDevice.hasDrumPads() && cursorDevice.getDrumPadBank().hasSoloedPads();
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.NOTE;
    }

    private boolean isFlipped() {
        if (((MCUControlSurface)this.getSurface()).isShiftPressed()) {
            return this.model.isEffectTrackBankActive();
        }
        return ((MCUConfiguration)this.configuration).useFadersAsKnobs();
    }

    static {
        MODE_ACRONYMS.put(Modes.TRACK, "TR");
        MODE_ACRONYMS.put(Modes.VOLUME, "VL");
        MODE_ACRONYMS.put(Modes.PAN, "PN");
        MODE_ACRONYMS.put(Modes.SEND1, "S1");
        MODE_ACRONYMS.put(Modes.SEND2, "S2");
        MODE_ACRONYMS.put(Modes.SEND3, "S3");
        MODE_ACRONYMS.put(Modes.SEND4, "S4");
        MODE_ACRONYMS.put(Modes.SEND5, "S5");
        MODE_ACRONYMS.put(Modes.SEND6, "S6");
        MODE_ACRONYMS.put(Modes.SEND7, "S7");
        MODE_ACRONYMS.put(Modes.SEND8, "S8");
        MODE_ACRONYMS.put(Modes.MASTER, "MT");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER, "LA");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_VOLUME, "LV");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_PAN, "LP");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND1, "L1");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND2, "L2");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND3, "L3");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND4, "L4");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND5, "L5");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND6, "L6");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND7, "L7");
        MODE_ACRONYMS.put(Modes.DEVICE_LAYER_SEND8, "L8");
        MODE_ACRONYMS.put(Modes.DEVICE_PARAMS, "DC");
        MODE_ACRONYMS.put(Modes.BROWSER, "BR");
        MODE_ACRONYMS.put(Modes.MARKERS, "MK");
        MODE_ACRONYMS.put(Modes.EQ_DEVICE_PARAMS, "EQ");
        MODE_ACRONYMS.put(Modes.INSTRUMENT_DEVICE_PARAMS, "IT");
        MODE_ACRONYMS.put(Modes.USER, "US");
        VALUE_MODES = EnumSet.of(Modes.VOLUME, new Modes[]{Modes.PAN, Modes.TRACK, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6, Modes.SEND7, Modes.SEND8, Modes.DEVICE_PARAMS, Modes.EQ_DEVICE_PARAMS, Modes.INSTRUMENT_DEVICE_PARAMS, Modes.USER});
    }
}

