/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisProjectTrackParameterMode;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ExquisProjectTrackParameterModeSelectCommand
extends ModeSelectCommand<ExquisControlSurface, ExquisConfiguration> {
    private final boolean triggerProject;

    public ExquisProjectTrackParameterModeSelectCommand(IModel model, ExquisControlSurface surface, boolean triggerProject) {
        super(model, surface, Modes.PROJECT);
        this.notify = false;
        this.triggerProject = triggerProject;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ExquisProjectTrackParameterMode mode = (ExquisProjectTrackParameterMode)this.modeManager.get(Modes.PROJECT);
        boolean isAlreadyActive = this.modeManager.isActive(new Modes[]{Modes.PROJECT});
        if (!isAlreadyActive) {
            super.executeNormal(event);
        }
        boolean areProjectParametersActive = mode.areProjectParametersActive();
        if (this.triggerProject && !areProjectParametersActive || !this.triggerProject && areProjectParametersActive) {
            isAlreadyActive = false;
            mode.toggleMode();
        }
        if (isAlreadyActive) {
            mode.toggleParameters();
        }
        String message = (mode.areProjectParametersActive() ? "Project Parameters " : "Track Parameters ") + (mode.are1To4Bound() ? "1 - 4" : "5 - 8");
        ((ExquisControlSurface)this.surface).getDisplay().notify(message);
    }
}

