/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class MixerMode
extends AbstractElectraOneMode {
    private static final int FIRST_TRACK_GROUP = 501;
    private final ITransport transport;
    private final IMasterTrack masterTrack;

    public MixerMode(ElectraOneControlSurface surface, IModel model) {
        super(0, "Volume", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        this.setParameterProvider(new CombinedParameterProvider(new VolumeParameterProvider(model), new FixedParameterProvider(this.masterTrack.getVolumeParameter()), new PanParameterProvider(model), new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), new EmptyParameterProvider(24)));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (column == 5) {
            switch (row) {
                case 2: {
                    this.model.getCurrentTrackBank().selectNextPage();
                    break;
                }
                case 3: {
                    this.model.getCurrentTrackBank().selectPreviousPage();
                    break;
                }
                case 4: {
                    this.transport.startRecording();
                    break;
                }
                case 5: {
                    this.playCommand.execute(ButtonEvent.UP, 127);
                    break;
                }
            }
            return;
        }
        Optional<ITrack> trackOpt = this.getTrack(column);
        if (trackOpt.isEmpty()) {
            return;
        }
        ITrack track = trackOpt.get();
        switch (row) {
            case 2: {
                track.toggleRecArm();
                break;
            }
            case 3: {
                track.toggleMute();
                break;
            }
            case 4: {
                track.toggleSolo();
                break;
            }
            case 5: {
                track.select();
                break;
            }
        }
    }

    @Override
    public void updateDisplay() {
        for (int column = 0; column < 5; ++column) {
            Optional<ITrack> trackOpt = this.getTrack(column);
            ITrack track = trackOpt.isPresent() ? trackOpt.get() : EmptyTrack.getInstance(((ITrack)this.model.getTrackBank().getItem(0)).getSendBank().getPageSize());
            boolean trackExists = track.doesExist();
            Boolean exists = trackExists;
            String trackLabel = trackExists ? track.getPosition() + 1 + ": " + track.getName() : "";
            this.pageCache.updateGroupLabel(501 + column, trackLabel);
            this.pageCache.updateValue(0, column, track.getVolume(), trackExists ? StringUtils.optimizeName(StringUtils.fixASCII(track.getVolumeStr()), 15) : " ");
            this.pageCache.updateValue(1, column, track.getPan(), StringUtils.optimizeName(StringUtils.fixASCII(track.getPanStr()), 15));
            ColorEx color = track.getColor();
            this.pageCache.updateElement(0, column, trackExists ? "VOLUME" : " ", color, exists);
            this.pageCache.updateElement(1, column, trackExists ? "PAN" : " ", color, exists);
            this.pageCache.updateElement(2, column, trackExists ? "REC ARM" : " ", track.isRecArm() ? ElectraOneColorManager.REC_ARM_ON : ElectraOneColorManager.REC_ARM_OFF, exists);
            this.pageCache.updateElement(3, column, trackExists ? "MUTE" : " ", track.isMute() ? ElectraOneColorManager.MUTE_ON : ElectraOneColorManager.MUTE_OFF, exists);
            this.pageCache.updateElement(4, column, trackExists ? "SOLO" : " ", track.isSolo() ? ElectraOneColorManager.SOLO_ON : ElectraOneColorManager.SOLO_OFF, exists);
            this.pageCache.updateElement(5, column, trackExists ? "SELECT" : " ", track.isSelected() ? ElectraOneColorManager.SELECT_ON : ElectraOneColorManager.SELECT_OFF, exists);
        }
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }
}

