/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.PlayView;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.PianoViewHelper;

public class PianoView
extends PlayView {
    public PianoView(FireControlSurface surface, IModel model) {
        super("Piano", surface, model);
    }

    @Override
    public void drawGrid() {
        PianoViewHelper.drawGrid(((FireControlSurface)this.surface).getPadGrid(), this.model, this.keyManager, 4, 16);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.decPianoOctave();
        this.updateNoteMapping();
        ((FireControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.incPianoOctave();
        this.updateNoteMapping();
        ((FireControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() ? this.scales.getPianoMatrix(4, 16) : EMPTY_TABLE);
    }

    @Override
    public void onSelectKnobValue(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.scales.incPianoOctave();
        } else {
            this.scales.decPianoOctave();
        }
        this.mvHelper.delayDisplay(this.scales::getPianoRangeText);
        this.updateNoteMapping();
    }
}

