/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import de.mossgrabers.framework.mode.device.ProjectParamsMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import java.util.Optional;

public class FireUserMode
extends ProjectParamsMode<FireControlSurface, FireConfiguration> {
    public FireUserMode(FireControlSurface surface, IModel model) {
        super(surface, model, false, ContinuousID.createSequentialList(ContinuousID.KNOB1, 4), surface::isShiftPressed, false);
        this.notifyPageChange = false;
        this.isAlternativeFunction = () -> false;
        this.projectParameterProvider = new FourKnobProvider(surface, new BankParameterProvider(model.getProject().getParameterBank()), ButtonID.ALT);
        this.trackParameterProvider = new FourKnobProvider(surface, new BankParameterProvider(model.getCursorTrack().getParameterBank()), ButtonID.ALT);
        this.setParameterProvider(this.projectParameterProvider);
    }

    @Override
    public void updateDisplay() {
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        IParameterPageBank pageBank = ((IParameterBank)this.bank).getPageBank();
        Optional selectedPage = pageBank.getSelectedItem();
        String desc = selectedPage.isPresent() ? (String)selectedPage.get() : "None";
        Object paramLine = "";
        int value = -1;
        int touchedKnob = this.getTouchedKnob();
        int n = touchedKnob = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) && touchedKnob > -1 ? 4 + touchedKnob : touchedKnob;
        if (touchedKnob > -1) {
            IParameter p = (IParameter)this.bank.getItem(touchedKnob);
            paramLine = p.getName(5);
            if (((String)paramLine).isEmpty()) {
                paramLine = "Not mapped";
            } else {
                value = p.getValue();
                paramLine = (String)paramLine + ": " + p.getDisplayedValue(6);
            }
        } else {
            paramLine = this.isProjectMode ? "Project" : "Track";
        }
        display.addElement(new TitleValueComponent(desc, (String)paramLine, value, false));
        display.send();
    }
}

