/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushUsbDisplay;
import de.mossgrabers.framework.controller.display.AbstractGraphicDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.graphics.DefaultGraphicsDimensions;
import de.mossgrabers.framework.graphics.IBitmap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Push2Display
extends AbstractGraphicDisplay {
    private final PushUsbDisplay usbDisplay;
    private boolean isShutdown = false;

    public Push2Display(IHost host, int maxParameterValue, PushConfiguration configuration) {
        super(host, configuration, new DefaultGraphicsDimensions(960, 160, maxParameterValue), "Push 2 Display");
        this.usbDisplay = new PushUsbDisplay(host);
    }

    @Override
    public void notify(String message) {
        if (message == null) {
            return;
        }
        this.host.showNotification(message);
        this.setNotificationMessage(message);
    }

    @Override
    public void shutdown() {
        this.setMessage(3, "Please start " + this.host.getName() + " to play...");
        this.send();
        this.isShutdown = true;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            if (this.usbDisplay != null) {
                this.usbDisplay.shutdown();
            }
            super.shutdown();
        });
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            this.host.error("Display shutdown interrupted.", ex);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void send(IBitmap image) {
        if (!this.isShutdown && this.usbDisplay != null) {
            this.usbDisplay.send(image);
        }
    }
}

