/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.continuous;

import de.mossgrabers.controller.ableton.push.command.continuous.IPush3Encoder;
import de.mossgrabers.controller.ableton.push.command.trigger.PlayPositionKnobCommand;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class Push3EncoderCommand
extends PlayPositionKnobCommand {
    public Push3EncoderCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof IPush3Encoder) {
            IPush3Encoder encoderMode = (IPush3Encoder)((Object)activeMode);
            encoderMode.encoderTurn(value);
            return;
        }
        super.execute(value);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof IPush3Encoder) {
            IPush3Encoder encoderMode = (IPush3Encoder)((Object)activeMode);
            encoderMode.encoderPress(event);
            return;
        }
        if (event == ButtonEvent.DOWN) {
            this.transport.play();
        }
    }

    public void left(ButtonEvent event) {
        double pos;
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof IPush3Encoder) {
            IPush3Encoder encoderMode = (IPush3Encoder)((Object)activeMode);
            encoderMode.encoderLeft(event);
            return;
        }
        if (event != ButtonEvent.DOWN) {
            return;
        }
        double position = this.transport.getPosition();
        if (position > (pos = this.transport.getLoopEnd())) {
            this.transport.selectLoopEnd();
        } else {
            pos = this.transport.getLoopStart();
            if (position > pos) {
                this.transport.selectLoopStart();
            } else {
                this.transport.setPosition(0.0);
            }
        }
        this.displayPosition();
    }

    public void right(ButtonEvent event) {
        double pos;
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof IPush3Encoder) {
            IPush3Encoder encoderMode = (IPush3Encoder)((Object)activeMode);
            encoderMode.encoderRight(event);
            return;
        }
        if (event != ButtonEvent.DOWN) {
            return;
        }
        double position = this.transport.getPosition();
        if (position < (pos = this.transport.getLoopStart())) {
            this.transport.selectLoopStart();
        } else {
            pos = this.transport.getLoopEnd();
            if (position < pos) {
                this.transport.selectLoopEnd();
            } else {
                this.transport.setPositionToEnd();
            }
        }
        this.displayPosition();
    }

    public void center(ButtonEvent event) {
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof IPush3Encoder) {
            IPush3Encoder encoderMode = (IPush3Encoder)((Object)activeMode);
            encoderMode.arrowCenter(event);
            return;
        }
        Optional selectedScene = this.model.getSceneBank().getSelectedItem();
        if (selectedScene.isPresent()) {
            ((IScene)selectedScene.get()).launch(event == ButtonEvent.DOWN, true);
        }
    }
}

