/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.transport;

import com.illposed.osc.MessageSelector;
import com.illposed.osc.OSCMessageListener;
import com.illposed.osc.OSCPacketDispatcher;
import com.illposed.osc.OSCPacketListener;
import com.illposed.osc.OSCSerializerAndParserBuilder;
import com.illposed.osc.transport.NetworkProtocol;
import com.illposed.osc.transport.OSCPort;
import com.illposed.osc.transport.OSCPortIn;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public class OSCPortInBuilder {
    private OSCSerializerAndParserBuilder parserBuilder;
    private List<OSCPacketListener> packetListeners;
    private SocketAddress local;
    private SocketAddress remote;
    private NetworkProtocol networkProtocol = NetworkProtocol.UDP;

    private OSCPacketListener addDefaultPacketListener() {
        if (this.packetListeners == null) {
            this.packetListeners = new ArrayList<OSCPacketListener>();
        }
        OSCPacketListener listener = OSCPortIn.defaultPacketListener();
        this.packetListeners.add(listener);
        return listener;
    }

    public OSCPortIn build() throws IOException {
        if (this.local == null) {
            throw new IllegalArgumentException("Missing local socket address / port.");
        }
        if (this.remote == null) {
            this.remote = new InetSocketAddress(OSCPort.generateWildcard(this.local), 0);
        }
        if (this.parserBuilder == null) {
            this.parserBuilder = new OSCSerializerAndParserBuilder();
        }
        if (this.packetListeners == null) {
            this.addDefaultPacketListener();
        }
        return new OSCPortIn(this.parserBuilder, this.packetListeners, this.local, this.remote, this.networkProtocol);
    }

    public OSCPortInBuilder setPort(int port) {
        InetSocketAddress address = new InetSocketAddress(port);
        this.local = address;
        this.remote = address;
        return this;
    }

    public OSCPortInBuilder setLocalPort(int port) {
        this.local = new InetSocketAddress(port);
        return this;
    }

    public OSCPortInBuilder setRemotePort(int port) {
        this.remote = new InetSocketAddress(port);
        return this;
    }

    public OSCPortInBuilder setSocketAddress(SocketAddress address) {
        this.local = address;
        this.remote = address;
        return this;
    }

    public OSCPortInBuilder setLocalSocketAddress(SocketAddress address) {
        this.local = address;
        return this;
    }

    public OSCPortInBuilder setRemoteSocketAddress(SocketAddress address) {
        this.remote = address;
        return this;
    }

    public OSCPortInBuilder setNetworkProtocol(NetworkProtocol protocol) {
        this.networkProtocol = protocol;
        return this;
    }

    public OSCPortInBuilder setPacketListeners(List<OSCPacketListener> listeners) {
        this.packetListeners = listeners;
        return this;
    }

    public OSCPortInBuilder setPacketListener(OSCPacketListener listener) {
        this.packetListeners = new ArrayList<OSCPacketListener>();
        this.packetListeners.add(listener);
        return this;
    }

    public OSCPortInBuilder addPacketListener(OSCPacketListener listener) {
        if (this.packetListeners == null) {
            this.packetListeners = new ArrayList<OSCPacketListener>();
        }
        this.packetListeners.add(listener);
        return this;
    }

    public OSCPortInBuilder addMessageListener(MessageSelector selector, OSCMessageListener listener) {
        OSCPacketDispatcher dispatcher = OSCPortIn.getDispatcher(this.packetListeners);
        if (dispatcher == null) {
            dispatcher = (OSCPacketDispatcher)this.addDefaultPacketListener();
        }
        dispatcher.addListener(selector, listener);
        return this;
    }
}

