/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument;

import java.io.Serializable;

public final class OSCUnsigned
implements Cloneable,
Serializable,
Comparable<OSCUnsigned> {
    public static final int BYTES = 4;
    public static final OSCUnsigned MIN_VALUE = new OSCUnsigned(0L);
    public static final OSCUnsigned MAX_VALUE = new OSCUnsigned(0xFFFFFFFFL);
    private static final long serialVersionUID = 1L;
    private final long value;

    private OSCUnsigned(long value) {
        this.value = value;
    }

    public boolean equals(Object other) {
        return other instanceof OSCUnsigned && this.toLong() == ((OSCUnsigned)other).toLong();
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(this.value ^ this.value >>> 32);
        return hash;
    }

    @Override
    public int compareTo(OSCUnsigned other) {
        return (int)(this.toLong() - other.toLong());
    }

    public OSCUnsigned clone() throws CloneNotSupportedException {
        return (OSCUnsigned)super.clone();
    }

    public long toLong() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OSCUnsigned valueOf(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("We need exactly 4 bytes");
        }
        long value = ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
        return OSCUnsigned.valueOf(value);
    }

    public static OSCUnsigned valueOf(long value) {
        if (value < OSCUnsigned.MIN_VALUE.value || value > OSCUnsigned.MAX_VALUE.value) {
            throw new IllegalArgumentException("Value " + value + " lies not within 32bit unsigned integer range (" + OSCUnsigned.MIN_VALUE.value + " - " + OSCUnsigned.MAX_VALUE.value + ").");
        }
        return new OSCUnsigned(value);
    }
}

