/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.track;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AddTrackCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final ButtonID combi1;
    private final ButtonID combi2;

    public AddTrackCommand(IModel model, S surface) {
        this(model, surface, ButtonID.SHIFT, ButtonID.SELECT);
    }

    public AddTrackCommand(IModel model, S surface, ButtonID combi1, ButtonID combi2) {
        super(model, surface);
        this.combi1 = combi1;
        this.combi2 = combi2;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getTrackBank();
        IApplication application = this.model.getApplication();
        if (this.combi1 != null && this.surface.isPressed(this.combi1)) {
            application.addEffectTrack();
            tb = this.model.getEffectTrackBank();
            if (tb == null) {
                return;
            }
        } else if (this.combi2 != null && this.surface.isPressed(this.combi2)) {
            this.model.getTrackBank().addChannel(ChannelType.AUDIO);
        } else {
            this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
        }
        ITrackBank bank = tb;
        this.surface.scheduleTask(() -> {
            int pos = bank.getItemCount() - 1;
            if (pos < 0) {
                this.surface.errorln("Warning: No track created.");
                return;
            }
            bank.scrollTo(pos);
            ((ITrack)bank.getItem(pos % bank.getPageSize())).select();
        }, 200L);
    }
}

