/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.LinkedList;
import java.util.Optional;

public class ProjectModule
extends AbstractModule {
    public ProjectModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"project"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"project".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String subCommand = ProjectModule.getSubCommand(path);
        IProject project = this.model.getProject();
        switch (subCommand) {
            case "+": {
                project.next();
                break;
            }
            case "-": {
                project.previous();
                break;
            }
            case "engine": {
                IApplication application = this.model.getApplication();
                if (value == null) {
                    application.toggleEngineActive();
                    break;
                }
                application.setEngineActive(ProjectModule.isTrigger(value));
                break;
            }
            case "save": {
                project.save();
                break;
            }
            case "param": {
                this.parseParamValue(path, value);
                break;
            }
            case "page": {
                this.parsePageValue(path, value);
                break;
            }
            default: {
                throw new UnknownCommandException(subCommand);
            }
        }
    }

    private void parseParamValue(LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        IParameterBank parameterBank = this.model.getProject().getParameterBank();
        String subCommand = ProjectModule.getSubCommand(path);
        try {
            int paramNo = Integer.parseInt(subCommand) - 1;
            ProjectModule.parseFXParamValue((IParameter)parameterBank.getItem(paramNo), path, value);
        }
        catch (NumberFormatException ex) {
            switch (subCommand) {
                case "+": {
                    if (!ProjectModule.isTrigger(value)) break;
                    parameterBank.selectNextItem();
                    break;
                }
                case "-": {
                    if (!ProjectModule.isTrigger(value)) break;
                    parameterBank.selectPreviousItem();
                    break;
                }
                case "bank": {
                    String subCommand2 = ProjectModule.getSubCommand(path);
                    if ("page".equals(subCommand2)) {
                        IParameterPageBank pageBank = parameterBank.getPageBank();
                        String directionCommand = ProjectModule.getSubCommand(path);
                        if ("+".equals(directionCommand)) {
                            pageBank.selectNextPage();
                            break;
                        }
                        pageBank.selectPreviousPage();
                        break;
                    }
                    throw new UnknownCommandException(subCommand2);
                }
                default: {
                    throw new UnknownCommandException(subCommand);
                }
            }
        }
    }

    private void parsePageValue(LinkedList<String> path, Object value) throws UnknownCommandException, MissingCommandException, IllegalParameterException {
        IParameterBank parameterBank = this.model.getProject().getParameterBank();
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        String subCommand = ProjectModule.getSubCommand(path);
        if ("select".equals(subCommand) || "selected".equals(subCommand)) {
            parameterPageBank.selectPage(ProjectModule.toInteger(value) - 1);
        } else {
            try {
                int index = Integer.parseInt(subCommand) - 1;
                parameterPageBank.selectPage(index);
            }
            catch (NumberFormatException ex2) {
                throw new UnknownCommandException(subCommand);
            }
        }
    }

    private static void parseFXParamValue(IParameter param, LinkedList<String> path, Object value) throws MissingCommandException, IllegalParameterException, UnknownCommandException {
        String command;
        switch (command = ProjectModule.getSubCommand(path)) {
            case "value": {
                param.setValue(ProjectModule.toInteger(value));
                break;
            }
            case "indicate": {
                param.setIndication(ProjectModule.isTrigger(value));
                break;
            }
            case "reset": {
                param.resetValue();
                break;
            }
            case "touched": {
                param.touchValue(ProjectModule.isTrigger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        this.writer.sendOSC("/project/name", this.model.getProject().getName(), dump);
        this.writer.sendOSC("/project/engine", this.model.getApplication().isEngineActive(), dump);
        String paramAddress = "/project/param/";
        IParameterBank parameterBank = this.model.getProject().getParameterBank();
        for (int i = 0; i < parameterBank.getPageSize(); ++i) {
            int oneplus = i + 1;
            this.flushParameterData(this.writer, "/project/param/" + oneplus + "/", (IParameter)parameterBank.getItem(i), dump);
        }
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        int selectedParameterPage = parameterPageBank.getSelectedItemIndex();
        for (int i = 0; i < parameterPageBank.getPageSize(); ++i) {
            int oneplus = i + 1;
            String pageName = (String)parameterPageBank.getItem(i);
            String pageAddress = "/project/page/" + oneplus + "/";
            this.writer.sendOSC(pageAddress + "exists", !pageName.isBlank(), dump);
            this.writer.sendOSC(pageAddress, pageName, dump);
            this.writer.sendOSC(pageAddress + "name", pageName, dump);
            this.writer.sendOSC(pageAddress + "selected", selectedParameterPage == i, dump);
        }
        Optional selectedItem = parameterPageBank.getSelectedItem();
        this.writer.sendOSC("/project/page/selected/name", selectedItem.isPresent() ? (String)selectedItem.get() : "", dump);
    }
}

