/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;

public class ActionModule
extends AbstractModule {
    private final OSCConfiguration configuration;

    public ActionModule(IHost host, IModel model, IOpenSoundControlWriter writer, OSCConfiguration configuration) {
        super(host, model, writer);
        this.configuration = configuration;
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"action"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"action".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String subCommand = ActionModule.getSubCommand(path);
        try {
            int actionNo = Math.min(19, Math.max(0, Integer.parseInt(subCommand) - 1));
            String assignableActionID = this.configuration.getAssignableAction(actionNo);
            if (assignableActionID != null) {
                this.model.getApplication().invokeAction(assignableActionID);
            }
        }
        catch (NumberFormatException ex) {
            throw new UnknownCommandException(subCommand);
        }
    }
}

