/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.device.ProjectParamsMode;
import de.mossgrabers.framework.parameter.IParameter;

public class MaschineJamUserMode
extends ProjectParamsMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(0, 0, 0);

    public MaschineJamUserMode(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    @Override
    public void selectPreviousItemPage() {
        super.selectPreviousItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public void selectNextItemPage() {
        super.selectNextItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public FaderConfig setupFader(int index) {
        IParameter parameter = (IParameter)this.bank.getItem(index);
        if (!parameter.doesExist()) {
            return FADER_OFF;
        }
        int value = this.model.getValueChanger().toMidiValue(parameter.getValue());
        return new FaderConfig(0, this.isProjectMode ? 78 : 14, value);
    }
}

