/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.TrackType;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.mode.layer.DefaultLayerMode;
import de.mossgrabers.framework.parameterprovider.device.PanLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.VolumeLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.List;
import java.util.Optional;

public class LayerMode
extends DefaultLayerMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    public LayerMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Layer", surface, model, false);
        this.setControls(controls);
        ISpecificDevice specificDevice = this.getDevice();
        this.setParameterProvider(new CombinedParameterProvider(new VolumeLayerOrDrumPadParameterProvider(specificDevice), new PanLayerOrDrumPadParameterProvider(specificDevice)));
    }

    @Override
    public int getKnobValue(int index) {
        IValueChanger valueChanger = this.model.getValueChanger();
        if (index >= 80 && index < 88) {
            ILayer layer = (ILayer)this.bank.getItem(index - 80);
            return valueChanger.toMidiValue(layer.getVolume());
        }
        if (index >= 88 && index < 96) {
            ILayer layer = (ILayer)this.bank.getItem(index - 88);
            return valueChanger.toMidiValue(layer.getPan());
        }
        int scrollLayersState = (this.bank.canScrollBackwards() ? 1 : 0) + (this.bank.canScrollForwards() ? 2 : 0);
        boolean scrollClipsState = false;
        ISceneBank sceneBank = this.model.getSceneBank();
        int scrollScenesState = (sceneBank.canScrollBackwards() ? 1 : 0) + (sceneBank.canScrollForwards() ? 2 : 0);
        KontrolProtocolConfiguration configuration = (KontrolProtocolConfiguration)((KontrolProtocolControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 49: {
                return (this.bank.canScrollPageBackwards() ? 1 : 0) + (this.bank.canScrollPageForwards() ? 2 : 0);
            }
            case 48: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return configuration.isFlipClipSceneNavigation() ? scrollScenesState : 0;
                }
                return scrollLayersState;
            }
            case 50: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return scrollLayersState;
                }
                return configuration.isFlipClipSceneNavigation() ? scrollScenesState : 0;
            }
        }
        return 0;
    }

    public void toggleMute(int index) {
        ILayer layer = (ILayer)this.bank.getItem(index);
        if (layer.doesExist()) {
            layer.toggleMute();
        }
    }

    public void toggleSolo(int index) {
        ILayer layer = (ILayer)this.bank.getItem(index);
        if (layer.doesExist()) {
            layer.toggleSolo();
        }
    }

    @Override
    public void updateDisplay() {
        ((KontrolProtocolControlSurface)this.surface).sendGlobalValues(this.model);
        IValueChanger valueChanger = this.model.getValueChanger();
        int protocolVersion = ((KontrolProtocolControlSurface)this.surface).getProtocolVersion();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        int[] vuData = new int[16];
        for (int i = 0; i < 8; ++i) {
            ILayer layer = (ILayer)this.bank.getItem(i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, TrackType.toTrackType(layer.getType()), i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, layer.isSelected() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(69, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(70, 0, i, layer.getVolumeStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(71, 0, i, layer.getPanStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, this.formatLayerName(cursorDevice, layer));
            if (protocolVersion == 4) {
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(75, 0, i, "#" + StringUtils.formatColor(layer.getColor()));
            }
            int j = 2 * i;
            vuData[j] = valueChanger.toMidiValue(layer.getVuLeft());
            vuData[j + 1] = valueChanger.toMidiValue(layer.getVuRight());
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(67, layer.isMute() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(68, layer.isSolo() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(74, 0, i);
            Optional selectedLayer = this.bank.getSelectedItem();
            ((KontrolProtocolControlSurface)this.surface).sendCommand(104, selectedLayer.isPresent() ? TrackType.toTrackType(((ILayer)selectedLayer.get()).getType()) : 0);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(105, 0);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(73, 2, 0, vuData);
    }

    @Override
    public void parametersAdjusted() {
        this.switchBanks(this.firstInstrument.getLayerBank());
        this.bindControls();
    }

    private String formatLayerName(ICursorDevice cursorDevice, ILayer layer) {
        if (!cursorDevice.doesExist() || !layer.doesExist()) {
            return "";
        }
        String name = layer.getName();
        switch (((KontrolProtocolControlSurface)this.surface).getProtocolVersion()) {
            case 1: {
                return name;
            }
            case 2: {
                return "Layer " + (layer.getPosition() + 1) + "\n" + name;
            }
        }
        return layer.getPosition() + 1 + ": " + name;
    }

    private final ISpecificDevice getDevice() {
        return this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
    }

    @Override
    protected void executeMethod(ILayer layer) {
    }
}

