/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ISlot;
import java.util.Optional;

public class ClipHandler
extends AbstractHandler {
    private final NewCommand<GenericFlexiControlSurface, GenericFlexiConfiguration> newCommand;

    public ClipHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.newCommand = new NewCommand(this.model, this.surface);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.CLIP_TOGGLE_PIN, FlexiCommand.CLIP_PREVIOUS, FlexiCommand.CLIP_NEXT, FlexiCommand.CLIP_SCROLL, FlexiCommand.CLIP_PLAY, FlexiCommand.CLIP_PLAY_ALT, FlexiCommand.CLIP_STOP, FlexiCommand.CLIP_STOP_ALT, FlexiCommand.CLIP_STOP_ALL, FlexiCommand.CLIP_STOP_ALL_ALT, FlexiCommand.CLIP_RECORD, FlexiCommand.CLIP_NEW, FlexiCommand.CLIP_QUANTIZE};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        Optional<ISlot> selectedSlot = this.model.getSelectedSlot();
        switch (command) {
            case CLIP_TOGGLE_PIN: {
                return ClipHandler.toMidiValue(this.model.getCursorClip().isPinned());
            }
            case CLIP_PLAY: 
            case CLIP_PLAY_ALT: {
                return ClipHandler.toMidiValue(selectedSlot.isPresent() && selectedSlot.get().isPlaying());
            }
            case CLIP_STOP: 
            case CLIP_STOP_ALT: {
                return ClipHandler.toMidiValue(selectedSlot.isPresent() && selectedSlot.get().isPlaying());
            }
            case CLIP_STOP_ALL: 
            case CLIP_STOP_ALL_ALT: {
                return ClipHandler.toMidiValue(true);
            }
            case CLIP_RECORD: {
                return ClipHandler.toMidiValue(selectedSlot.isPresent() && selectedSlot.get().isRecording());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case CLIP_TOGGLE_PIN: {
                if (!isButtonPressed) break;
                this.model.getCursorClip().togglePinned();
                break;
            }
            case CLIP_PREVIOUS: {
                if (!isButtonPressed) break;
                this.scrollClipLeft();
                break;
            }
            case CLIP_NEXT: {
                if (!isButtonPressed) break;
                this.scrollClipRight();
                break;
            }
            case CLIP_SCROLL: {
                this.scrollClips(knobMode, value);
                break;
            }
            case CLIP_PLAY: 
            case CLIP_PLAY_ALT: {
                Optional<ISlot> selectedSlot = this.model.getSelectedSlot();
                if (!selectedSlot.isPresent()) break;
                selectedSlot.get().launch(isButtonPressed, command == FlexiCommand.CLIP_PLAY_ALT);
                break;
            }
            case CLIP_STOP: 
            case CLIP_STOP_ALT: {
                if (!isButtonPressed) break;
                this.model.getCursorTrack().stop(command == FlexiCommand.CLIP_STOP_ALT);
                break;
            }
            case CLIP_STOP_ALL: 
            case CLIP_STOP_ALL_ALT: {
                if (!isButtonPressed) break;
                this.model.getTrackBank().stop(command == FlexiCommand.CLIP_STOP_ALL_ALT);
                break;
            }
            case CLIP_RECORD: {
                Optional<ISlot> selectedSlot2;
                if (!isButtonPressed || !(selectedSlot2 = this.model.getSelectedSlot()).isPresent()) break;
                selectedSlot2.get().startRecording();
                break;
            }
            case CLIP_NEW: {
                if (!isButtonPressed) break;
                this.newCommand.execute();
                break;
            }
            case CLIP_QUANTIZE: {
                INoteClip clip;
                if (!isButtonPressed || !(clip = this.model.getCursorClip()).doesExist()) break;
                clip.quantize(1.0);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollClips(KnobMode knobMode, MidiValue value) {
        if (ClipHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        if (this.isIncrease(knobMode, value)) {
            this.scrollClipRight();
        } else {
            this.scrollClipLeft();
        }
    }

    private void scrollClipLeft() {
        this.model.getCursorTrack().getSlotBank().selectPreviousItem();
    }

    private void scrollClipRight() {
        this.model.getCursorTrack().getSlotBank().selectNextItem();
    }
}

