/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.continuous;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MastertrackTouchCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public MastertrackTouchCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        boolean isTouched = event != ButtonEvent.UP;
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
            return;
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        masterTrack.touchVolume(isTouched);
        if (((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            masterTrack.resetVolume();
            return;
        }
        boolean isMasterMode = modeManager.isActive(new Modes[]{Modes.MASTER});
        if (isTouched && isMasterMode) {
            return;
        }
        if (isTouched) {
            modeManager.setTemporary(Modes.MASTER_TEMP);
        } else if (!isMasterMode) {
            modeManager.restore();
        }
    }
}

