/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeviceMetadataImpl
implements IDeviceMetadata {
    private final String name;
    private final String module;
    private final DeviceFileType fileType;
    private DeviceType deviceType;
    private String vendor;
    private final Set<String> categories = new HashSet<String>(1);

    public DeviceMetadataImpl(String name, String module, DeviceType deviceType, DeviceFileType fileType) {
        this.name = name;
        this.module = module;
        this.deviceType = deviceType;
        this.fileType = fileType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullName() {
        return String.format("%s (%s)", this.name, this.fileType.getName());
    }

    public String getDisplayName() {
        return this.name + " (" + this.fileType.getName() + ")";
    }

    public String getCreationName() {
        return this.module;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getModule() {
        return this.module;
    }

    public DeviceFileType getFileType() {
        return this.fileType;
    }

    public void addCategories(Collection<String> categories) {
        this.categories.addAll(categories);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void setCategory(String category) {
        this.categories.clear();
        this.categories.add(category);
    }

    public boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    public boolean isCategorized() {
        return !this.categories.isEmpty();
    }

    public DeviceType getType() {
        return this.deviceType;
    }

    public void setType(DeviceType type) {
        this.deviceType = type;
    }
}

