/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import de.mossgrabers.framework.scale.Scale;

class ChordGrid {
    private final Scale scale;
    private final int[] matrix;

    public ChordGrid(Scale scale, int rows, int cols) {
        int size = cols * rows;
        this.matrix = new int[size];
        this.scale = scale;
        int[] intervals = this.scale.getIntervals();
        int len = intervals.length;
        for (int column = 0; column < cols; ++column) {
            int oct = column / len;
            int note = oct * 12 + intervals[column % len];
            for (int row = 0; row < rows; ++row) {
                int index = row * cols + column;
                this.matrix[index] = note;
            }
        }
    }

    public int[] getMatrix() {
        return this.matrix;
    }
}

