/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.controller;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOnePadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OxiOneControlSurface
extends AbstractControlSurface<OxiOneConfiguration> {
    public static final int KNOB1_VELOCITY = 0;
    public static final int KNOB2_OCTAVE = 1;
    public static final int KNOB3_GATE = 2;
    public static final int KNOB4_MODULATION = 3;
    public static final int BUTTON_ARP = 0;
    public static final int BUTTON_SEQUENCER4 = 1;
    public static final int BUTTON_16_LEFT = 2;
    public static final int BUTTON_END = 3;
    public static final int BUTTON_KEYBOARD = 4;
    public static final int BUTTON_SEQUENCER3 = 5;
    public static final int BUTTON_32_UP = 6;
    public static final int BUTTON_INIT = 7;
    public static final int BUTTON_ARRANGER = 8;
    public static final int BUTTON_SEQUENCER2 = 9;
    public static final int BUTTON_48_DOWN = 10;
    public static final int BUTTON_SAVE = 11;
    public static final int BUTTON_BACK = 12;
    public static final int BUTTON_SEQUENCER1 = 13;
    public static final int BUTTON_64_RIGHT = 14;
    public static final int BUTTON_LOAD = 15;
    public static final int BUTTON_ENCODER1 = 16;
    public static final int BUTTON_SHIFT = 17;
    public static final int BUTTON_MOD = 18;
    public static final int BUTTON_COPY = 19;
    public static final int BUTTON_ENCODER2 = 20;
    public static final int BUTTON_STOP = 21;
    public static final int BUTTON_DIVISION = 22;
    public static final int BUTTON_PASTE = 23;
    public static final int BUTTON_ENCODER3 = 24;
    public static final int BUTTON_PLAY = 25;
    public static final int BUTTON_LFO = 26;
    public static final int BUTTON_UNDO = 27;
    public static final int BUTTON_ENCODER4 = 28;
    public static final int BUTTON_REC = 29;
    public static final int BUTTON_STEP_CHORD = 30;
    public static final int BUTTON_RANDOM = 31;
    public static final int BUTTON_MUTE = 32;
    private static final int LEDS_BACK = 0;
    private static final int LEDS_CONFIG = 1;
    private static final int LEDS_ARRANGER_SHOW = 2;
    private static final int LEDS_ARRANGER_STATE = 3;
    private static final int LEDS_KEYBOARD = 4;
    private static final int LEDS_PREVIEW = 5;
    private static final int LEDS_ARP = 6;
    private static final int LEDS_ARP_HOLD = 7;
    private static final int LEDS_SHIFT = 8;
    private static final int LEDS_STOP = 9;
    private static final int LEDS_SEQ_1 = 10;
    private static final int LEDS_REC = 11;
    private static final int LEDS_PLAY = 12;
    private static final int LEDS_SEQ_3 = 13;
    private static final int LEDS_NUDGE = 14;
    private static final int LEDS_SYNC = 15;
    private static final int LEDS_SEQ_1_SEL = 16;
    private static final int LEDS_SEQ_2 = 17;
    private static final int LEDS_SEQ_2_SEL = 18;
    private static final int LEDS_MUTE = 19;
    private static final int LEDS_LOAD = 20;
    private static final int LEDS_SEQ_4 = 21;
    private static final int LEDS_SEQ_4_SEL = 22;
    private static final int LEDS_SEQ_3_SEL = 23;
    private static final int LEDS_SAVE = 24;
    private static final int LEDS_CLEAR = 25;
    private static final int LEDS_DUPLICATE = 26;
    private static final int LEDS_PASTE = 27;
    private static final int LEDS_COPY = 28;
    private static final int LEDS_UNDO = 29;
    private static final int LEDS_RANDOM = 30;
    private static final int LEDS_REDO = 31;
    private static final int LEDS_RANDOM2 = 32;
    private static final int LEDS_INIT = 33;
    private static final int LEDS_X2 = 34;
    private static final int LEDS_END = 35;
    private static final int LEDS_2 = 36;
    private static final int LEDS_MOD = 37;
    private static final int LEDS_DIVISION = 38;
    private static final int LEDS_FOLLOW = 39;
    private static final int LEDS_LFO = 40;
    private static final int LEDS_CONDENSE = 41;
    private static final int LEDS_CVOUT = 42;
    private static final int LEDS_STEP_CHORD = 43;
    private static final int LEDS_EXPAND = 44;
    private static final int LEDS_16 = 45;
    private static final int LEDS_LEFT = 46;
    private static final int LEDS_32 = 47;
    private static final int LEDS_UP = 48;
    private static final int LEDS_48 = 49;
    private static final int LEDS_RIGHT = 50;
    private static final int LEDS_64 = 51;
    private static final int LEDS_DOWN = 52;
    private static final int LEDS_NO_LED = 53;
    private static final int LEDS_PLAY2 = 54;
    private static final List<Integer> NORMAL_LEDS = new ArrayList<Integer>();
    private static final List<Integer> SHIFTED_LEDS = new ArrayList<Integer>();
    private static final Map<Integer, Integer> BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> SHIFTED_BUTTON_LEDS = new HashMap<Integer, Integer>();
    private static final byte[] ENTER_REMOTE_MODE;
    private static final byte[] EXIT_REMOTE_MODE;
    private static final String ACKNOWLEDGE = "f000215b00010653f7";
    private final boolean[] buttonStates = new boolean[55];
    private final byte[] ledUpdate = new byte[]{-16, 0, 33, 91, 0, 1, 2, 0, 0, 0, 0, -9};

    public OxiOneControlSurface(IHost host, ColorManager colorManager, OxiOneConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, new OxiOnePadGrid(colorManager, output), 290.0, 140.0);
        this.input.setSysexCallback(this::handleSysEx);
    }

    public void enterRemoteMode() {
        this.output.sendSysex(ENTER_REMOTE_MODE);
    }

    public void exitRemoteMode() {
        this.output.sendSysex(EXIT_REMOTE_MODE);
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((OxiOnePadGrid)this.padGrid).flush();
    }

    @Override
    protected void internalShutdown() {
        IGraphicDisplay display = this.getGraphicsDisplay();
        display.addElement(new LabelComponent("Goodbye", null, ColorEx.BLACK, false, false, LabelComponent.LabelLayout.PLAIN));
        display.send();
        this.exitRemoteMode();
        super.internalShutdown();
    }

    @Override
    public OxiOnePadGrid getPadGrid() {
        return (OxiOnePadGrid)this.padGrid;
    }

    @Override
    public boolean isDeletePressed() {
        boolean pressed = this.isPressed(ButtonID.BANK_RIGHT);
        if (pressed) {
            this.setTriggerConsumed(ButtonID.BANK_RIGHT);
        }
        return pressed;
    }

    public void updateFunctionButtonLEDs() {
        boolean isShifted = this.isShiftPressed();
        for (int i = 0; i < this.buttonStates.length; ++i) {
            if (NORMAL_LEDS.contains(i) && this.buttonStates[i]) {
                this.updateLED(i, !isShifted);
                continue;
            }
            if (!SHIFTED_LEDS.contains(i) || !this.buttonStates[i]) continue;
            this.updateLED(i, isShifted);
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        Integer integerCC = cc;
        Integer normalLedCC = BUTTON_LEDS.get(integerCC);
        Integer shiftedLedCC = SHIFTED_BUTTON_LEDS.get(integerCC);
        if (normalLedCC == null) {
            return;
        }
        int intNormalLedCCValue = normalLedCC;
        boolean bl = this.buttonStates[intNormalLedCCValue] = (value & 1) > 0;
        if (shiftedLedCC != null) {
            boolean bl2 = this.buttonStates[shiftedLedCC.intValue()] = (value & 2) > 0;
        }
        if (this.isShiftPressed()) {
            if (shiftedLedCC != null) {
                this.updateLED(shiftedLedCC, this.buttonStates[shiftedLedCC]);
            }
        } else {
            this.updateLED(intNormalLedCCValue, this.buttonStates[intNormalLedCCValue]);
        }
    }

    private void updateLED(int ledID, boolean enabled) {
        this.ledUpdate[7] = (byte)(ledID / 16);
        this.ledUpdate[8] = (byte)(ledID % 16);
        this.ledUpdate[10] = (byte)(enabled ? 1 : 0);
        this.output.sendSysex(this.ledUpdate);
    }

    private void handleSysEx(String data) {
        if (ACKNOWLEDGE.equalsIgnoreCase(data)) {
            this.scheduleTask(this::forceFlush, 3000L);
        }
    }

    static {
        NORMAL_LEDS.add(0);
        NORMAL_LEDS.add(2);
        NORMAL_LEDS.add(4);
        NORMAL_LEDS.add(7);
        NORMAL_LEDS.add(9);
        NORMAL_LEDS.add(10);
        NORMAL_LEDS.add(17);
        NORMAL_LEDS.add(13);
        NORMAL_LEDS.add(21);
        NORMAL_LEDS.add(12);
        NORMAL_LEDS.add(19);
        NORMAL_LEDS.add(27);
        NORMAL_LEDS.add(26);
        NORMAL_LEDS.add(29);
        NORMAL_LEDS.add(30);
        NORMAL_LEDS.add(33);
        NORMAL_LEDS.add(35);
        NORMAL_LEDS.add(37);
        NORMAL_LEDS.add(38);
        NORMAL_LEDS.add(40);
        NORMAL_LEDS.add(43);
        NORMAL_LEDS.add(45);
        NORMAL_LEDS.add(47);
        NORMAL_LEDS.add(49);
        NORMAL_LEDS.add(51);
        SHIFTED_LEDS.add(1);
        SHIFTED_LEDS.add(3);
        SHIFTED_LEDS.add(5);
        SHIFTED_LEDS.add(6);
        SHIFTED_LEDS.add(15);
        SHIFTED_LEDS.add(16);
        SHIFTED_LEDS.add(18);
        SHIFTED_LEDS.add(23);
        SHIFTED_LEDS.add(22);
        SHIFTED_LEDS.add(54);
        SHIFTED_LEDS.add(14);
        SHIFTED_LEDS.add(25);
        SHIFTED_LEDS.add(28);
        SHIFTED_LEDS.add(31);
        SHIFTED_LEDS.add(32);
        SHIFTED_LEDS.add(34);
        SHIFTED_LEDS.add(36);
        SHIFTED_LEDS.add(39);
        SHIFTED_LEDS.add(44);
        SHIFTED_LEDS.add(42);
        SHIFTED_LEDS.add(41);
        SHIFTED_LEDS.add(46);
        SHIFTED_LEDS.add(48);
        SHIFTED_LEDS.add(50);
        SHIFTED_LEDS.add(52);
        BUTTON_LEDS.put(17, 8);
        BUTTON_LEDS.put(12, 0);
        BUTTON_LEDS.put(21, 9);
        BUTTON_LEDS.put(29, 11);
        BUTTON_LEDS.put(25, 12);
        BUTTON_LEDS.put(27, 29);
        BUTTON_LEDS.put(15, 20);
        BUTTON_LEDS.put(11, 24);
        BUTTON_LEDS.put(19, 28);
        BUTTON_LEDS.put(23, 27);
        BUTTON_LEDS.put(2, 45);
        BUTTON_LEDS.put(6, 47);
        BUTTON_LEDS.put(10, 49);
        BUTTON_LEDS.put(14, 51);
        BUTTON_LEDS.put(13, 10);
        BUTTON_LEDS.put(9, 17);
        BUTTON_LEDS.put(5, 13);
        BUTTON_LEDS.put(1, 21);
        BUTTON_LEDS.put(32, 19);
        BUTTON_LEDS.put(8, 2);
        BUTTON_LEDS.put(4, 4);
        BUTTON_LEDS.put(0, 6);
        BUTTON_LEDS.put(18, 37);
        BUTTON_LEDS.put(26, 40);
        BUTTON_LEDS.put(30, 43);
        BUTTON_LEDS.put(22, 38);
        BUTTON_LEDS.put(7, 33);
        BUTTON_LEDS.put(3, 35);
        BUTTON_LEDS.put(31, 30);
        SHIFTED_BUTTON_LEDS.put(17, 8);
        SHIFTED_BUTTON_LEDS.put(21, 15);
        SHIFTED_BUTTON_LEDS.put(29, 53);
        SHIFTED_BUTTON_LEDS.put(25, 54);
        SHIFTED_BUTTON_LEDS.put(27, 31);
        SHIFTED_BUTTON_LEDS.put(19, 26);
        SHIFTED_BUTTON_LEDS.put(2, 46);
        SHIFTED_BUTTON_LEDS.put(6, 48);
        SHIFTED_BUTTON_LEDS.put(10, 52);
        SHIFTED_BUTTON_LEDS.put(14, 50);
        SHIFTED_BUTTON_LEDS.put(13, 16);
        SHIFTED_BUTTON_LEDS.put(9, 18);
        SHIFTED_BUTTON_LEDS.put(5, 23);
        SHIFTED_BUTTON_LEDS.put(1, 22);
        SHIFTED_BUTTON_LEDS.put(32, 14);
        SHIFTED_BUTTON_LEDS.put(4, 5);
        SHIFTED_BUTTON_LEDS.put(0, 7);
        SHIFTED_BUTTON_LEDS.put(31, 32);
        ENTER_REMOTE_MODE = new byte[]{-16, 0, 33, 91, 0, 1, 6, 85, -9};
        EXIT_REMOTE_MODE = new byte[]{-16, 0, 33, 91, 0, 1, 0, -9};
    }
}

