/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;

public class FixedMode
extends AbstractParameterMode<SLControlSurface, SLConfiguration, IItem> {
    private static final String[] CLIP_LENGTHS = new String[]{"1 Beat", "2 Beats", "1 Bar", "2 Bars", "4 Bars", "8 Bars", "16 Bars", "32 Bars"};

    public FixedMode(SLControlSurface surface, IModel model) {
        super("Fixed", surface, model);
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clearRow(0).clearRow(1);
        d.setBlock(0, 0, "New Clip Length:");
        int newClipLength = ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getNewClipLength();
        for (int i = 0; i < 8; ++i) {
            d.setCell(1, i, (newClipLength == i ? ">" : " ") + CLIP_LENGTHS[i]);
        }
        d.done(0).done(1);
    }
}

