/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode.device;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1Display;
import de.mossgrabers.controller.ni.kontrol.mki.mode.AbstractKontrol1Mode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class ParamsMode
extends AbstractKontrol1Mode<IParameter> {
    private static final Set<Character> ILLEGAL_LOWER_CHARS = Set.of(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('g'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'));

    public ParamsMode(Kontrol1ControlSurface surface, IModel model) {
        super("Parameters", surface, model, model.getCursorDevice().getParameterBank());
        this.setParameterProvider(new BankParameterProvider(this.bank));
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        if (this.model.hasSelectedDevice()) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            d.setCell(0, 0, cursorDevice.getName(8).toUpperCase(Locale.US));
            Optional selectedItem = cursorDevice.getParameterBank().getPageBank().getSelectedItem();
            if (selectedItem.isPresent()) {
                d.setCell(1, 0, ((String)selectedItem.get()).toUpperCase(Locale.US));
            }
            for (int i = 0; i < 8; ++i) {
                IParameter p = (IParameter)this.bank.getItem(i);
                String name = StringUtils.shortenAndFixASCII(p.getName(8), 8).toUpperCase(Locale.US);
                if (!name.isEmpty()) {
                    d.setCell(0, 1 + i, name).setCell(1, 1 + i, ParamsMode.checkForUpperCase(StringUtils.shortenAndFixASCII(p.getDisplayedValue(8), 8)));
                }
                d.setBar(1 + i, ((Kontrol1ControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.KNOB1, i)).isTouched() && p.doesExist(), p.getValue());
            }
        } else {
            d.setCell(0, 3, "  PLEASE").setCell(0, 4, "SELECT A").setCell(0, 5, "DEVICE").allDone();
        }
        d.allDone();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        switch (buttonID) {
            case MUTE: {
                return cursorDevice.isEnabled() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON";
            }
            case SOLO: {
                return cursorDevice.isParameterPageSectionVisible() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON";
            }
            case BROWSE: {
                return "BUTTON_STATE_ON";
            }
        }
        return "BUTTON_STATE_OFF";
    }

    @Override
    public void selectPreviousItem() {
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            this.model.getCursorDevice().getParameterBank().getPageBank().scrollBackwards();
        } else {
            this.bank.scrollBackwards();
        }
    }

    @Override
    public void selectNextItem() {
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            this.model.getCursorDevice().getParameterBank().getPageBank().scrollForwards();
        } else {
            this.bank.scrollForwards();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            this.model.getCursorDevice().getDeviceBank().selectPreviousPage();
        } else {
            this.model.getCursorDevice().selectPrevious();
        }
    }

    @Override
    public void selectNextItemPage() {
        if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
            this.model.getCursorDevice().getDeviceBank().selectNextPage();
        } else {
            this.model.getCursorDevice().selectNext();
        }
    }

    @Override
    public void onMainKnobPressed() {
        this.model.getCursorDevice().toggleWindowOpen();
    }

    @Override
    public void onBack() {
        this.model.getCursorDevice().toggleEnabledState();
    }

    @Override
    public void onEnter() {
        this.model.getCursorDevice().toggleParameterPageSectionVisible();
    }

    private static String checkForUpperCase(String displayedValue) {
        for (int i = 0; i < displayedValue.length(); ++i) {
            if (!ILLEGAL_LOWER_CHARS.contains(Character.valueOf(displayedValue.charAt(i)))) continue;
            return displayedValue.toUpperCase(Locale.US);
        }
        return displayedValue;
    }
}

