/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;

public class LayoutHandler
extends AbstractHandler {
    public LayoutHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.LAYOUT_ARRANGER_ZOOM_IN, FlexiCommand.LAYOUT_ARRANGER_ZOOM_OUT, FlexiCommand.LAYOUT_SET_ARRANGE_LAYOUT, FlexiCommand.LAYOUT_SET_MIX_LAYOUT, FlexiCommand.LAYOUT_SET_EDIT_LAYOUT, FlexiCommand.LAYOUT_TOGGLE_NOTE_EDITOR, FlexiCommand.LAYOUT_TOGGLE_AUTOMATION_EDITOR, FlexiCommand.LAYOUT_TOGGLE_DEVICES_PANEL, FlexiCommand.LAYOUT_TOGGLE_MIXER_PANEL, FlexiCommand.LAYOUT_TOGGLE_FULLSCREEN, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_CUE_MARKERS, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_PLAYBACK_FOLLOW, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_TRACK_ROW_HEIGHT, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_CLIP_LAUNCHER_SECTION, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_TIME_LINE, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_IO_SECTION, FlexiCommand.LAYOUT_TOGGLE_ARRANGER_EFFECT_TRACKS, FlexiCommand.LAYOUT_TOGGLE_MIXER_CLIP_LAUNCHER_SECTION, FlexiCommand.LAYOUT_TOGGLE_MIXER_CROSS_FADE_SECTION, FlexiCommand.LAYOUT_TOGGLE_MIXER_DEVICE_SECTION, FlexiCommand.LAYOUT_TOGGLE_MIXER_SENDSSECTION, FlexiCommand.LAYOUT_TOGGLE_MIXER_IO_SECTION, FlexiCommand.LAYOUT_TOGGLE_MIXER_METER_SECTION};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        switch (command) {
            case LAYOUT_ARRANGER_ZOOM_IN: 
            case LAYOUT_ARRANGER_ZOOM_OUT: {
                return 0;
            }
            case LAYOUT_SET_ARRANGE_LAYOUT: {
                return LayoutHandler.toMidiValue(this.model.getApplication().isArrangeLayout());
            }
            case LAYOUT_SET_MIX_LAYOUT: {
                return LayoutHandler.toMidiValue(this.model.getApplication().isMixerLayout());
            }
            case LAYOUT_SET_EDIT_LAYOUT: {
                return LayoutHandler.toMidiValue(this.model.getApplication().isEditLayout());
            }
            case LAYOUT_TOGGLE_ARRANGER_CUE_MARKERS: {
                return LayoutHandler.toMidiValue(this.model.getArranger().areCueMarkersVisible());
            }
            case LAYOUT_TOGGLE_ARRANGER_PLAYBACK_FOLLOW: {
                return LayoutHandler.toMidiValue(this.model.getArranger().isPlaybackFollowEnabled());
            }
            case LAYOUT_TOGGLE_ARRANGER_CLIP_LAUNCHER_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getArranger().isClipLauncherVisible());
            }
            case LAYOUT_TOGGLE_ARRANGER_TIME_LINE: {
                return LayoutHandler.toMidiValue(this.model.getArranger().isTimelineVisible());
            }
            case LAYOUT_TOGGLE_ARRANGER_IO_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getArranger().isIoSectionVisible());
            }
            case LAYOUT_TOGGLE_ARRANGER_EFFECT_TRACKS: {
                return LayoutHandler.toMidiValue(this.model.getArranger().areEffectTracksVisible());
            }
            case LAYOUT_TOGGLE_MIXER_CLIP_LAUNCHER_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isClipLauncherSectionVisible());
            }
            case LAYOUT_TOGGLE_MIXER_CROSS_FADE_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isCrossFadeSectionVisible());
            }
            case LAYOUT_TOGGLE_MIXER_DEVICE_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isDeviceSectionVisible());
            }
            case LAYOUT_TOGGLE_MIXER_SENDSSECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isSendSectionVisible());
            }
            case LAYOUT_TOGGLE_MIXER_IO_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isIoSectionVisible());
            }
            case LAYOUT_TOGGLE_MIXER_METER_SECTION: {
                return LayoutHandler.toMidiValue(this.model.getMixer().isMeterSectionVisible());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case LAYOUT_ARRANGER_ZOOM_IN: {
                if (!isButtonPressed) break;
                this.model.getApplication().zoomIn();
                break;
            }
            case LAYOUT_ARRANGER_ZOOM_OUT: {
                this.model.getApplication().zoomOut();
                break;
            }
            case LAYOUT_SET_ARRANGE_LAYOUT: {
                if (!isButtonPressed) break;
                this.model.getApplication().setPanelLayout("ARRANGE");
                break;
            }
            case LAYOUT_SET_MIX_LAYOUT: {
                if (!isButtonPressed) break;
                this.model.getApplication().setPanelLayout("MIX");
                break;
            }
            case LAYOUT_SET_EDIT_LAYOUT: {
                if (!isButtonPressed) break;
                this.model.getApplication().setPanelLayout("EDIT");
                break;
            }
            case LAYOUT_TOGGLE_NOTE_EDITOR: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleNoteEditor();
                break;
            }
            case LAYOUT_TOGGLE_AUTOMATION_EDITOR: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleAutomationEditor();
                break;
            }
            case LAYOUT_TOGGLE_DEVICES_PANEL: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleDevices();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_PANEL: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleMixer();
                break;
            }
            case LAYOUT_TOGGLE_FULLSCREEN: {
                if (!isButtonPressed) break;
                this.model.getApplication().toggleFullScreen();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_CUE_MARKERS: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleCueMarkerVisibility();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_PLAYBACK_FOLLOW: {
                if (!isButtonPressed) break;
                this.model.getArranger().togglePlaybackFollow();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_TRACK_ROW_HEIGHT: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleTrackRowHeight();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_CLIP_LAUNCHER_SECTION: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleClipLauncher();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_TIME_LINE: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleTimeLine();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_IO_SECTION: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleIoSection();
                break;
            }
            case LAYOUT_TOGGLE_ARRANGER_EFFECT_TRACKS: {
                if (!isButtonPressed) break;
                this.model.getArranger().toggleEffectTracks();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_CLIP_LAUNCHER_SECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleClipLauncherSectionVisibility();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_CROSS_FADE_SECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleCrossFadeSectionVisibility();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_DEVICE_SECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleDeviceSectionVisibility();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_SENDSSECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleSendsSectionVisibility();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_IO_SECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleIoSectionVisibility();
                break;
            }
            case LAYOUT_TOGGLE_MIXER_METER_SECTION: {
                if (!isButtonPressed) break;
                this.model.getMixer().toggleMeterSectionVisibility();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }
}

